/*
 * Decompiled with CFR 0.152.
 */
package capital.scalable.restdocs.payload;

import capital.scalable.restdocs.payload.AbstractJacksonFieldSnippet;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Type;
import java.util.Map;
import org.springframework.data.domain.Page;
import org.springframework.http.ResponseEntity;
import org.springframework.web.method.HandlerMethod;

public class JacksonResponseFieldSnippet
extends AbstractJacksonFieldSnippet {
    public JacksonResponseFieldSnippet() {
        super("response-fields");
    }

    @Override
    protected Type getType(final HandlerMethod method) {
        Class returnType = method.getReturnType().getParameterType();
        if (returnType == ResponseEntity.class) {
            return this.firstGenericType(method.getReturnType());
        }
        if (returnType == Page.class) {
            return this.firstGenericType(method.getReturnType());
        }
        if (this.isCollection(returnType)) {
            return new GenericArrayType(){

                @Override
                public Type getGenericComponentType() {
                    return JacksonResponseFieldSnippet.this.firstGenericType(method.getReturnType());
                }
            };
        }
        if ("void".equals(returnType.getName())) {
            return null;
        }
        return returnType;
    }

    @Override
    protected void enrichModel(Map<String, Object> model, HandlerMethod handlerMethod) {
        model.put("isPagedResponse", handlerMethod != null && this.isPageResponse(handlerMethod));
    }

    private boolean isPageResponse(HandlerMethod handlerMethod) {
        return handlerMethod.getReturnType().getParameterType() == Page.class;
    }

    @Override
    public String getHeader() {
        return "Response fields";
    }
}

