/*
 * Decompiled with CFR 0.152.
 */
package capital.scalable.restdocs.payload;

import capital.scalable.restdocs.OperationAttributeHelper;
import capital.scalable.restdocs.constraints.ConstraintReader;
import capital.scalable.restdocs.jackson.FieldDocumentationGenerator;
import capital.scalable.restdocs.javadoc.JavadocReader;
import capital.scalable.restdocs.payload.JacksonFieldProcessingException;
import capital.scalable.restdocs.section.SectionSupport;
import capital.scalable.restdocs.snippet.StandardTableSnippet;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.core.MethodParameter;
import org.springframework.restdocs.operation.Operation;
import org.springframework.restdocs.payload.FieldDescriptor;
import org.springframework.web.method.HandlerMethod;

abstract class AbstractJacksonFieldSnippet
extends StandardTableSnippet
implements SectionSupport {
    private static Class<?> SCALA_TRAVERSABLE;

    protected AbstractJacksonFieldSnippet(String snippetName) {
        this(snippetName, null);
    }

    protected AbstractJacksonFieldSnippet(String snippetName, Map<String, Object> attributes) {
        super(snippetName, attributes);
    }

    @Override
    protected Collection<FieldDescriptor> createFieldDescriptors(Operation operation, HandlerMethod handlerMethod) {
        ObjectMapper objectMapper = OperationAttributeHelper.getObjectMapper(operation);
        ObjectWriter writer = objectMapper.writer();
        TypeFactory typeFactory = objectMapper.getTypeFactory();
        JavadocReader javadocReader = OperationAttributeHelper.getJavadocReader(operation);
        ConstraintReader constraintReader = OperationAttributeHelper.getConstraintReader(operation);
        LinkedHashMap<String, FieldDescriptor> fieldDescriptors = new LinkedHashMap<String, FieldDescriptor>();
        Type signatureType = this.getType(handlerMethod);
        if (signatureType != null) {
            try {
                for (Type type : this.resolveActualTypes(signatureType)) {
                    this.resolveFieldDescriptors(fieldDescriptors, type, writer, typeFactory, javadocReader, constraintReader);
                }
            }
            catch (JsonMappingException e) {
                throw new JacksonFieldProcessingException("Error while parsing fields", e);
            }
        }
        return fieldDescriptors.values();
    }

    protected Type firstGenericType(MethodParameter param) {
        return ((ParameterizedType)param.getGenericParameterType()).getActualTypeArguments()[0];
    }

    protected abstract Type getType(HandlerMethod var1);

    protected boolean isCollection(Class<?> type) {
        return Collection.class.isAssignableFrom(type) || SCALA_TRAVERSABLE != null && SCALA_TRAVERSABLE.isAssignableFrom(type);
    }

    private Collection<Type> resolveActualTypes(Type type) {
        JsonSubTypes jsonSubTypes;
        if (type instanceof Class && (jsonSubTypes = ((Class)type).getAnnotation(JsonSubTypes.class)) != null) {
            ArrayList<Type> types = new ArrayList<Type>();
            for (JsonSubTypes.Type subType : jsonSubTypes.value()) {
                types.add(subType.value());
            }
            return types;
        }
        return Collections.singletonList(type);
    }

    private void resolveFieldDescriptors(Map<String, FieldDescriptor> fieldDescriptors, Type type, ObjectWriter writer, TypeFactory typeFactory, JavadocReader javadocReader, ConstraintReader constraintReader) throws JsonMappingException {
        FieldDocumentationGenerator generator = new FieldDocumentationGenerator(writer, javadocReader, constraintReader);
        List<FieldDescriptor> descriptors = generator.generateDocumentation(type, typeFactory);
        for (FieldDescriptor descriptor : descriptors) {
            if (fieldDescriptors.get(descriptor.getPath()) != null) continue;
            fieldDescriptors.put(descriptor.getPath(), descriptor);
        }
    }

    @Override
    public String getFileName() {
        return this.getSnippetName();
    }

    @Override
    public boolean hasContent(Operation operation) {
        return this.getType(OperationAttributeHelper.getHandlerMethod(operation)) != null;
    }

    static {
        try {
            SCALA_TRAVERSABLE = Class.forName("scala.collection.Traversable");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }
}

