/*
 * Decompiled with CFR 0.152.
 */
package capital.scalable.restdocs.javadoc;

import capital.scalable.restdocs.javadoc.ClassJavadoc;
import capital.scalable.restdocs.javadoc.JavadocReader;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavadocReaderImpl
implements JavadocReader {
    private static final Logger log = LoggerFactory.getLogger(JavadocReader.class);
    private static final String PATH_DELIMITER = ",";
    private static final String JAVADOC_JSON_DIR_PROPERTY = "org.springframework.restdocs.javadocJsonDir";
    private final Map<String, ClassJavadoc> classCache = new ConcurrentHashMap<String, ClassJavadoc>();
    private final ObjectMapper mapper;
    private final List<File> absoluteBaseDirs;

    private JavadocReaderImpl(ObjectMapper mapper, List<File> absoluteBaseDirs) {
        this.mapper = mapper;
        this.absoluteBaseDirs = absoluteBaseDirs;
    }

    public static JavadocReaderImpl createWithSystemProperty() {
        String systemProperty = System.getProperties().getProperty(JAVADOC_JSON_DIR_PROPERTY);
        return new JavadocReaderImpl(JavadocReaderImpl.objectMapper(), JavadocReaderImpl.toAbsoluteDirs(systemProperty));
    }

    static JavadocReaderImpl createWith(String javadocJsonDir) {
        return new JavadocReaderImpl(JavadocReaderImpl.objectMapper(), JavadocReaderImpl.toAbsoluteDirs(javadocJsonDir));
    }

    @Override
    public String resolveFieldComment(Class<?> javaBaseClass, String javaFieldName) {
        return this.classJavadoc(javaBaseClass).getFieldComment(javaFieldName);
    }

    @Override
    public String resolveMethodComment(Class<?> javaBaseClass, String javaMethodName) {
        return this.classJavadoc(javaBaseClass).getMethodComment(javaMethodName);
    }

    @Override
    public String resolveMethodParameterComment(Class<?> javaBaseClass, String javaMethodName, String javaParameterName) {
        return this.classJavadoc(javaBaseClass).getMethodParameterComment(javaMethodName, javaParameterName);
    }

    private ClassJavadoc classJavadoc(Class<?> clazz) {
        String relativePath = this.classToRelativePath(clazz);
        ClassJavadoc classJavadocFromCache = this.classCache.get(relativePath);
        if (classJavadocFromCache != null) {
            return classJavadocFromCache;
        }
        ClassJavadoc classJavadoc = this.readFiles(clazz, relativePath);
        this.classCache.put(relativePath, classJavadoc);
        return classJavadoc;
    }

    private String classToRelativePath(Class<?> clazz) {
        String packageName = clazz.getPackage().getName();
        String packageDir = packageName.replace(".", File.separator);
        String className = clazz.getCanonicalName().replaceAll(packageName + "\\.?", "");
        return new File(packageDir, className + ".json").getPath();
    }

    private ClassJavadoc readFiles(Class<?> clazz, String relativePath) {
        if (this.absoluteBaseDirs.isEmpty()) {
            ClassJavadoc classJavadoc = this.readFile(new File(relativePath));
            if (classJavadoc != null) {
                return classJavadoc;
            }
        } else {
            for (File dir : this.absoluteBaseDirs) {
                ClassJavadoc classJavadoc = this.readFile(new File(dir, relativePath));
                if (classJavadoc == null) continue;
                return classJavadoc;
            }
        }
        log.warn("No Javadoc found for class {}", (Object)clazz.getCanonicalName());
        return new ClassJavadoc();
    }

    private ClassJavadoc readFile(File docSource) {
        try {
            return (ClassJavadoc)this.mapper.readerFor(ClassJavadoc.class).readValue(docSource);
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException e) {
            log.error("Failed to read file {}", (Object)docSource.getName(), (Object)e);
        }
        return null;
    }

    private static ObjectMapper objectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.setVisibility(mapper.getSerializationConfig().getDefaultVisibilityChecker().withFieldVisibility(JsonAutoDetect.Visibility.ANY).withGetterVisibility(JsonAutoDetect.Visibility.NONE).withSetterVisibility(JsonAutoDetect.Visibility.NONE).withCreatorVisibility(JsonAutoDetect.Visibility.NONE));
        return mapper;
    }

    private static List<File> toAbsoluteDirs(String javadocJsonDirs) {
        ArrayList<File> absoluteDirs = new ArrayList<File>();
        if (StringUtils.isNotBlank((CharSequence)javadocJsonDirs)) {
            String[] dirs;
            for (String dir : dirs = StringUtils.split((String)javadocJsonDirs, (String)PATH_DELIMITER)) {
                if (!StringUtils.isNotBlank((CharSequence)dir)) continue;
                absoluteDirs.add(new File(dir.trim()).getAbsoluteFile());
            }
        }
        return absoluteDirs;
    }
}

