/*
 * Decompiled with CFR 0.152.
 */
package capital.scalable.restdocs.constraints;

import capital.scalable.restdocs.constraints.MethodParameterConstraintResolver;
import capital.scalable.restdocs.util.ObjectUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.MethodParameter;
import org.springframework.restdocs.constraints.Constraint;

class HumanReadableConstraintResolver
implements MethodParameterConstraintResolver {
    private static final Logger log = LoggerFactory.getLogger(HumanReadableConstraintResolver.class);
    private static final String[] IGNORED_FIELDS = new String[]{"groups", "payload"};
    private final MethodParameterConstraintResolver delegate;
    private final Set<String> ignoredFields;

    public HumanReadableConstraintResolver(MethodParameterConstraintResolver delegate) {
        this.delegate = delegate;
        this.ignoredFields = new HashSet<String>();
        Collections.addAll(this.ignoredFields, IGNORED_FIELDS);
    }

    public List<Constraint> resolveForProperty(String property, Class<?> clazz) {
        ArrayList<Constraint> result = new ArrayList<Constraint>();
        for (Constraint constraint : this.delegate.resolveForProperty(property, clazz)) {
            result.add(new Constraint(constraint.getName(), this.extendConfiguration(constraint.getConfiguration())));
        }
        return result;
    }

    @Override
    public List<Constraint> resolveForParameter(MethodParameter param) {
        ArrayList<Constraint> result = new ArrayList<Constraint>();
        for (Constraint constraint : this.delegate.resolveForParameter(param)) {
            result.add(new Constraint(constraint.getName(), this.extendConfiguration(constraint.getConfiguration())));
        }
        return result;
    }

    private Map<String, Object> extendConfiguration(Map<String, Object> configuration) {
        HashMap<String, Object> extendedConfiguration = new HashMap<String, Object>();
        for (Map.Entry<String, Object> e : configuration.entrySet()) {
            if (this.ignoredFields.contains(e.getKey())) {
                extendedConfiguration.put(e.getKey(), e.getValue());
                continue;
            }
            extendedConfiguration.put(e.getKey(), this.humanReadableString(e.getValue()));
        }
        return extendedConfiguration;
    }

    private String humanReadableString(Object o) {
        if (o instanceof Object[]) {
            return ObjectUtil.arrayToString((Object[])o);
        }
        if (o instanceof Class) {
            try {
                return ((Class)o).newInstance().toString();
            }
            catch (IllegalAccessException | InstantiationException e) {
                log.error("Failed to create an instance of {}", (Object)((Class)o).getCanonicalName(), (Object)e);
                return "Failed to create an instance of " + ((Class)o).getCanonicalName() + ". Does the class have a no args constructor?";
            }
        }
        return o.toString();
    }
}

