/*
 * Decompiled with CFR 0.152.
 */
package capital.scalable.restdocs.request;

import capital.scalable.restdocs.OperationAttributeHelper;
import capital.scalable.restdocs.constraints.ConstraintReader;
import capital.scalable.restdocs.javadoc.JavadocReader;
import capital.scalable.restdocs.snippet.StandardTableSnippet;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.springframework.core.MethodParameter;
import org.springframework.restdocs.operation.Operation;
import org.springframework.restdocs.payload.FieldDescriptor;
import org.springframework.restdocs.payload.PayloadDocumentation;
import org.springframework.restdocs.snippet.Attributes;
import org.springframework.util.StringUtils;
import org.springframework.web.method.HandlerMethod;

abstract class AbstractParameterSnippet<A extends Annotation>
extends StandardTableSnippet {
    protected AbstractParameterSnippet(String snippetName, Map<String, Object> attributes) {
        super(snippetName, attributes);
    }

    protected List<FieldDescriptor> createFieldDescriptors(Operation operation, HandlerMethod handlerMethod) {
        JavadocReader javadocReader = OperationAttributeHelper.getJavadocReader(operation);
        ConstraintReader constraintReader = OperationAttributeHelper.getConstraintReader(operation);
        ArrayList<FieldDescriptor> fieldDescriptors = new ArrayList<FieldDescriptor>();
        for (MethodParameter param : handlerMethod.getMethodParameters()) {
            A annot = this.getAnnotation(param);
            if (annot == null) continue;
            this.addFieldDescriptor(handlerMethod, javadocReader, constraintReader, fieldDescriptors, param, annot);
        }
        return fieldDescriptors;
    }

    private void addFieldDescriptor(HandlerMethod handlerMethod, JavadocReader javadocReader, ConstraintReader constraintReader, List<FieldDescriptor> fieldDescriptors, MethodParameter param, A annot) {
        String javaParameterName = param.getParameterName();
        String pathName = this.getPath(annot);
        String parameterName = StringUtils.hasLength((String)pathName) ? pathName : javaParameterName;
        String parameterType = param.getParameterType().getSimpleName();
        String description = javadocReader.resolveMethodParameterComment(handlerMethod.getBeanType(), handlerMethod.getMethod().getName(), javaParameterName);
        FieldDescriptor descriptor = (FieldDescriptor)PayloadDocumentation.fieldWithPath((String)parameterName).type((Object)parameterType).description((Object)description);
        Attributes.Attribute constraints = this.constraintAttribute(param, constraintReader);
        Attributes.Attribute optionals = this.optionalsAttribute(param, annot);
        descriptor.attributes(new Attributes.Attribute[]{constraints, optionals});
        fieldDescriptors.add(descriptor);
    }

    protected Attributes.Attribute constraintAttribute(MethodParameter param, ConstraintReader constraintReader) {
        return new Attributes.Attribute("constraints", constraintReader.getConstraintMessages(param));
    }

    protected Attributes.Attribute optionalsAttribute(MethodParameter param, A annot) {
        return new Attributes.Attribute("optionals", Collections.singletonList(!this.isRequired(annot)));
    }

    protected abstract boolean isRequired(A var1);

    protected abstract String getPath(A var1);

    abstract A getAnnotation(MethodParameter var1);
}

