/*
 * Decompiled with CFR 0.152.
 */
package capital.scalable.restdocs.snippet;

import capital.scalable.restdocs.OperationAttributeHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.restdocs.operation.Operation;
import org.springframework.restdocs.payload.FieldDescriptor;
import org.springframework.restdocs.snippet.TemplatedSnippet;
import org.springframework.web.method.HandlerMethod;

public abstract class StandardTableSnippet
extends TemplatedSnippet {
    private static final String TABLE_LINE_BREAK = " +\n";

    protected StandardTableSnippet(String snippetName, Map<String, Object> attributes) {
        super(snippetName, attributes);
    }

    protected Map<String, Object> createModel(Operation operation) {
        HandlerMethod handlerMethod = OperationAttributeHelper.getHandlerMethod(operation);
        Collection<FieldDescriptor> fieldDescriptors = Collections.emptyList();
        if (handlerMethod != null) {
            fieldDescriptors = this.createFieldDescriptors(operation, handlerMethod);
        }
        return this.createModel(handlerMethod, fieldDescriptors);
    }

    protected abstract Collection<FieldDescriptor> createFieldDescriptors(Operation var1, HandlerMethod var2);

    protected void enrichModel(Map<String, Object> model, HandlerMethod handlerMethod) {
    }

    private Map<String, Object> createModel(HandlerMethod handlerMethod, Collection<FieldDescriptor> fieldDescriptors) {
        HashMap<String, Object> model = new HashMap<String, Object>();
        this.enrichModel(model, handlerMethod);
        ArrayList<Map<String, Object>> fields = new ArrayList<Map<String, Object>>();
        model.put("content", fields);
        for (FieldDescriptor descriptor : fieldDescriptors) {
            fields.add(this.createModelForDescriptor(descriptor));
        }
        model.put("hasContent", !fieldDescriptors.isEmpty());
        model.put("noContent", fieldDescriptors.isEmpty());
        return model;
    }

    protected Map<String, Object> createModelForDescriptor(FieldDescriptor descriptor) {
        String path = descriptor.getPath();
        String type = this.stringOrEmpty(descriptor.getType());
        String description = this.stringOrEmpty(descriptor.getDescription());
        List optionalMessages = (List)descriptor.getAttributes().get("optionals");
        String optional = "" + StringUtils.join((Iterable)optionalMessages, (String)TABLE_LINE_BREAK);
        List constraints = (List)descriptor.getAttributes().get("constraints");
        if (constraints != null && !constraints.isEmpty()) {
            description = description + TABLE_LINE_BREAK + StringUtils.join((Iterable)constraints, (String)TABLE_LINE_BREAK);
        }
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("path", path);
        model.put("type", type);
        model.put("optional", optional);
        model.put("description", description);
        return model;
    }

    private String stringOrEmpty(Object value) {
        if (value != null) {
            return value.toString();
        }
        return "";
    }
}

