/*
 * Decompiled with CFR 0.152.
 */
package capital.scalable.restdocs.javadoc;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

class ClassJavadoc {
    private String comment;
    private Map<String, FieldJavadoc> fields = new HashMap<String, FieldJavadoc>();
    private Map<String, MethodJavadoc> methods = new HashMap<String, MethodJavadoc>();

    ClassJavadoc() {
    }

    public String getClassComment() {
        return this.comment;
    }

    public String getFieldComment(String fieldName) {
        FieldJavadoc fieldJavadoc = this.fields.get(fieldName);
        if (fieldJavadoc != null) {
            return StringUtils.trimToEmpty((String)fieldJavadoc.getComment());
        }
        return "";
    }

    public String getMethodComment(String methodName) {
        MethodJavadoc methodJavadoc = this.methods.get(methodName);
        if (methodJavadoc != null) {
            return StringUtils.trimToEmpty((String)methodJavadoc.getComment());
        }
        return "";
    }

    public String getMethodParameterComment(String methodName, String parameterName) {
        MethodJavadoc methodJavadoc = this.methods.get(methodName);
        if (methodJavadoc != null) {
            return StringUtils.trimToEmpty((String)methodJavadoc.getParameterComment(parameterName));
        }
        return "";
    }

    public String getMethodTag(String javaMethodName, String tagName) {
        MethodJavadoc methodJavadoc = this.methods.get(javaMethodName);
        if (methodJavadoc != null) {
            return StringUtils.trimToEmpty((String)methodJavadoc.getTag(tagName));
        }
        return "";
    }

    public String getFieldTag(String javaFieldName, String tagName) {
        FieldJavadoc fieldJavadoc = this.fields.get(javaFieldName);
        if (fieldJavadoc != null) {
            return StringUtils.trimToEmpty((String)fieldJavadoc.getTag(tagName));
        }
        return "";
    }

    static class FieldJavadoc {
        private String comment;
        private Map<String, String> tags = new HashMap<String, String>();

        FieldJavadoc() {
        }

        public String getComment() {
            return this.comment;
        }

        public String getTag(String tagName) {
            return this.tags.get(tagName);
        }
    }

    static class MethodJavadoc {
        private String comment;
        private Map<String, String> parameters = new HashMap<String, String>();
        private Map<String, String> tags = new HashMap<String, String>();

        MethodJavadoc() {
        }

        public String getComment() {
            return this.comment;
        }

        public String getParameterComment(String parameterName) {
            return this.parameters.get(parameterName);
        }

        public String getTag(String tagName) {
            return this.tags.get(tagName);
        }
    }
}

