/*
 * Decompiled with CFR 0.152.
 */
package capital.scalable.restdocs.util;

import capital.scalable.restdocs.util.FieldUtil;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.ArrayType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.ReflectionUtils;

public class TypeUtil {
    private TypeUtil() {
    }

    public static String determineTypeName(Class<?> type) {
        boolean isArray = false;
        String canonicalName = ClassUtils.primitiveToWrapper(type).getCanonicalName();
        if (canonicalName.endsWith("[]")) {
            isArray = true;
            canonicalName = StringUtils.chop((String)StringUtils.chop((String)canonicalName));
        }
        String finalName = TypeUtil.getSimpleName(canonicalName);
        if (isArray) {
            return "Array[" + finalName + "]";
        }
        return finalName;
    }

    public static String determineArrayOfType(JavaType contentType) {
        if (contentType != null) {
            return "Array[" + TypeUtil.determineTypeName(contentType.getRawClass()) + "]";
        }
        return "Array[Object]";
    }

    private static String getSimpleName(String canonicalName) {
        switch (canonicalName) {
            case "java.lang.Byte": 
            case "java.lang.Short": 
            case "java.lang.Long": 
            case "java.lang.Integer": 
            case "java.math.BigInteger": {
                return "Integer";
            }
            case "java.lang.Float": 
            case "java.lang.Double": 
            case "java.math.BigDecimal": {
                return "Decimal";
            }
            case "java.lang.Character": 
            case "java.lang.String": {
                return "String";
            }
            case "java.lang.Boolean": {
                return "Boolean";
            }
        }
        return "Object";
    }

    public static boolean isPrimitive(Class<?> javaBaseClass, String javaFieldName) {
        Field field = ReflectionUtils.findField(javaBaseClass, (String)javaFieldName);
        if (field == null && FieldUtil.isGetter(javaFieldName)) {
            field = ReflectionUtils.findField(javaBaseClass, (String)FieldUtil.fromGetter(javaFieldName));
        }
        return field != null ? field.getType().isPrimitive() : false;
    }

    public static List<JavaType> resolveAllTypes(JavaType javaType, TypeFactory typeFactory) {
        if (javaType.isCollectionLikeType() || javaType.isArrayType()) {
            return TypeUtil.resolveArrayTypes(javaType.getContentType(), typeFactory);
        }
        return TypeUtil.resolveNonArrayTypes(javaType, typeFactory);
    }

    private static List<JavaType> resolveArrayTypes(JavaType contentType, TypeFactory typeFactory) {
        List<JavaType> contentTypes = TypeUtil.resolveAllTypes(contentType, typeFactory);
        ArrayList<JavaType> result = new ArrayList<JavaType>();
        for (JavaType contentSubType : contentTypes) {
            ArrayType contentSubTypeArray = typeFactory.constructArrayType(contentSubType);
            result.add((JavaType)contentSubTypeArray);
        }
        return result;
    }

    private static List<JavaType> resolveNonArrayTypes(JavaType javaType, TypeFactory typeFactory) {
        ArrayList<JavaType> types = new ArrayList<JavaType>();
        types.add(javaType);
        Class rawClass = javaType.getRawClass();
        JsonSubTypes jsonSubTypes = rawClass.getAnnotation(JsonSubTypes.class);
        if (jsonSubTypes != null) {
            for (JsonSubTypes.Type subType : jsonSubTypes.value()) {
                JavaType javaSubType = typeFactory.constructType((Type)subType.value());
                types.add(javaSubType);
            }
        }
        return types;
    }
}

