/*
 * Decompiled with CFR 0.152.
 */
package capital.scalable.restdocs.snippet;

import capital.scalable.restdocs.OperationAttributeHelper;
import capital.scalable.restdocs.javadoc.JavadocUtil;
import capital.scalable.restdocs.util.FormatUtil;
import capital.scalable.restdocs.util.TemplateFormatting;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.restdocs.operation.Operation;
import org.springframework.restdocs.payload.FieldDescriptor;
import org.springframework.restdocs.snippet.TemplatedSnippet;
import org.springframework.web.method.HandlerMethod;

public abstract class StandardTableSnippet
extends TemplatedSnippet {
    protected StandardTableSnippet(String snippetName, Map<String, Object> attributes) {
        super(snippetName, attributes);
    }

    protected Map<String, Object> createModel(Operation operation) {
        HandlerMethod handlerMethod = OperationAttributeHelper.getHandlerMethod(operation);
        Map<String, Object> model = this.defaultModel();
        if (handlerMethod == null) {
            return model;
        }
        List<FieldDescriptor> fieldDescriptors = Collections.emptyList();
        fieldDescriptors = this.createFieldDescriptors(operation, handlerMethod);
        TemplateFormatting templateFormatting = OperationAttributeHelper.determineTemplateFormatting(operation);
        return this.createModel(handlerMethod, model, fieldDescriptors, templateFormatting);
    }

    protected abstract Collection<FieldDescriptor> createFieldDescriptors(Operation var1, HandlerMethod var2);

    protected void enrichModel(Map<String, Object> model, HandlerMethod handlerMethod) {
    }

    private Map<String, Object> createModel(HandlerMethod handlerMethod, Map<String, Object> model, Collection<FieldDescriptor> fieldDescriptors, TemplateFormatting templateFormatting) {
        ArrayList<Map<String, Object>> fields = new ArrayList<Map<String, Object>>();
        model.put("content", fields);
        for (FieldDescriptor descriptor : fieldDescriptors) {
            fields.add(this.createModelForDescriptor(descriptor, templateFormatting));
        }
        model.put("hasContent", !fieldDescriptors.isEmpty());
        model.put("noContent", fieldDescriptors.isEmpty());
        this.enrichModel(model, handlerMethod);
        return model;
    }

    private Map<String, Object> defaultModel() {
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("content", "");
        model.put("hasContent", false);
        model.put("noContent", true);
        return model;
    }

    protected Map<String, Object> createModelForDescriptor(FieldDescriptor descriptor, TemplateFormatting templateFormatting) {
        String path = descriptor.getPath();
        String type = this.toString(descriptor.getType());
        String methodComment = this.resolveComment(descriptor);
        String deprecated = this.resolveDeprecated(descriptor);
        String description = JavadocUtil.convertFromJavadoc(deprecated + methodComment, templateFormatting);
        String optional = this.resolveOptional(descriptor, templateFormatting);
        List<String> constraints = this.resolveConstraints(descriptor);
        description = this.joinAndFormat(description, constraints, templateFormatting);
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("path", path);
        model.put("type", type);
        model.put("optional", optional);
        model.put("description", description);
        return model;
    }

    private List<String> resolveConstraints(FieldDescriptor descriptor) {
        return (List)descriptor.getAttributes().get("constraints");
    }

    private String resolveOptional(FieldDescriptor descriptor, TemplateFormatting templateFormatting) {
        List optionalMessages = (List)descriptor.getAttributes().get("optionals");
        return "" + StringUtils.join((Iterable)optionalMessages, (String)templateFormatting.getLineBreak());
    }

    private String resolveComment(FieldDescriptor descriptor) {
        return StringUtils.capitalize((String)FormatUtil.addDot(this.toString(descriptor.getDescription())));
    }

    private String resolveDeprecated(FieldDescriptor descriptor) {
        Object deprecated = descriptor.getAttributes().get("deprecated");
        if (deprecated != null) {
            return "<b>Deprecated.</b> " + StringUtils.capitalize((String)FormatUtil.addDot(this.toString(deprecated))) + "<p>";
        }
        return "";
    }

    private String toString(Object value) {
        if (value != null) {
            return StringUtils.trimToEmpty((String)value.toString());
        }
        return "";
    }

    private String joinAndFormat(String description, List<String> constraints, TemplateFormatting templateFormatting) {
        StringBuilder res = new StringBuilder(description);
        if (!description.isEmpty() && !description.endsWith(".")) {
            res.append('.');
        }
        StringBuilder constr = this.formatConstraints(constraints, templateFormatting.getLineBreak());
        if (res.length() > 0 && constr.length() > 0) {
            res.append("\n\n");
        }
        res.append(constr.toString());
        return res.toString().replace("|", "\\|");
    }

    private StringBuilder formatConstraints(List<String> constraints, String forcedLineBreak) {
        StringBuilder res = new StringBuilder();
        for (String constraint : constraints) {
            if (constraint.trim().isEmpty()) continue;
            if (res.length() > 0) {
                res.append(forcedLineBreak);
            }
            res.append(constraint.trim());
            if (constraint.endsWith(".")) continue;
            res.append('.');
        }
        return res;
    }
}

