/*
 * Decompiled with CFR 0.152.
 */
package capital.scalable.restdocs.request;

import capital.scalable.restdocs.request.AbstractParameterSnippet;
import java.util.Map;
import org.springframework.core.MethodParameter;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.method.HandlerMethod;

public class RequestParametersSnippet
extends AbstractParameterSnippet<RequestParam> {
    public static final String REQUEST_PARAMETERS = "auto-request-parameters";
    public static final String SPRING_DATA_PAGEABLE_CLASS = "org.springframework.data.domain.Pageable";
    private final boolean failOnUndocumentedParams;

    public RequestParametersSnippet() {
        this(false);
    }

    public RequestParametersSnippet(boolean failOnUndocumentedParams) {
        super(REQUEST_PARAMETERS, null);
        this.failOnUndocumentedParams = failOnUndocumentedParams;
    }

    public RequestParametersSnippet failOnUndocumentedParams(boolean failOnUndocumentedParams) {
        return new RequestParametersSnippet(failOnUndocumentedParams);
    }

    @Override
    protected boolean isRequired(MethodParameter param, RequestParam annot) {
        return param.getParameterType().isPrimitive() ? "\n\t\t\n\t\t\n\ue000\ue001\ue002\n\t\t\t\t\n".equals(annot.defaultValue()) : annot.required();
    }

    @Override
    protected String getPath(RequestParam annot) {
        return annot.value();
    }

    @Override
    protected RequestParam getAnnotation(MethodParameter param) {
        return (RequestParam)param.getParameterAnnotation(RequestParam.class);
    }

    @Override
    protected void enrichModel(Map<String, Object> model, HandlerMethod handlerMethod) {
        boolean isPageRequest = this.isPageRequest(handlerMethod);
        model.put("isPageRequest", isPageRequest);
        if (isPageRequest) {
            model.put("noContent", false);
        }
    }

    private boolean isPageRequest(HandlerMethod method) {
        for (MethodParameter param : method.getMethodParameters()) {
            if (!this.isPageable(param)) continue;
            return true;
        }
        return false;
    }

    private boolean isPageable(MethodParameter param) {
        return SPRING_DATA_PAGEABLE_CLASS.equals(param.getParameterType().getCanonicalName());
    }

    @Override
    public String getHeader() {
        return "Query parameters";
    }

    @Override
    protected boolean shouldFailOnUndocumentedParams() {
        return this.failOnUndocumentedParams;
    }
}

