/*
 * Decompiled with CFR 0.152.
 */
package capital.scalable.restdocs.misc;

import capital.scalable.restdocs.OperationAttributeHelper;
import capital.scalable.restdocs.javadoc.JavadocReader;
import capital.scalable.restdocs.javadoc.JavadocUtil;
import capital.scalable.restdocs.util.FormatUtil;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.restdocs.operation.Operation;
import org.springframework.restdocs.snippet.TemplatedSnippet;
import org.springframework.web.method.HandlerMethod;

public class DescriptionSnippet
extends TemplatedSnippet {
    public static final String DESCRIPTION = "auto-description";

    public DescriptionSnippet() {
        super(DESCRIPTION, null);
    }

    protected Map<String, Object> createModel(Operation operation) {
        HandlerMethod handlerMethod = OperationAttributeHelper.getHandlerMethod(operation);
        Map<String, Object> model = this.defaultModel();
        if (handlerMethod == null) {
            return model;
        }
        JavadocReader javadocReader = OperationAttributeHelper.getJavadocReader(operation);
        String methodComment = this.resolveComment(handlerMethod, javadocReader);
        String deprecated = this.resolveDeprecated(handlerMethod, javadocReader);
        String description = JavadocUtil.convertFromJavadoc(deprecated + methodComment, OperationAttributeHelper.determineTemplateFormatting(operation));
        model.put("description", description);
        return model;
    }

    private String resolveDeprecated(HandlerMethod handlerMethod, JavadocReader javadocReader) {
        boolean isDeprecated = handlerMethod.getMethod().getAnnotation(Deprecated.class) != null;
        String comment = javadocReader.resolveMethodTag(handlerMethod.getBeanType(), handlerMethod.getMethod().getName(), "deprecated");
        if (isDeprecated || StringUtils.isNotBlank((CharSequence)comment)) {
            comment = StringUtils.capitalize((String)FormatUtil.addDot(comment));
            return "<b>Deprecated.</b> " + comment + "<p>";
        }
        return "";
    }

    private String resolveComment(HandlerMethod handlerMethod, JavadocReader javadocReader) {
        String methodComment = javadocReader.resolveMethodComment(handlerMethod.getBeanType(), handlerMethod.getMethod().getName());
        return StringUtils.capitalize((String)FormatUtil.addDot(methodComment));
    }

    private Map<String, Object> defaultModel() {
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("description", "");
        return model;
    }
}

