/*
 * Decompiled with CFR 0.152.
 */
package ca.mestevens.unity.utils;

import com.google.common.base.Joiner;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;

public class ProcessRunner {
    private Log log;

    public ProcessRunner(Log log) {
        this.log = log;
    }

    public int runProcess(String workingDirectory, String ... strings) throws MojoFailureException {
        try {
            ProcessBuilder processBuilder = new ProcessBuilder(strings);
            if (workingDirectory != null) {
                processBuilder.directory(new File(workingDirectory));
            }
            processBuilder.redirectErrorStream(true);
            Process process = processBuilder.start();
            BufferedReader input = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String line = null;
            while ((line = input.readLine()) != null) {
                this.log.info((CharSequence)line);
            }
            return process.waitFor();
        }
        catch (IOException e) {
            this.log.error((CharSequence)e.getMessage());
            throw new MojoFailureException(e.getMessage());
        }
        catch (InterruptedException e) {
            this.log.error((CharSequence)e.getMessage());
            throw new MojoFailureException(e.getMessage());
        }
    }

    public void runProcessAsync(String ... strings) throws MojoFailureException {
        try {
            Runtime.getRuntime().exec(Joiner.on((String)" ").join((Object[])strings));
        }
        catch (Exception e) {
            this.log.error((CharSequence)"Failed to execute process", (Throwable)e);
            throw new MojoFailureException("Failed to execute process", (Throwable)e);
        }
    }

    public int killProcessWithName(String processName) throws MojoFailureException {
        return this.runProcess(null, "killall", processName);
    }

    public void checkReturnValue(int returnValue) throws MojoFailureException {
        if (returnValue != 0) {
            throw new MojoFailureException("Failed to build project.");
        }
    }
}

