/*
 * Decompiled with CFR 0.152.
 */
package ca.mestevens.unity.utils;

import java.util.List;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyFilter;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.DependencyRequest;
import org.eclipse.aether.resolution.DependencyResolutionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DependencyGatherer {
    private MavenProject project;
    private Log log;
    protected List<RemoteRepository> projectRepos;
    protected RepositorySystem repoSystem;
    protected RepositorySystemSession repoSession;

    public DependencyGatherer(Log log, MavenProject project, List<RemoteRepository> projectRepos, RepositorySystem repoSystem, RepositorySystemSession repoSession) {
        this.log = log;
        this.project = project;
        this.projectRepos = projectRepos;
        this.repoSystem = repoSystem;
        this.repoSession = repoSession;
    }

    public String createAndroidPomDependencySection() throws MojoFailureException {
        String dependencies = "";
        List<ArtifactResult> resolvedArtifacts = this.resolveArtifacts();
        for (ArtifactResult resolvedArtifact : resolvedArtifacts) {
            Artifact artifact = resolvedArtifact.getArtifact();
            if (!artifact.getProperty("type", "").equals("aar")) continue;
            dependencies = dependencies + "<dependency>";
            dependencies = dependencies + "<groupId>" + artifact.getGroupId() + "</groupId>";
            dependencies = dependencies + "<artifactId>" + artifact.getArtifactId() + "</artifactId>";
            dependencies = dependencies + "<version>" + artifact.getVersion() + "</version>";
            dependencies = dependencies + "<type>" + artifact.getProperty("type", "") + "</type>";
            dependencies = dependencies + "</dependency>";
        }
        return dependencies;
    }

    public String createXcodePomDependencySection() throws MojoFailureException {
        String dependencies = "";
        List<ArtifactResult> resolvedArtifacts = this.resolveArtifacts();
        for (ArtifactResult resolvedArtifact : resolvedArtifacts) {
            Artifact artifact = resolvedArtifact.getArtifact();
            if (!artifact.getProperty("type", "").equals("xcode-framework")) continue;
            dependencies = dependencies + "<dependency>";
            dependencies = dependencies + "<groupId>" + artifact.getGroupId() + "</groupId>";
            dependencies = dependencies + "<artifactId>" + artifact.getArtifactId() + "</artifactId>";
            dependencies = dependencies + "<version>" + artifact.getVersion() + "</version>";
            dependencies = dependencies + "<type>" + artifact.getProperty("type", "") + "</type>";
            dependencies = dependencies + "</dependency>";
        }
        return dependencies;
    }

    public List<ArtifactResult> resolveArtifacts() throws MojoFailureException {
        List resolvedArtifacts;
        CollectRequest collectRequest = new CollectRequest();
        DefaultArtifact mainArtifact = new DefaultArtifact(this.project.getArtifact().getId());
        collectRequest.setRoot(new Dependency((Artifact)mainArtifact, "compile"));
        collectRequest.setRepositories(this.projectRepos);
        DependencyRequest dependencyRequest = new DependencyRequest().setCollectRequest(collectRequest);
        dependencyRequest.setFilter(new DependencyFilter((Artifact)mainArtifact){
            final /* synthetic */ Artifact val$mainArtifact;
            {
                this.val$mainArtifact = artifact;
            }

            public boolean accept(DependencyNode node, List<DependencyNode> parents) {
                Artifact nodeArtifact = node.getArtifact();
                return !nodeArtifact.getGroupId().equals(this.val$mainArtifact.getGroupId()) || !nodeArtifact.getArtifactId().equals(this.val$mainArtifact.getArtifactId());
            }
        });
        try {
            resolvedArtifacts = this.repoSystem.resolveDependencies(this.repoSession, dependencyRequest).getArtifactResults();
        }
        catch (DependencyResolutionException e) {
            this.log.error((CharSequence)"Could not resolve dependencies");
            this.log.error((CharSequence)e.getMessage());
            throw new MojoFailureException("Could not resolve dependencies");
        }
        return resolvedArtifacts;
    }

    public String createPomRepositoriesSection() {
        String repositories = "<repositories>";
        for (ArtifactRepository repository : this.project.getRemoteArtifactRepositories()) {
            repositories = repositories + "<repository>";
            repositories = repositories + "<id>" + repository.getId() + "</id>";
            repositories = repositories + "<url>" + repository.getUrl() + "</url>";
            repositories = repositories + "</repository>";
        }
        repositories = repositories + "</repositories>";
        return repositories;
    }
}

