/*
 * Decompiled with CFR 0.152.
 */
package ca.mestevens.unity;

import ca.mestevens.unity.utils.ProcessRunner;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import org.apache.commons.io.FileUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="unity-sync-mono-project")
public class UnitySyncMonoProjectMojo
extends AbstractMojo {
    @Parameter(property="project", readonly=true, required=true)
    public MavenProject project;
    @Parameter(property="unity.path", defaultValue="/Applications/Unity/Unity.app/Contents/MacOS/Unity")
    public String unity;

    public void execute() throws MojoExecutionException, MojoFailureException {
        File scriptFile = null;
        File scriptMetaFile = null;
        try {
            InputStream scriptStream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("SyncMonoProject.cs");
            scriptFile = new File(this.project.getBasedir().getAbsolutePath() + "/Assets/Editor/SyncMonoProject.cs");
            scriptMetaFile = new File(this.project.getBasedir().getAbsolutePath() + "/Assets/Editor/SyncMonoProject.cs.meta");
            FileUtils.copyInputStreamToFile((InputStream)scriptStream, (File)scriptFile);
            scriptStream.close();
            ProcessRunner processRunner = new ProcessRunner(this.getLog());
            ArrayList<String> commandList = new ArrayList<String>();
            commandList.add(this.unity);
            commandList.add("-projectPath");
            commandList.add(this.project.getBasedir().getAbsolutePath());
            commandList.add("-executeMethod");
            commandList.add("ca.mestevens.unity.SyncMonoProject.SyncProject");
            commandList.add("-batchmode");
            commandList.add("-quit");
            commandList.add("-logFile");
            processRunner.killProcessWithName("Unity");
            int returnValue = processRunner.runProcess(null, commandList.toArray(new String[commandList.size()]));
            processRunner.checkReturnValue(returnValue);
        }
        catch (Exception ex) {
            throw new MojoFailureException(ex.getMessage());
        }
        finally {
            if (scriptFile != null && scriptFile.exists()) {
                scriptFile.delete();
            }
            if (scriptMetaFile != null && scriptMetaFile.exists()) {
                scriptMetaFile.delete();
            }
        }
    }
}

