/*
 * Decompiled with CFR 0.152.
 */
package ca.mestevens.unity;

import ca.mestevens.unity.utils.ProcessRunner;
import java.io.File;
import java.io.IOException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.util.FileUtils;

public class UnityDllPackageMojo
extends AbstractMojo {
    public MavenProject project;
    public String unityDllName;
    public MavenProjectHelper mavenProjectHelper;
    public String targetDirectory;

    public void execute() throws MojoFailureException {
        File androidFiles;
        File dllFile = new File(this.targetDirectory + "/" + this.unityDllName + ".dll");
        if (!dllFile.exists()) {
            throw new MojoFailureException("Dll file does not exist: ");
        }
        this.project.getArtifact().setFile(dllFile);
        File iOSFiles = new File(this.project.getBasedir().getAbsolutePath() + "/Plugins/iOS");
        if (iOSFiles.exists()) {
            File zippedFile = new File(this.targetDirectory + "/" + this.unityDllName + ".ios-plugin");
            if (zippedFile.exists()) {
                try {
                    FileUtils.deleteDirectory((File)zippedFile);
                }
                catch (IOException e) {
                    this.getLog().error((CharSequence)"Error deleting directory");
                    this.getLog().error((CharSequence)e.getMessage());
                    throw new MojoFailureException("Error deleting directory");
                }
            }
            File targetFiles = new File(this.targetDirectory + "/" + this.unityDllName + "-ios-plugin");
            try {
                FileUtils.copyDirectory((File)iOSFiles, (File)targetFiles);
            }
            catch (IOException e) {
                this.getLog().error((CharSequence)"Error copying directory");
                this.getLog().error((CharSequence)e.getMessage());
                throw new MojoFailureException("Error copying directory");
            }
            ProcessRunner processRunner = new ProcessRunner(this.getLog());
            int returnValue = processRunner.runProcess(this.targetDirectory + "/" + this.unityDllName + "-ios-plugin", "/bin/sh", "-c", "zip -r ../" + this.unityDllName + ".ios-plugin" + " * -x *.meta -x *.DS_Store");
            if (returnValue != 0) {
                this.getLog().error((CharSequence)("Could not zip file: " + iOSFiles.getAbsolutePath()));
                throw new MojoFailureException("Could not zip file: " + iOSFiles.getAbsolutePath());
            }
            this.mavenProjectHelper.attachArtifact(this.project, "ios-plugin", "ios-plugin", zippedFile);
        }
        if ((androidFiles = new File(this.project.getBasedir().getAbsolutePath() + "/Plugins/Android")).exists()) {
            File zippedFile = new File(this.targetDirectory + "/" + this.unityDllName + ".android-plugin");
            if (zippedFile.exists()) {
                try {
                    FileUtils.deleteDirectory((File)zippedFile);
                }
                catch (IOException e) {
                    this.getLog().error((CharSequence)"Error deleting directory");
                    this.getLog().error((CharSequence)e.getMessage());
                    throw new MojoFailureException("Error deleting directory");
                }
            }
            File targetFiles = new File(this.targetDirectory + "/" + this.unityDllName + "-android-plugin");
            try {
                FileUtils.copyDirectory((File)androidFiles, (File)targetFiles);
            }
            catch (IOException e) {
                this.getLog().error((CharSequence)"Error copying directory");
                this.getLog().error((CharSequence)e.getMessage());
                throw new MojoFailureException("Error copying directory");
            }
            ProcessRunner processRunner = new ProcessRunner(this.getLog());
            int returnValue = processRunner.runProcess(this.targetDirectory + "/" + this.unityDllName + "-android-plugin", "/bin/sh", "-c", "zip -r ../" + this.unityDllName + ".android-plugin" + " * -x *.meta -x *.DS_Store");
            if (returnValue != 0) {
                this.getLog().error((CharSequence)("Could not zip file: " + androidFiles.getAbsolutePath()));
                throw new MojoFailureException("Could not zip file: " + androidFiles.getAbsolutePath());
            }
            this.mavenProjectHelper.attachArtifact(this.project, "android-plugin", "android-plugin", zippedFile);
        }
    }
}

