/*
 * Decompiled with CFR 0.152.
 */
package ca.mestevens.unity;

import ca.mestevens.unity.utils.DependencyGatherer;
import ca.mestevens.unity.utils.ProcessRunner;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.RemoteRepository;

public class UnityAndroidBuildMojo
extends AbstractMojo {
    public String unity;
    public String androidTarget;
    public List<String> scenes;
    public String unityProjectName;
    public MavenProject project;
    protected List<RemoteRepository> projectRepos;
    protected RepositorySystem repoSystem;
    protected RepositorySystemSession repoSession;

    public void execute() throws MojoExecutionException, MojoFailureException {
        File scriptFile = null;
        File scriptMetaFile = null;
        try {
            InputStream scriptStream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("AndroidBuildScript.cs");
            scriptFile = new File(this.project.getBasedir().getAbsolutePath() + "/Assets/Editor/AndroidBuildScript.cs");
            scriptMetaFile = new File(this.project.getBasedir().getAbsolutePath() + "/Assets/Editor/AndroidBuildScript.cs.meta");
            FileUtils.copyInputStreamToFile((InputStream)scriptStream, (File)scriptFile);
            scriptStream.close();
            ProcessRunner processRunner = new ProcessRunner(this.getLog());
            ArrayList<String> commandList = new ArrayList<String>();
            commandList.add(this.unity);
            commandList.add("-projectPath");
            commandList.add(this.project.getBasedir().getAbsolutePath());
            commandList.add("-executeMethod");
            commandList.add("ca.mestevens.unity.AndroidBuildScript.GenerateStudioProject");
            if (this.scenes != null && !this.scenes.isEmpty()) {
                String scenesString = "-Dscenes=";
                for (String scene : this.scenes) {
                    scenesString = scenesString + scene + ",";
                }
                scenesString = scenesString.substring(0, scenesString.length() - 1);
                commandList.add(scenesString);
            }
            commandList.add("-DandroidProjectTargetDirectory=" + this.androidTarget);
            commandList.add("-batchmode");
            commandList.add("-quit");
            commandList.add("-logFile");
            processRunner.killProcessWithName("Unity");
            int returnValue = processRunner.runProcess(null, commandList.toArray(new String[commandList.size()]));
            processRunner.checkReturnValue(returnValue);
            InputStream pomStream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("pom-template-android.xml");
            String pomString = IOUtils.toString((InputStream)pomStream);
            File pomFile = new File(this.project.getBasedir().getAbsolutePath() + "/target/" + this.unityProjectName + "/pom.xml");
            String pomInfoString = "<groupId>" + this.project.getGroupId() + "</groupId>";
            pomInfoString = pomInfoString + "<artifactId>" + this.unityProjectName + "</artifactId>";
            pomInfoString = pomInfoString + "<version>" + this.project.getVersion() + "</version>";
            pomString = pomString.replace("<pomInfo></pomInfo>", pomInfoString);
            DependencyGatherer dependencyGatherer = new DependencyGatherer(this.getLog(), this.project, this.projectRepos, this.repoSystem, this.repoSession);
            String pomDependenciesString = dependencyGatherer.createAndroidPomDependencySection();
            pomString = pomString.replace("<pomDependencies></pomDependencies>", pomDependenciesString);
            String pomRepositoriesString = dependencyGatherer.createPomRepositoriesSection();
            pomString = pomString.replace("<pomRepositories></pomRepositories>", pomRepositoriesString);
            FileUtils.writeStringToFile((File)pomFile, (String)pomString);
        }
        catch (Exception ex) {
            throw new MojoFailureException(ex.getMessage());
        }
        finally {
            if (scriptFile != null && scriptFile.exists()) {
                scriptFile.delete();
            }
            if (scriptMetaFile != null && scriptMetaFile.exists()) {
                scriptMetaFile.delete();
            }
        }
    }
}

