/*
 * Decompiled with CFR 0.152.
 */
package ca.mestevens.unity;

import java.io.File;
import java.io.IOException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.FileUtils;

@Mojo(name="unity-initialize")
public class InitializeMojo
extends AbstractMojo {
    @Parameter(property="project", readonly=true, required=true)
    public MavenProject project;
    @Parameter(property="unity.plugins.directory", defaultValue="Assets/Runtime/Plugins", readonly=true, required=true)
    public String pluginsDirectory;
    @Parameter(property="unity.test.plugins.directory", defaultValue="Assets/Editor/Plugins", readonly=true, required=true)
    public String testPluginsDirectory;
    @Parameter(property="unity.ios.plugins.directory", defaultValue="Assets/Plugins/iOS", readonly=true, required=true)
    public String iosPlusinsDirectory;
    @Parameter(property="unity.android.plugins.directory", defaultValue="Assets/Plugins/Android", readonly=true, required=true)
    public String androidPluginsDirectory;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)"Executing unity:unity-initialize");
        File pluginsDirectoryFile = new File(String.format("%s/%s", this.project.getBasedir(), this.pluginsDirectory));
        File testPluginsDirectoryFile = new File(String.format("%s/%s", this.project.getBasedir(), this.testPluginsDirectory));
        File iosPluginsDirectoryFile = new File(String.format("%s/%s", this.project.getBasedir(), this.iosPlusinsDirectory));
        File androidPluginsDirectoryFile = new File(String.format("%s/%s", this.project.getBasedir(), this.androidPluginsDirectory));
        try {
            if (pluginsDirectoryFile.exists()) {
                FileUtils.deleteDirectory((File)pluginsDirectoryFile);
            }
            if (testPluginsDirectoryFile.exists()) {
                FileUtils.deleteDirectory((File)testPluginsDirectoryFile);
            }
            if (iosPluginsDirectoryFile.exists()) {
                FileUtils.deleteDirectory((File)iosPluginsDirectoryFile);
            }
            if (androidPluginsDirectoryFile.exists()) {
                FileUtils.deleteDirectory((File)androidPluginsDirectoryFile);
            }
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)"Failed to clean up existing plugins directories", (Throwable)e);
            throw new MojoFailureException("Failed to clean up existing plugins directories", (Throwable)e);
        }
        FileUtils.mkdir((String)pluginsDirectoryFile.getAbsolutePath());
        FileUtils.mkdir((String)testPluginsDirectoryFile.getAbsolutePath());
        FileUtils.mkdir((String)iosPluginsDirectoryFile.getAbsolutePath());
        FileUtils.mkdir((String)androidPluginsDirectoryFile.getAbsolutePath());
    }
}

