/*
 * Decompiled with CFR 0.152.
 */
package ca.mestevens.unity;

import ca.mestevens.unity.utils.DependencyGatherer;
import ca.mestevens.unity.utils.ProcessRunner;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.FileUtils;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;

public class FrameworkDependenciesMojo
extends AbstractMojo {
    private static final String UNITY_LIBRARY = "unity-library";
    private static final String DLL = "dll";
    public MavenProject project;
    public String pluginsDirectory;
    protected List<RemoteRepository> projectRepos;
    protected RepositorySystem repoSystem;
    protected RepositorySystemSession repoSession;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)"Starting execution");
        DependencyGatherer dependencyGatherer = new DependencyGatherer(this.getLog(), this.project, this.projectRepos, this.repoSystem, this.repoSession);
        List<ArtifactResult> resolvedArtifacts = dependencyGatherer.resolveArtifacts();
        File resultFile = new File(String.format("%s/%s", this.project.getBasedir(), this.pluginsDirectory));
        this.getLog().info((CharSequence)String.format("Resolved [%s] artifacts, copying to plugins directory [%s]", resolvedArtifacts.size(), resultFile.getAbsolutePath()));
        for (ArtifactResult resolvedArtifact : resolvedArtifacts) {
            ProcessRunner processRunner;
            File zippedFile;
            Artifact a;
            ArtifactResult artifactResult;
            ArtifactRequest request;
            DefaultArtifact ab;
            Artifact artifact = resolvedArtifact.getArtifact();
            String typePropertyValue = artifact.getProperty("type", "");
            this.getLog().info((CharSequence)String.format("Copying artifact [%s:%s:%s:%s] to plugins directory [%s]", artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), typePropertyValue, resultFile.getAbsolutePath()));
            if (typePropertyValue.equals(UNITY_LIBRARY) || typePropertyValue.equals(DLL)) {
                this.copyArtifact(artifact, resultFile);
            }
            if (!typePropertyValue.equals(UNITY_LIBRARY)) continue;
            try {
                ab = new DefaultArtifact(artifact.getGroupId(), artifact.getArtifactId(), "ios-plugin", "ios-plugin", artifact.getVersion());
                request = new ArtifactRequest((Artifact)ab, this.projectRepos, null);
                artifactResult = this.repoSystem.resolveArtifact(this.repoSession, request);
                a = artifactResult.getArtifact();
                zippedFile = a.getFile();
                File iOSPluginsFolder = new File(this.project.getBasedir() + "/Assets/Plugins/iOS");
                processRunner = new ProcessRunner(this.getLog());
                processRunner.runProcess(null, "unzip", "-uo", zippedFile.getAbsolutePath(), "-d", iOSPluginsFolder.getAbsolutePath());
            }
            catch (ArtifactResolutionException e1) {
                this.getLog().error((CharSequence)"Failed to get iOS artifact", (Throwable)e1);
            }
            try {
                ab = new DefaultArtifact(artifact.getGroupId(), artifact.getArtifactId(), "android-plugin", "android-plugin", artifact.getVersion());
                request = new ArtifactRequest((Artifact)ab, this.projectRepos, null);
                artifactResult = this.repoSystem.resolveArtifact(this.repoSession, request);
                a = artifactResult.getArtifact();
                zippedFile = a.getFile();
                File AndroidPluginsFolder = new File(this.project.getBasedir() + "/Assets/Plugins/Android");
                processRunner = new ProcessRunner(this.getLog());
                processRunner.runProcess(null, "unzip", "-uo", zippedFile.getAbsolutePath(), "-d", AndroidPluginsFolder.getAbsolutePath());
            }
            catch (ArtifactResolutionException e1) {
                this.getLog().error((CharSequence)"Failed to get android artifact", (Throwable)e1);
            }
        }
    }

    private void copyArtifact(Artifact artifact, File resultFile) throws MojoFailureException {
        File file = artifact.getFile();
        try {
            FileUtils.copyFileToDirectory((File)file, (File)resultFile);
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)("Problem copying dll " + file.getName() + " to " + resultFile.getAbsolutePath()));
            this.getLog().error((CharSequence)e.getMessage());
            throw new MojoFailureException("Problem copying dll " + file.getName() + " to " + resultFile.getAbsolutePath());
        }
    }
}

