/*
 * Decompiled with CFR 0.152.
 */
package ca.mestevens.unity;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.twdata.maven.mojoexecutor.MojoExecutor;

@Mojo(name="unity-copy-test-dependencies", requiresDependencyResolution=ResolutionScope.TEST)
public class CopyTestDependenciesMojo
extends AbstractMojo {
    @Component
    private MavenProject mavenProject;
    @Component
    private MavenSession mavenSession;
    @Component
    private BuildPluginManager pluginManager;
    @Parameter(property="project.build.directory", required=true, readonly=true)
    private String projectBuildDirectory;
    @Parameter(property="unity.test.plugins.directory", defaultValue="Assets/Editor/Plugins", required=true, readonly=true)
    private String testPluginsDirectory;

    public void execute() throws MojoExecutionException, MojoFailureException {
        MojoExecutor.executeMojo((Plugin)MojoExecutor.plugin((String)MojoExecutor.groupId((String)"org.apache.maven.plugins"), (String)MojoExecutor.artifactId((String)"maven-dependency-plugin"), (String)MojoExecutor.version((String)"2.0")), (String)MojoExecutor.goal((String)"copy-dependencies"), (Xpp3Dom)MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"outputDirectory"), (String)"${project.build.directory}/test-dependency"), MojoExecutor.element((String)MojoExecutor.name((String)"excludeScope"), (String)"compile")}), (MojoExecutor.ExecutionEnvironment)MojoExecutor.executionEnvironment((MavenProject)this.mavenProject, (MavenSession)this.mavenSession, (BuildPluginManager)this.pluginManager));
        File testDependencyDirectoryFile = new File(String.format("%s/test-dependency", this.projectBuildDirectory));
        File testPluginsDirectoryFile = new File(String.format("%s/%s", this.mavenProject.getBasedir(), this.testPluginsDirectory));
        if (!testDependencyDirectoryFile.exists()) {
            this.getLog().info((CharSequence)"No test dependencies detected");
            return;
        }
        try {
            WildcardFileFilter fileFilter = new WildcardFileFilter("*.dll");
            ArrayList testDependencies = Lists.newArrayList((Object[])testDependencyDirectoryFile.listFiles((FileFilter)fileFilter));
            for (File dependency : testDependencies) {
                this.getLog().info((CharSequence)String.format("Copying [%s] to [%s]", dependency.getName(), this.testPluginsDirectory));
                FileUtils.copyFileToDirectory((File)dependency, (File)testPluginsDirectoryFile);
            }
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)"Failed to copy dependencies", (Throwable)e);
            throw new MojoFailureException("Failed to copy dependencies", (Throwable)e);
        }
    }
}

