/*
 * Decompiled with CFR 0.152.
 */
package ca.mestevens.unity;

import ca.mestevens.unity.utils.ProcessRunner;
import java.util.ArrayList;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;

public class AndroidCreateApkMojo
extends AbstractMojo {
    public String unityProjectName;
    public MavenProject project;
    public String avdDeviceName;
    public boolean startEmulator;
    public String emulatorWaitTime;
    public boolean deployToDevices;

    public void execute() throws MojoExecutionException, MojoFailureException {
        ProcessRunner processRunner = new ProcessRunner(this.getLog());
        String workingDirectory = this.project.getBasedir().getAbsolutePath() + "/target/" + this.unityProjectName;
        ArrayList<String> commandList = new ArrayList<String>();
        commandList.add("mvn");
        commandList.add("clean");
        commandList.add("package");
        if (this.startEmulator) {
            commandList.add("android:emulator-start");
            commandList.add("-Dandroid.emulator.avd=" + this.avdDeviceName);
            commandList.add("-Dandroid.emulator.wait=" + this.emulatorWaitTime);
        }
        if (this.deployToDevices) {
            commandList.add("android:deploy");
        }
        processRunner.killProcessWithName("Unity");
        int returnValue = processRunner.runProcess(workingDirectory, commandList.toArray(new String[commandList.size()]));
        processRunner.checkReturnValue(returnValue);
    }
}

