/*
 * Decompiled with CFR 0.152.
 */
package ca.mestevens.java.dynamic.configuration.guice;

import ca.mestevens.java.dynamic.configuration.ObservableConfig;
import ca.mestevens.java.dynamic.configuration.data.ConfigAccess;
import ca.mestevens.java.dynamic.configuration.data.S3ConfigAccess;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSCredentialsProviderChain;
import com.amazonaws.auth.EnvironmentVariableCredentialsProvider;
import com.amazonaws.auth.InstanceProfileCredentialsProvider;
import com.amazonaws.auth.SystemPropertiesCredentialsProvider;
import com.amazonaws.auth.profile.ProfileCredentialsProvider;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3Client;
import com.google.inject.AbstractModule;
import com.google.inject.name.Names;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.lang.annotation.Annotation;
import java.time.Duration;

public class ObservableConfigS3Module
extends AbstractModule {
    private final Duration pollTime;
    private final String bucket;
    private final String key;
    private final boolean bindConfig;
    private final boolean bindAmazonS3;

    public ObservableConfigS3Module(Duration pollTime, String bucket, String key) {
        this(pollTime, bucket, key, true, true);
    }

    public ObservableConfigS3Module(Duration pollTime, String bucket, String key, boolean bindConfig) {
        this(pollTime, bucket, key, bindConfig, true);
    }

    public ObservableConfigS3Module(Duration pollTime, String bucket, String key, boolean bindConfig, boolean bindAmazonS3) {
        this.pollTime = pollTime;
        this.bucket = bucket;
        this.key = key;
        this.bindConfig = bindConfig;
        this.bindAmazonS3 = bindAmazonS3;
    }

    protected void configure() {
        this.bind(ObservableConfig.class).asEagerSingleton();
        this.bind(ConfigAccess.class).to(S3ConfigAccess.class);
        this.bind(Long.class).annotatedWith((Annotation)Names.named((String)"dynamic.configuration.poll.time")).toInstance((Object)this.pollTime.getSeconds());
        this.bind(String.class).annotatedWith((Annotation)Names.named((String)"dynamic.configuration.s3.bucket")).toInstance((Object)this.bucket);
        this.bind(String.class).annotatedWith((Annotation)Names.named((String)"dynamic.configuration.s3.key")).toInstance((Object)this.key);
        if (this.bindConfig) {
            this.bind(Config.class).toInstance((Object)ConfigFactory.load());
        }
        if (this.bindAmazonS3) {
            AWSCredentialsProviderChain awsCredentialsProviderChain = new AWSCredentialsProviderChain(new AWSCredentialsProvider[]{new ProfileCredentialsProvider(), new EnvironmentVariableCredentialsProvider(), new SystemPropertiesCredentialsProvider(), new InstanceProfileCredentialsProvider()});
            AmazonS3Client amazonS3 = new AmazonS3Client((AWSCredentialsProvider)awsCredentialsProviderChain);
            this.bind(AmazonS3.class).toInstance((Object)amazonS3);
        }
    }
}

