/*
 * Decompiled with CFR 0.152.
 */
package ca.mestevens.java.dynamic.configuration.data;

import ca.mestevens.java.dynamic.configuration.data.ConfigAccess;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.S3Object;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S3ConfigAccess
implements ConfigAccess {
    private static final Logger log = LoggerFactory.getLogger(S3ConfigAccess.class);
    private final AmazonS3 s3Client;
    private final String bucket;
    private final String key;

    @Inject
    public S3ConfigAccess(AmazonS3 s3Client, @Named(value="dynamic.configuration.s3.bucket") String bucket, @Named(value="dynamic.configuration.s3.key") String key) {
        this.s3Client = s3Client;
        this.bucket = bucket;
        this.key = key;
    }

    @Override
    public Config getConfig() {
        S3Object s3 = this.s3Client.getObject(this.bucket, this.key);
        log.info("Successfully got the config from S3.");
        return ConfigFactory.parseReader((Reader)new InputStreamReader((InputStream)s3.getObjectContent()));
    }
}

