/*
 * Decompiled with CFR 0.152.
 */
package ca.mestevens.java.dynamic.configuration;

import ca.mestevens.java.dynamic.configuration.data.ConfigAccess;
import ca.mestevens.java.dynamic.configuration.model.ActionIdentifier;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigMergeable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;
import rx.functions.Action1;

public class ObservableConfig {
    private static final Logger log = LoggerFactory.getLogger(ObservableConfig.class);
    private Config config;
    private final ConfigAccess configAccess;
    private final Long pollTime;
    private final Map<String, List<ActionIdentifier>> subscribeValues;

    @Inject
    public ObservableConfig(Config initialConfig, ConfigAccess configAccess, @Named(value="dynamic.configuration.poll.time") Long pollTime) {
        this.config = initialConfig;
        this.configAccess = configAccess;
        this.pollTime = pollTime;
        this.subscribeValues = new HashMap<String, List<ActionIdentifier>>();
        this.createObservable().repeatWhen(this::shouldRepeat).subscribe(this::subscription);
    }

    private Observable<Config> createObservable() {
        return Observable.create(subscriber -> {
            try {
                Config s3Config = this.configAccess.getConfig();
                Config mergedConfig = s3Config.withFallback((ConfigMergeable)this.config);
                subscriber.onNext((Object)mergedConfig);
            }
            catch (Exception ex) {
                log.error("Problem getting the config from S3: {}", (Object)ex.getMessage());
            }
        });
    }

    private Observable<Long> shouldRepeat(Observable<? extends Void> observable) {
        return Observable.interval((long)this.pollTime, (TimeUnit)TimeUnit.SECONDS);
    }

    private void subscription(Config newConfig) {
        this.subscribeValues.keySet().stream().forEach(key -> {
            try {
                Object object = newConfig.getAnyRef(key);
                if (this.isObjectUpdated(object, (String)key)) {
                    log.info("Key {} was updated in new config, updating subscribers.", key);
                    List<ActionIdentifier> actions = this.subscribeValues.get(key);
                    actions.stream().forEach(actionIdentifier -> actionIdentifier.getAction().call(object));
                }
            }
            catch (ConfigException.Missing ex) {
                log.debug("Key {} was not found in new config.", key);
            }
        });
        this.config = newConfig;
    }

    private boolean isObjectUpdated(Object object, String key) {
        try {
            Object oldObject = this.config.getAnyRef(key);
            return object.equals(oldObject);
        }
        catch (ConfigException.Missing ex) {
            log.debug("Key {} was not found in old config.", (Object)key);
            return false;
        }
    }

    public <T> String subscribe(String key, Action1<T> action) {
        ActionIdentifier actionIdentifier = new ActionIdentifier(action);
        if (this.subscribeValues.containsKey(key)) {
            this.subscribeValues.get(key).add(actionIdentifier);
        } else {
            ArrayList<ActionIdentifier> actionList = new ArrayList<ActionIdentifier>();
            actionList.add(actionIdentifier);
            this.subscribeValues.put(key, actionList);
        }
        String identifier = actionIdentifier.getIdentifier();
        log.info("Identifier {} subscribed to key {}.", (Object)identifier, (Object)key);
        return identifier;
    }

    public void unsubscribe(String key, String identifier) {
        if (this.subscribeValues.containsKey(key)) {
            this.subscribeValues.put(key, this.subscribeValues.get(key).stream().filter(actionIdentifier -> !actionIdentifier.getIdentifier().equals(identifier)).collect(Collectors.toList()));
            log.info("Identifier {} unsubscribed to key {}.", (Object)key);
        }
    }

    public Config getConfig() {
        return this.config;
    }
}

