/*
 * Decompiled with CFR 0.152.
 */
package ca.mestevens.ios.xcode.parser.models;

import ca.mestevens.ios.xcode.parser.exceptions.FileReferenceDoesNotExistException;
import ca.mestevens.ios.xcode.parser.exceptions.InvalidObjectFormatException;
import ca.mestevens.ios.xcode.parser.models.CommentedIdentifier;
import ca.mestevens.ios.xcode.parser.models.PBXBuildFile;
import ca.mestevens.ios.xcode.parser.models.PBXBuildPhase;
import ca.mestevens.ios.xcode.parser.models.PBXContainerItemProxy;
import ca.mestevens.ios.xcode.parser.models.PBXFileElement;
import ca.mestevens.ios.xcode.parser.models.PBXProject;
import ca.mestevens.ios.xcode.parser.models.PBXTarget;
import ca.mestevens.ios.xcode.parser.models.PBXTargetDependency;
import ca.mestevens.ios.xcode.parser.models.XCBuildConfiguration;
import ca.mestevens.ios.xcode.parser.models.XCConfigurationList;
import ca.mestevens.ios.xcode.parser.utils.ObjectParser;
import java.beans.ConstructorProperties;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XCodeProject {
    public Integer archiveVersion;
    public List<String> classes;
    public Integer objectVersion;
    public List<PBXBuildFile> buildFiles;
    public PBXContainerItemProxy containerItemProxy;
    public List<PBXFileElement> fileReferences;
    public List<PBXBuildPhase> frameworksBuildPhases;
    public List<PBXFileElement> groups;
    public List<PBXTarget> nativeTargets;
    public List<PBXTarget> aggregateTargets;
    public List<PBXTarget> legacyTargets;
    public PBXProject project;
    public List<PBXBuildPhase> resourcesBuildPhases;
    public List<PBXBuildPhase> sourcesBuildPhases;
    public PBXTargetDependency targetDependency;
    public List<PBXFileElement> variantGroups;
    public List<XCBuildConfiguration> buildConfigurations;
    public List<XCConfigurationList> configurationLists;
    public List<PBXBuildPhase> appleScriptBuildPhases;
    public List<PBXBuildPhase> copyFilesBuildPhases;
    public List<PBXBuildPhase> headersBuildPhases;
    public List<PBXBuildPhase> shellScriptBuildPhases;
    public CommentedIdentifier rootObject;

    public XCodeProject(String projectPath) throws InvalidObjectFormatException {
        if (projectPath.endsWith(".xcodeproj")) {
            projectPath.concat("/project.pbxproj");
        } else if (!projectPath.endsWith(".pbxproj")) {
            throw new InvalidObjectFormatException("Invalid xcodeproj or pbxproj path.");
        }
        try {
            Path path = Paths.get(projectPath, new String[0]);
            String projectString = new String(Files.readAllBytes(path));
            projectString = projectString.trim();
            projectString = projectString.substring(projectString.indexOf(123) + 1);
            ObjectParser parser = new ObjectParser(projectString);
            String nextObject = parser.parseNextObject();
            while (nextObject != null) {
                nextObject = nextObject.substring(0, nextObject.length() - 1);
                String[] splitObject = nextObject.split("=");
                String key = splitObject[0].trim();
                String value = "";
                for (int i = 1; i < splitObject.length; ++i) {
                    if (i > 1) {
                        value = value + "=";
                    }
                    value = value + splitObject[i];
                }
                value = value.trim();
                if (key.equals("archiveVersion")) {
                    this.archiveVersion = Integer.valueOf(value);
                } else if (key.equals("classes")) {
                    this.classes = new ArrayList<String>();
                } else if (key.equals("objectVersion")) {
                    this.objectVersion = Integer.valueOf(value);
                } else if (key.equals("rootObject")) {
                    this.rootObject = parser.getCommentedIdentifier(value);
                } else if (key.equals("objects")) {
                    String section = this.getSection(value, "PBXBuildFile");
                    this.buildFiles = this.getList(PBXBuildFile.class, section);
                    section = this.getSection(value, "PBXContainerItemProxy");
                    this.containerItemProxy = this.getObject(PBXContainerItemProxy.class, section);
                    section = this.getSection(value, "PBXFileReference");
                    this.fileReferences = this.getList(PBXFileElement.class, section);
                    section = this.getSection(value, "PBXFrameworksBuildPhase");
                    this.frameworksBuildPhases = this.getList(PBXBuildPhase.class, section);
                    section = this.getSection(value, "PBXGroup");
                    this.groups = this.getList(PBXFileElement.class, section);
                    section = this.getSection(value, "PBXNativeTarget");
                    this.nativeTargets = this.getList(PBXTarget.class, section);
                    section = this.getSection(value, "PBXAggregateTarget");
                    this.aggregateTargets = this.getList(PBXTarget.class, section);
                    section = this.getSection(value, "PBXLegacyTarget");
                    this.legacyTargets = this.getList(PBXTarget.class, section);
                    section = this.getSection(value, "PBXProject");
                    this.project = this.getObject(PBXProject.class, section);
                    section = this.getSection(value, "PBXResourcesBuildPhase");
                    this.resourcesBuildPhases = this.getList(PBXBuildPhase.class, section);
                    section = this.getSection(value, "PBXSourcesBuildPhase");
                    this.sourcesBuildPhases = this.getList(PBXBuildPhase.class, section);
                    section = this.getSection(value, "PBXTargetDependency");
                    this.targetDependency = this.getObject(PBXTargetDependency.class, section);
                    section = this.getSection(value, "PBXVariantGroup");
                    this.variantGroups = this.getList(PBXFileElement.class, section);
                    section = this.getSection(value, "XCBuildConfiguration");
                    this.buildConfigurations = this.getList(XCBuildConfiguration.class, section);
                    section = this.getSection(value, "XCConfigurationList");
                    this.configurationLists = this.getList(XCConfigurationList.class, section);
                    section = this.getSection(value, "PBXAppleScriptBuildPhase");
                    this.appleScriptBuildPhases = this.getList(PBXBuildPhase.class, section);
                    section = this.getSection(value, "PBXCopyFilesBuildPhase");
                    this.copyFilesBuildPhases = this.getList(PBXBuildPhase.class, section);
                    section = this.getSection(value, "PBXHeadersBuildPhase");
                    this.headersBuildPhases = this.getList(PBXBuildPhase.class, section);
                    section = this.getSection(value, "PBXShellScriptBuildPhase");
                    this.shellScriptBuildPhases = this.getList(PBXBuildPhase.class, section);
                }
                nextObject = parser.parseNextObject();
            }
        }
        catch (Exception ex) {
            throw new InvalidObjectFormatException(ex);
        }
    }

    public String toString() {
        String returnString = "";
        returnString = returnString + "// !$*UTF8*$!\n";
        returnString = returnString + "{\n";
        returnString = returnString + "\tarchiveVersion = " + this.archiveVersion + ";\n";
        returnString = returnString + "\tclasses = {\n";
        for (String clazz : this.classes) {
            returnString = returnString + "\t" + clazz + "\n";
        }
        returnString = returnString + "\t};\n";
        returnString = returnString + "\tobjectVersion = " + this.objectVersion + ";\n";
        returnString = returnString + "\tobjects = {\n\n";
        if (this.buildFiles != null && this.buildFiles.size() > 0) {
            returnString = returnString + "/* Begin PBXBuildFile section */\n";
            for (PBXBuildFile buildFile : this.buildFiles) {
                returnString = returnString + buildFile.toString(2) + "\n";
            }
            returnString = returnString + "/* End PBXBuildFile section */\n\n";
        }
        if (this.containerItemProxy != null) {
            returnString = returnString + "/* Begin PBXContainerItemProxy section */\n";
            returnString = returnString + this.containerItemProxy.toString(2) + "\n";
            returnString = returnString + "/* End PBXContainerItemProxy section */\n\n";
        }
        if (this.fileReferences != null && this.fileReferences.size() > 0) {
            returnString = returnString + "/* Begin PBXFileReference section */\n";
            for (PBXFileElement fileReference : this.fileReferences) {
                returnString = returnString + fileReference.toString(2) + "\n";
            }
            returnString = returnString + "/* End PBXFileReference section */\n\n";
        }
        if (this.frameworksBuildPhases != null && this.frameworksBuildPhases.size() > 0) {
            returnString = returnString + "/* Begin PBXFrameworksBuildPhase section */\n";
            for (PBXBuildPhase frameworksBuildPhase : this.frameworksBuildPhases) {
                returnString = returnString + frameworksBuildPhase.toString(2) + "\n";
            }
            returnString = returnString + "/* End PBXFrameworksBuildPhase section */\n\n";
        }
        if (this.groups != null && this.groups.size() > 0) {
            returnString = returnString + "/* Begin PBXGroup section */\n";
            for (PBXFileElement group : this.groups) {
                returnString = returnString + group.toString(2) + "\n";
            }
            returnString = returnString + "/* End PBXGroup section */\n\n";
        }
        if (this.nativeTargets != null && this.nativeTargets.size() > 0) {
            returnString = returnString + "/* Begin PBXNativeTarget section */\n";
            for (PBXTarget nativeTarget : this.nativeTargets) {
                returnString = returnString + nativeTarget.toString(2) + "\n";
            }
            returnString = returnString + "/* End PBXNativeTarget section */\n\n";
        }
        if (this.aggregateTargets != null && this.aggregateTargets.size() > 0) {
            returnString = returnString + "/* Begin PBXAggregateTarget section */\n";
            for (PBXTarget aggregateTarget : this.aggregateTargets) {
                returnString = returnString + aggregateTarget.toString(2) + "\n";
            }
            returnString = returnString + "/* End PBXAggregateTarget section */\n\n";
        }
        if (this.legacyTargets != null && this.legacyTargets.size() > 0) {
            returnString = returnString + "/* Begin PBXLegacyTarget section */\n";
            for (PBXTarget legacyTarget : this.legacyTargets) {
                returnString = returnString + legacyTarget.toString(2) + "\n";
            }
            returnString = returnString + "/* End PBXLegacyTarget section */\n\n";
        }
        if (this.project != null) {
            returnString = returnString + "/* Begin PBXProject section */\n";
            returnString = returnString + this.project.toString(2) + "\n";
            returnString = returnString + "/* End PBXProject section */\n\n";
        }
        if (this.resourcesBuildPhases != null && this.resourcesBuildPhases.size() > 0) {
            returnString = returnString + "/* Begin PBXResourcesBuildPhase section */\n";
            for (PBXBuildPhase resourcesBuildPhase : this.resourcesBuildPhases) {
                returnString = returnString + resourcesBuildPhase.toString(2) + "\n";
            }
            returnString = returnString + "/* End PBXResourcesBuildPhase section */\n\n";
        }
        if (this.sourcesBuildPhases != null && this.sourcesBuildPhases.size() > 0) {
            returnString = returnString + "/* Begin PBXSourcesBuildPhase section */\n";
            for (PBXBuildPhase sourcesBuildPhase : this.sourcesBuildPhases) {
                returnString = returnString + sourcesBuildPhase.toString(2) + "\n";
            }
            returnString = returnString + "/* End PBXSourcesBuildPhase section */\n\n";
        }
        if (this.targetDependency != null) {
            returnString = returnString + "/* Begin PBXTargetDependency section */\n";
            returnString = returnString + this.targetDependency.toString(2) + "\n";
            returnString = returnString + "/* End PBXTargetDependency section */\n\n";
        }
        if (this.variantGroups != null && this.variantGroups.size() > 0) {
            returnString = returnString + "/* Begin PBXVariantGroup section */\n";
            for (PBXFileElement variantGroup : this.variantGroups) {
                returnString = returnString + variantGroup.toString(2) + "\n";
            }
            returnString = returnString + "/* End PBXVariantGroup section */\n\n";
        }
        if (this.buildConfigurations != null && this.buildConfigurations.size() > 0) {
            returnString = returnString + "/* Begin XCBuildConfiguration section */\n";
            for (XCBuildConfiguration buildConfiguration : this.buildConfigurations) {
                returnString = returnString + buildConfiguration.toString(2) + "\n";
            }
            returnString = returnString + "/* End XCBuildConfiguration section */\n\n";
        }
        if (this.configurationLists != null && this.configurationLists.size() > 0) {
            returnString = returnString + "/* Begin XCConfigurationList section */\n";
            for (XCConfigurationList configurationList : this.configurationLists) {
                returnString = returnString + configurationList.toString(2) + "\n";
            }
            returnString = returnString + "/* End XCConfigurationList section */\n\n";
        }
        if (this.appleScriptBuildPhases != null && this.appleScriptBuildPhases.size() > 0) {
            returnString = returnString + "/* Begin PBXAppleScriptBuildPhase section */\n";
            for (PBXBuildPhase appleScriptBuildPhase : this.appleScriptBuildPhases) {
                returnString = returnString + appleScriptBuildPhase.toString(2) + "\n";
            }
            returnString = returnString + "/* End PBXAppleScriptBuildPhase section */\n\n";
        }
        if (this.copyFilesBuildPhases != null && this.copyFilesBuildPhases.size() > 0) {
            returnString = returnString + "/* Begin PBXCopyFilesBuildPhase section */\n";
            for (PBXBuildPhase copyFilesBuildPhase : this.copyFilesBuildPhases) {
                returnString = returnString + copyFilesBuildPhase.toString(2) + "\n";
            }
            returnString = returnString + "/* End PBXCopyFilesBuildPhase section */\n\n";
        }
        if (this.headersBuildPhases != null && this.headersBuildPhases.size() > 0) {
            returnString = returnString + "/* Begin PBXHeadersBuildPhase section */\n";
            for (PBXBuildPhase headersBuildPhase : this.headersBuildPhases) {
                returnString = returnString + headersBuildPhase.toString(2) + "\n";
            }
            returnString = returnString + "/* End PBXHeadersBuildPhase section */\n\n";
        }
        if (this.shellScriptBuildPhases != null && this.shellScriptBuildPhases.size() > 0) {
            returnString = returnString + "/* Begin PBXShellScriptBuildPhase section */\n";
            for (PBXBuildPhase shellScriptBuildPhase : this.shellScriptBuildPhases) {
                returnString = returnString + shellScriptBuildPhase.toString(2) + "\n";
            }
            returnString = returnString + "/* End PBXShellScriptBuildPhase section */\n\n";
        }
        returnString = returnString + "\t};\n";
        returnString = returnString + "\trootObject = " + this.rootObject.toString() + ";\n";
        returnString = returnString + "}";
        return returnString;
    }

    private String getSection(String body, String sectionName) {
        String endString = "/* End " + sectionName + " section */";
        int startIndex = body.indexOf("/* Begin " + sectionName + " section */");
        int endIndex = body.indexOf(endString);
        if (startIndex == -1 || endIndex == -1) {
            return "";
        }
        return body.substring(startIndex, endIndex + endString.length());
    }

    private <T> T getObject(Class<T> clazz, String section) throws NoSuchMethodException, SecurityException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        if (section == null || section.equals("")) {
            return null;
        }
        ObjectParser objectsParser = new ObjectParser(section);
        String objectString = objectsParser.parseNextObject();
        Constructor<T> constructor = clazz.getConstructor(String.class);
        T object = constructor.newInstance(objectString);
        return object;
    }

    private <T> List<T> getList(Class<T> clazz, String section) throws InvalidObjectFormatException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        ObjectParser objectsParser = new ObjectParser(section);
        String objectString = objectsParser.parseNextObject();
        ArrayList<T> objects = new ArrayList<T>();
        while (objectString != null) {
            Constructor<T> constructor = clazz.getConstructor(String.class);
            T object = constructor.newInstance(objectString);
            objects.add(object);
            objectString = objectsParser.parseNextObject();
        }
        return objects;
    }

    public PBXFileElement createFileReference(String filePath) {
        return this.createFileReference(filePath, "\"<group>\"");
    }

    public PBXFileElement createFileReference(String filePath, String sourceTree) {
        PBXFileElement fileReference = new PBXFileElement(filePath, sourceTree);
        if (!this.fileReferences.contains(fileReference)) {
            this.fileReferences.add(fileReference);
        }
        return fileReference;
    }

    public PBXBuildFile createBuildFileFromFileReferencePath(String filePath) throws FileReferenceDoesNotExistException {
        return this.createBuildFileFromFileReferencePath(filePath, Paths.get(filePath, new String[0]).getFileName().toString());
    }

    public PBXBuildFile createBuildFileFromFileReferencePath(String filePath, String buildFileName) throws FileReferenceDoesNotExistException {
        for (PBXFileElement fileReference : this.fileReferences) {
            if (!fileReference.getPath().equals(filePath)) continue;
            String reference = fileReference.getReference().getIdentifier();
            PBXBuildFile buildFile = new PBXBuildFile(buildFileName, reference);
            if (!this.buildFiles.contains(buildFile)) {
                this.buildFiles.add(buildFile);
            }
            return buildFile;
        }
        throw new FileReferenceDoesNotExistException("No file reference for file at path \"" + filePath + "\" found.");
    }

    public PBXFileElement createGroup(String groupName) {
        String mainGroup;
        String firstGroup = mainGroup = this.project.getMainGroup().getIdentifier();
        for (PBXFileElement group : this.groups) {
            if (!group.getReference().getIdentifier().equals(mainGroup) || group.getChildren().size() <= 0) continue;
            firstGroup = group.getChildren().get(0).getIdentifier();
        }
        return this.createGroup(groupName, new ArrayList<CommentedIdentifier>(), firstGroup);
    }

    public PBXFileElement createGroup(String groupName, String parentGroup) {
        return this.createGroup(groupName, new ArrayList<CommentedIdentifier>(), parentGroup);
    }

    public PBXFileElement createGroup(String groupName, List<CommentedIdentifier> groupChildren, String parentGroup) {
        PBXFileElement group = new PBXFileElement("PBXGroup", groupName, "\"<group>\"");
        for (CommentedIdentifier child : groupChildren) {
            group.addChild(child);
        }
        this.groups.add(group);
        for (PBXFileElement groupElement : this.groups) {
            if (!groupElement.getReference().getIdentifier().equals(parentGroup)) continue;
            groupElement.addChild(group.getReference());
        }
        return group;
    }

    public void addAppleScriptBuildPhase(String targetIdentifier, PBXBuildPhase buildPhase) {
        this.addBuildPhaseToTarget(targetIdentifier, buildPhase.getReference());
        this.appleScriptBuildPhases.add(buildPhase);
    }

    public void addCopyFilesBuildPhase(String targetIdentifier, PBXBuildPhase buildPhase) {
        this.addBuildPhaseToTarget(targetIdentifier, buildPhase.getReference());
        this.copyFilesBuildPhases.add(buildPhase);
    }

    public void addFrameworksBuildPhase(String targetIdentifier, PBXBuildPhase buildPhase) {
        this.addBuildPhaseToTarget(targetIdentifier, buildPhase.getReference());
        this.frameworksBuildPhases.add(buildPhase);
    }

    public void addHeadersBuildPhase(String targetIdentifier, PBXBuildPhase buildPhase) {
        this.addBuildPhaseToTarget(targetIdentifier, buildPhase.getReference());
        this.headersBuildPhases.add(buildPhase);
    }

    public void addResourcesBuildPhase(String targetIdentifier, PBXBuildPhase buildPhase) {
        this.addBuildPhaseToTarget(targetIdentifier, buildPhase.getReference());
        this.resourcesBuildPhases.add(buildPhase);
    }

    public void addShellScriptBuildPhase(String targetIdentifier, PBXBuildPhase buildPhase) {
        this.addBuildPhaseToTarget(targetIdentifier, buildPhase.getReference());
        this.shellScriptBuildPhases.add(buildPhase);
    }

    public void addSourcesBuildPhase(String targetIdentifier, PBXBuildPhase buildPhase) {
        this.addBuildPhaseToTarget(targetIdentifier, buildPhase.getReference());
        this.sourcesBuildPhases.add(buildPhase);
    }

    private void removeBuildPhaseFromTargets(String identifier) {
        block0: for (PBXTarget target : this.nativeTargets) {
            for (CommentedIdentifier buildPhase : target.getBuildPhases()) {
                if (!buildPhase.getIdentifier().equals(identifier)) continue;
                target.getBuildPhases().remove(buildPhase);
                continue block0;
            }
        }
    }

    private void addBuildPhaseToTarget(String targetIdentifier, CommentedIdentifier buildPhaseIdentifier) {
        for (PBXTarget target : this.nativeTargets) {
            if (!target.getReference().getIdentifier().equals(targetIdentifier)) continue;
            target.getBuildPhases().add(buildPhaseIdentifier);
        }
    }

    public PBXBuildPhase getAppleScriptBuildPhaseWithIdentifier(String identifier) {
        return this.getBuildPhaseWithIdentifier(this.appleScriptBuildPhases, identifier);
    }

    public PBXBuildPhase getCopyFilesBuildPhaseWithIdentifier(String identifier) {
        return this.getBuildPhaseWithIdentifier(this.copyFilesBuildPhases, identifier);
    }

    public PBXBuildPhase getFrameworksBuildPhaseWithIdentifier(String identifier) {
        return this.getBuildPhaseWithIdentifier(this.frameworksBuildPhases, identifier);
    }

    public PBXBuildPhase getHeadersBuildPhaseWithIdentifier(String identifier) {
        return this.getBuildPhaseWithIdentifier(this.headersBuildPhases, identifier);
    }

    public PBXBuildPhase getResourcesBuildPhaseWithIdentifier(String identifier) {
        return this.getBuildPhaseWithIdentifier(this.resourcesBuildPhases, identifier);
    }

    public PBXBuildPhase getShellScriptBuildPhaseWithIdentifier(String identifier) {
        return this.getBuildPhaseWithIdentifier(this.shellScriptBuildPhases, identifier);
    }

    public PBXBuildPhase getSourcesBuildPhaseWithIdentifier(String identifier) {
        return this.getBuildPhaseWithIdentifier(this.sourcesBuildPhases, identifier);
    }

    private PBXBuildPhase getBuildPhaseWithIdentifier(List<PBXBuildPhase> buildPhases, String identifier) {
        for (PBXBuildPhase buildPhase : buildPhases) {
            if (!buildPhase.getReference().getIdentifier().equals(identifier)) continue;
            return buildPhase;
        }
        return null;
    }

    public void removeAppleScriptBuildPhaseWithIdentifier(String identifier) {
        this.removeBuildPhaseFromTargets(identifier);
        for (PBXBuildPhase buildPhase : this.appleScriptBuildPhases) {
            if (!buildPhase.getReference().getIdentifier().equals(identifier)) continue;
            this.appleScriptBuildPhases.remove(buildPhase);
        }
    }

    public void removeCopyFilesBuildPhaseWithIdentifier(String identifier) {
        this.removeBuildPhaseFromTargets(identifier);
        for (PBXBuildPhase buildPhase : this.copyFilesBuildPhases) {
            if (!buildPhase.getReference().getIdentifier().equals(identifier)) continue;
            this.copyFilesBuildPhases.remove(buildPhase);
        }
    }

    public void removeFrameworksBuildPhaseWithIdentifier(String identifier) {
        this.removeBuildPhaseFromTargets(identifier);
        for (PBXBuildPhase buildPhase : this.frameworksBuildPhases) {
            if (!buildPhase.getReference().getIdentifier().equals(identifier)) continue;
            this.frameworksBuildPhases.remove(buildPhase);
        }
    }

    public void removeHeadersBuildPhaseWithIdentifier(String identifier) {
        this.removeBuildPhaseFromTargets(identifier);
        for (PBXBuildPhase buildPhase : this.headersBuildPhases) {
            if (!buildPhase.getReference().getIdentifier().equals(identifier)) continue;
            this.headersBuildPhases.remove(buildPhase);
        }
    }

    public void removeResourcesBuildPhaseWithIdentifier(String identifier) {
        this.removeBuildPhaseFromTargets(identifier);
        for (PBXBuildPhase buildPhase : this.resourcesBuildPhases) {
            if (!buildPhase.getReference().getIdentifier().equals(identifier)) continue;
            this.resourcesBuildPhases.remove(buildPhase);
        }
    }

    public void removeShellScriptBuildPhaseWithIdentifier(String identifier) {
        this.removeBuildPhaseFromTargets(identifier);
        for (PBXBuildPhase buildPhase : this.shellScriptBuildPhases) {
            if (!buildPhase.getReference().getIdentifier().equals(identifier)) continue;
            this.shellScriptBuildPhases.remove(buildPhase);
        }
    }

    public void removeSourcesBuildPhaseWithIdentifier(String identifier) {
        this.removeBuildPhaseFromTargets(identifier);
        for (PBXBuildPhase buildPhase : this.sourcesBuildPhases) {
            if (!buildPhase.getReference().getIdentifier().equals(identifier)) continue;
            this.sourcesBuildPhases.remove(buildPhase);
        }
    }

    public void setBuildConfigurationProperty(String buildConfigurationIdentifier, String key, String value) {
        for (XCBuildConfiguration configuration : this.buildConfigurations) {
            if (!configuration.getReference().getIdentifier().equals(buildConfigurationIdentifier)) continue;
            configuration.setBuildSetting(key, value);
        }
    }

    public void setBuildConfigurationProperty(String buildConfigurationIdentifier, String key, List<String> values) {
        for (XCBuildConfiguration configuration : this.buildConfigurations) {
            if (!configuration.getReference().getIdentifier().equals(buildConfigurationIdentifier)) continue;
            configuration.setBuildSetting(key, values);
        }
    }

    public String getBuildConfigurationProperty(String buildConfigurationIdentifier, String key) {
        for (XCBuildConfiguration configuration : this.buildConfigurations) {
            if (!configuration.getReference().getIdentifier().equals(buildConfigurationIdentifier)) continue;
            return configuration.getBuildSetting(key);
        }
        return null;
    }

    public List<String> getBuildConfigurationPropertyAsList(String buildConfigurationIdentifier, String key) {
        for (XCBuildConfiguration configuration : this.buildConfigurations) {
            if (!configuration.getReference().getIdentifier().equals(buildConfigurationIdentifier)) continue;
            return configuration.getBuildSettingAsList(key);
        }
        return null;
    }

    public PBXFileElement getGroupWithIdentifier(String identifier) {
        for (PBXFileElement group : this.groups) {
            if (group.getReference() == null || !group.getReference().getIdentifier().equals(identifier)) continue;
            return group;
        }
        return null;
    }

    public PBXFileElement getVariantGroupWithIdentifier(String identifier) {
        for (PBXFileElement variantGroup : this.variantGroups) {
            if (variantGroup.getReference() == null || !variantGroup.getReference().getIdentifier().equals(identifier)) continue;
            return variantGroup;
        }
        return null;
    }

    public PBXBuildFile getBuildFileWithIdentifier(String identifier) {
        for (PBXBuildFile buildFile : this.buildFiles) {
            if (buildFile.getReference() == null || !buildFile.getReference().getIdentifier().equals(identifier)) continue;
            return buildFile;
        }
        return null;
    }

    public PBXBuildFile getBuildFileWithFileRef(String fileRef) {
        for (PBXBuildFile buildFile : this.buildFiles) {
            if (buildFile.getFileRef() == null || !buildFile.getFileRef().getIdentifier().equals(fileRef)) continue;
            return buildFile;
        }
        return null;
    }

    public PBXBuildFile getBuildFileWithFileRefPath(String fileRefPath) {
        for (PBXFileElement fileReference : this.fileReferences) {
            if (fileReference.getPath() == null || !fileReference.getPath().equals(fileRefPath)) continue;
            return this.getBuildFileWithFileRef(fileReference.getReference().getIdentifier());
        }
        return null;
    }

    public PBXFileElement getFileReferenceWithPath(String fileRefPath) {
        for (PBXFileElement fileReference : this.fileReferences) {
            if (fileReference.getPath() == null || !fileReference.getPath().equals(fileRefPath)) continue;
            return fileReference;
        }
        return null;
    }

    public PBXTarget getNativeTargetWithIdentifier(String identifier) {
        for (PBXTarget nativeTarget : this.nativeTargets) {
            if (nativeTarget.getReference() == null || !nativeTarget.getReference().getIdentifier().equals(identifier)) continue;
            return nativeTarget;
        }
        return null;
    }

    public PBXTarget getLegacyTargetWithIdentifier(String identifier) {
        for (PBXTarget legacyTarget : this.legacyTargets) {
            if (legacyTarget.getReference() == null || !legacyTarget.getReference().getIdentifier().equals(identifier)) continue;
            return legacyTarget;
        }
        return null;
    }

    public PBXTarget getAggregateTargetWithIdentifier(String identifier) {
        for (PBXTarget aggregateTarget : this.aggregateTargets) {
            if (aggregateTarget.getReference() == null || !aggregateTarget.getReference().getIdentifier().equals(identifier)) continue;
            return aggregateTarget;
        }
        return null;
    }

    public XCBuildConfiguration getBuildConfigurationWithIdentifier(String identifier) {
        for (XCBuildConfiguration buildConfiguration : this.buildConfigurations) {
            if (buildConfiguration.getReference() == null || !buildConfiguration.getReference().getIdentifier().equals(identifier)) continue;
            return buildConfiguration;
        }
        return null;
    }

    public XCConfigurationList getConfigurationListWithIdentifier(String identifier) {
        for (XCConfigurationList configurationList : this.configurationLists) {
            if (configurationList.getReference() == null || !configurationList.getReference().getIdentifier().equals(identifier)) continue;
            return configurationList;
        }
        return null;
    }

    public Integer getArchiveVersion() {
        return this.archiveVersion;
    }

    public List<String> getClasses() {
        return this.classes;
    }

    public Integer getObjectVersion() {
        return this.objectVersion;
    }

    public List<PBXBuildFile> getBuildFiles() {
        return this.buildFiles;
    }

    public PBXContainerItemProxy getContainerItemProxy() {
        return this.containerItemProxy;
    }

    public List<PBXFileElement> getFileReferences() {
        return this.fileReferences;
    }

    public List<PBXBuildPhase> getFrameworksBuildPhases() {
        return this.frameworksBuildPhases;
    }

    public List<PBXFileElement> getGroups() {
        return this.groups;
    }

    public List<PBXTarget> getNativeTargets() {
        return this.nativeTargets;
    }

    public List<PBXTarget> getAggregateTargets() {
        return this.aggregateTargets;
    }

    public List<PBXTarget> getLegacyTargets() {
        return this.legacyTargets;
    }

    public PBXProject getProject() {
        return this.project;
    }

    public List<PBXBuildPhase> getResourcesBuildPhases() {
        return this.resourcesBuildPhases;
    }

    public List<PBXBuildPhase> getSourcesBuildPhases() {
        return this.sourcesBuildPhases;
    }

    public PBXTargetDependency getTargetDependency() {
        return this.targetDependency;
    }

    public List<PBXFileElement> getVariantGroups() {
        return this.variantGroups;
    }

    public List<XCBuildConfiguration> getBuildConfigurations() {
        return this.buildConfigurations;
    }

    public List<XCConfigurationList> getConfigurationLists() {
        return this.configurationLists;
    }

    public List<PBXBuildPhase> getAppleScriptBuildPhases() {
        return this.appleScriptBuildPhases;
    }

    public List<PBXBuildPhase> getCopyFilesBuildPhases() {
        return this.copyFilesBuildPhases;
    }

    public List<PBXBuildPhase> getHeadersBuildPhases() {
        return this.headersBuildPhases;
    }

    public List<PBXBuildPhase> getShellScriptBuildPhases() {
        return this.shellScriptBuildPhases;
    }

    public CommentedIdentifier getRootObject() {
        return this.rootObject;
    }

    public void setArchiveVersion(Integer archiveVersion) {
        this.archiveVersion = archiveVersion;
    }

    public void setClasses(List<String> classes) {
        this.classes = classes;
    }

    public void setObjectVersion(Integer objectVersion) {
        this.objectVersion = objectVersion;
    }

    public void setBuildFiles(List<PBXBuildFile> buildFiles) {
        this.buildFiles = buildFiles;
    }

    public void setContainerItemProxy(PBXContainerItemProxy containerItemProxy) {
        this.containerItemProxy = containerItemProxy;
    }

    public void setFileReferences(List<PBXFileElement> fileReferences) {
        this.fileReferences = fileReferences;
    }

    public void setFrameworksBuildPhases(List<PBXBuildPhase> frameworksBuildPhases) {
        this.frameworksBuildPhases = frameworksBuildPhases;
    }

    public void setGroups(List<PBXFileElement> groups) {
        this.groups = groups;
    }

    public void setNativeTargets(List<PBXTarget> nativeTargets) {
        this.nativeTargets = nativeTargets;
    }

    public void setAggregateTargets(List<PBXTarget> aggregateTargets) {
        this.aggregateTargets = aggregateTargets;
    }

    public void setLegacyTargets(List<PBXTarget> legacyTargets) {
        this.legacyTargets = legacyTargets;
    }

    public void setProject(PBXProject project) {
        this.project = project;
    }

    public void setResourcesBuildPhases(List<PBXBuildPhase> resourcesBuildPhases) {
        this.resourcesBuildPhases = resourcesBuildPhases;
    }

    public void setSourcesBuildPhases(List<PBXBuildPhase> sourcesBuildPhases) {
        this.sourcesBuildPhases = sourcesBuildPhases;
    }

    public void setTargetDependency(PBXTargetDependency targetDependency) {
        this.targetDependency = targetDependency;
    }

    public void setVariantGroups(List<PBXFileElement> variantGroups) {
        this.variantGroups = variantGroups;
    }

    public void setBuildConfigurations(List<XCBuildConfiguration> buildConfigurations) {
        this.buildConfigurations = buildConfigurations;
    }

    public void setConfigurationLists(List<XCConfigurationList> configurationLists) {
        this.configurationLists = configurationLists;
    }

    public void setAppleScriptBuildPhases(List<PBXBuildPhase> appleScriptBuildPhases) {
        this.appleScriptBuildPhases = appleScriptBuildPhases;
    }

    public void setCopyFilesBuildPhases(List<PBXBuildPhase> copyFilesBuildPhases) {
        this.copyFilesBuildPhases = copyFilesBuildPhases;
    }

    public void setHeadersBuildPhases(List<PBXBuildPhase> headersBuildPhases) {
        this.headersBuildPhases = headersBuildPhases;
    }

    public void setShellScriptBuildPhases(List<PBXBuildPhase> shellScriptBuildPhases) {
        this.shellScriptBuildPhases = shellScriptBuildPhases;
    }

    public void setRootObject(CommentedIdentifier rootObject) {
        this.rootObject = rootObject;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof XCodeProject)) {
            return false;
        }
        XCodeProject other = (XCodeProject)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$archiveVersion = this.getArchiveVersion();
        Integer other$archiveVersion = other.getArchiveVersion();
        if (this$archiveVersion == null ? other$archiveVersion != null : !((Object)this$archiveVersion).equals(other$archiveVersion)) {
            return false;
        }
        List<String> this$classes = this.getClasses();
        List<String> other$classes = other.getClasses();
        if (this$classes == null ? other$classes != null : !((Object)this$classes).equals(other$classes)) {
            return false;
        }
        Integer this$objectVersion = this.getObjectVersion();
        Integer other$objectVersion = other.getObjectVersion();
        if (this$objectVersion == null ? other$objectVersion != null : !((Object)this$objectVersion).equals(other$objectVersion)) {
            return false;
        }
        List<PBXBuildFile> this$buildFiles = this.getBuildFiles();
        List<PBXBuildFile> other$buildFiles = other.getBuildFiles();
        if (this$buildFiles == null ? other$buildFiles != null : !((Object)this$buildFiles).equals(other$buildFiles)) {
            return false;
        }
        PBXContainerItemProxy this$containerItemProxy = this.getContainerItemProxy();
        PBXContainerItemProxy other$containerItemProxy = other.getContainerItemProxy();
        if (this$containerItemProxy == null ? other$containerItemProxy != null : !((Object)this$containerItemProxy).equals(other$containerItemProxy)) {
            return false;
        }
        List<PBXFileElement> this$fileReferences = this.getFileReferences();
        List<PBXFileElement> other$fileReferences = other.getFileReferences();
        if (this$fileReferences == null ? other$fileReferences != null : !((Object)this$fileReferences).equals(other$fileReferences)) {
            return false;
        }
        List<PBXBuildPhase> this$frameworksBuildPhases = this.getFrameworksBuildPhases();
        List<PBXBuildPhase> other$frameworksBuildPhases = other.getFrameworksBuildPhases();
        if (this$frameworksBuildPhases == null ? other$frameworksBuildPhases != null : !((Object)this$frameworksBuildPhases).equals(other$frameworksBuildPhases)) {
            return false;
        }
        List<PBXFileElement> this$groups = this.getGroups();
        List<PBXFileElement> other$groups = other.getGroups();
        if (this$groups == null ? other$groups != null : !((Object)this$groups).equals(other$groups)) {
            return false;
        }
        List<PBXTarget> this$nativeTargets = this.getNativeTargets();
        List<PBXTarget> other$nativeTargets = other.getNativeTargets();
        if (this$nativeTargets == null ? other$nativeTargets != null : !((Object)this$nativeTargets).equals(other$nativeTargets)) {
            return false;
        }
        List<PBXTarget> this$aggregateTargets = this.getAggregateTargets();
        List<PBXTarget> other$aggregateTargets = other.getAggregateTargets();
        if (this$aggregateTargets == null ? other$aggregateTargets != null : !((Object)this$aggregateTargets).equals(other$aggregateTargets)) {
            return false;
        }
        List<PBXTarget> this$legacyTargets = this.getLegacyTargets();
        List<PBXTarget> other$legacyTargets = other.getLegacyTargets();
        if (this$legacyTargets == null ? other$legacyTargets != null : !((Object)this$legacyTargets).equals(other$legacyTargets)) {
            return false;
        }
        PBXProject this$project = this.getProject();
        PBXProject other$project = other.getProject();
        if (this$project == null ? other$project != null : !((Object)this$project).equals(other$project)) {
            return false;
        }
        List<PBXBuildPhase> this$resourcesBuildPhases = this.getResourcesBuildPhases();
        List<PBXBuildPhase> other$resourcesBuildPhases = other.getResourcesBuildPhases();
        if (this$resourcesBuildPhases == null ? other$resourcesBuildPhases != null : !((Object)this$resourcesBuildPhases).equals(other$resourcesBuildPhases)) {
            return false;
        }
        List<PBXBuildPhase> this$sourcesBuildPhases = this.getSourcesBuildPhases();
        List<PBXBuildPhase> other$sourcesBuildPhases = other.getSourcesBuildPhases();
        if (this$sourcesBuildPhases == null ? other$sourcesBuildPhases != null : !((Object)this$sourcesBuildPhases).equals(other$sourcesBuildPhases)) {
            return false;
        }
        PBXTargetDependency this$targetDependency = this.getTargetDependency();
        PBXTargetDependency other$targetDependency = other.getTargetDependency();
        if (this$targetDependency == null ? other$targetDependency != null : !((Object)this$targetDependency).equals(other$targetDependency)) {
            return false;
        }
        List<PBXFileElement> this$variantGroups = this.getVariantGroups();
        List<PBXFileElement> other$variantGroups = other.getVariantGroups();
        if (this$variantGroups == null ? other$variantGroups != null : !((Object)this$variantGroups).equals(other$variantGroups)) {
            return false;
        }
        List<XCBuildConfiguration> this$buildConfigurations = this.getBuildConfigurations();
        List<XCBuildConfiguration> other$buildConfigurations = other.getBuildConfigurations();
        if (this$buildConfigurations == null ? other$buildConfigurations != null : !((Object)this$buildConfigurations).equals(other$buildConfigurations)) {
            return false;
        }
        List<XCConfigurationList> this$configurationLists = this.getConfigurationLists();
        List<XCConfigurationList> other$configurationLists = other.getConfigurationLists();
        if (this$configurationLists == null ? other$configurationLists != null : !((Object)this$configurationLists).equals(other$configurationLists)) {
            return false;
        }
        List<PBXBuildPhase> this$appleScriptBuildPhases = this.getAppleScriptBuildPhases();
        List<PBXBuildPhase> other$appleScriptBuildPhases = other.getAppleScriptBuildPhases();
        if (this$appleScriptBuildPhases == null ? other$appleScriptBuildPhases != null : !((Object)this$appleScriptBuildPhases).equals(other$appleScriptBuildPhases)) {
            return false;
        }
        List<PBXBuildPhase> this$copyFilesBuildPhases = this.getCopyFilesBuildPhases();
        List<PBXBuildPhase> other$copyFilesBuildPhases = other.getCopyFilesBuildPhases();
        if (this$copyFilesBuildPhases == null ? other$copyFilesBuildPhases != null : !((Object)this$copyFilesBuildPhases).equals(other$copyFilesBuildPhases)) {
            return false;
        }
        List<PBXBuildPhase> this$headersBuildPhases = this.getHeadersBuildPhases();
        List<PBXBuildPhase> other$headersBuildPhases = other.getHeadersBuildPhases();
        if (this$headersBuildPhases == null ? other$headersBuildPhases != null : !((Object)this$headersBuildPhases).equals(other$headersBuildPhases)) {
            return false;
        }
        List<PBXBuildPhase> this$shellScriptBuildPhases = this.getShellScriptBuildPhases();
        List<PBXBuildPhase> other$shellScriptBuildPhases = other.getShellScriptBuildPhases();
        if (this$shellScriptBuildPhases == null ? other$shellScriptBuildPhases != null : !((Object)this$shellScriptBuildPhases).equals(other$shellScriptBuildPhases)) {
            return false;
        }
        CommentedIdentifier this$rootObject = this.getRootObject();
        CommentedIdentifier other$rootObject = other.getRootObject();
        return !(this$rootObject == null ? other$rootObject != null : !((Object)this$rootObject).equals(other$rootObject));
    }

    protected boolean canEqual(Object other) {
        return other instanceof XCodeProject;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $archiveVersion = this.getArchiveVersion();
        result = result * 59 + ($archiveVersion == null ? 0 : ((Object)$archiveVersion).hashCode());
        List<String> $classes = this.getClasses();
        result = result * 59 + ($classes == null ? 0 : ((Object)$classes).hashCode());
        Integer $objectVersion = this.getObjectVersion();
        result = result * 59 + ($objectVersion == null ? 0 : ((Object)$objectVersion).hashCode());
        List<PBXBuildFile> $buildFiles = this.getBuildFiles();
        result = result * 59 + ($buildFiles == null ? 0 : ((Object)$buildFiles).hashCode());
        PBXContainerItemProxy $containerItemProxy = this.getContainerItemProxy();
        result = result * 59 + ($containerItemProxy == null ? 0 : ((Object)$containerItemProxy).hashCode());
        List<PBXFileElement> $fileReferences = this.getFileReferences();
        result = result * 59 + ($fileReferences == null ? 0 : ((Object)$fileReferences).hashCode());
        List<PBXBuildPhase> $frameworksBuildPhases = this.getFrameworksBuildPhases();
        result = result * 59 + ($frameworksBuildPhases == null ? 0 : ((Object)$frameworksBuildPhases).hashCode());
        List<PBXFileElement> $groups = this.getGroups();
        result = result * 59 + ($groups == null ? 0 : ((Object)$groups).hashCode());
        List<PBXTarget> $nativeTargets = this.getNativeTargets();
        result = result * 59 + ($nativeTargets == null ? 0 : ((Object)$nativeTargets).hashCode());
        List<PBXTarget> $aggregateTargets = this.getAggregateTargets();
        result = result * 59 + ($aggregateTargets == null ? 0 : ((Object)$aggregateTargets).hashCode());
        List<PBXTarget> $legacyTargets = this.getLegacyTargets();
        result = result * 59 + ($legacyTargets == null ? 0 : ((Object)$legacyTargets).hashCode());
        PBXProject $project = this.getProject();
        result = result * 59 + ($project == null ? 0 : ((Object)$project).hashCode());
        List<PBXBuildPhase> $resourcesBuildPhases = this.getResourcesBuildPhases();
        result = result * 59 + ($resourcesBuildPhases == null ? 0 : ((Object)$resourcesBuildPhases).hashCode());
        List<PBXBuildPhase> $sourcesBuildPhases = this.getSourcesBuildPhases();
        result = result * 59 + ($sourcesBuildPhases == null ? 0 : ((Object)$sourcesBuildPhases).hashCode());
        PBXTargetDependency $targetDependency = this.getTargetDependency();
        result = result * 59 + ($targetDependency == null ? 0 : ((Object)$targetDependency).hashCode());
        List<PBXFileElement> $variantGroups = this.getVariantGroups();
        result = result * 59 + ($variantGroups == null ? 0 : ((Object)$variantGroups).hashCode());
        List<XCBuildConfiguration> $buildConfigurations = this.getBuildConfigurations();
        result = result * 59 + ($buildConfigurations == null ? 0 : ((Object)$buildConfigurations).hashCode());
        List<XCConfigurationList> $configurationLists = this.getConfigurationLists();
        result = result * 59 + ($configurationLists == null ? 0 : ((Object)$configurationLists).hashCode());
        List<PBXBuildPhase> $appleScriptBuildPhases = this.getAppleScriptBuildPhases();
        result = result * 59 + ($appleScriptBuildPhases == null ? 0 : ((Object)$appleScriptBuildPhases).hashCode());
        List<PBXBuildPhase> $copyFilesBuildPhases = this.getCopyFilesBuildPhases();
        result = result * 59 + ($copyFilesBuildPhases == null ? 0 : ((Object)$copyFilesBuildPhases).hashCode());
        List<PBXBuildPhase> $headersBuildPhases = this.getHeadersBuildPhases();
        result = result * 59 + ($headersBuildPhases == null ? 0 : ((Object)$headersBuildPhases).hashCode());
        List<PBXBuildPhase> $shellScriptBuildPhases = this.getShellScriptBuildPhases();
        result = result * 59 + ($shellScriptBuildPhases == null ? 0 : ((Object)$shellScriptBuildPhases).hashCode());
        CommentedIdentifier $rootObject = this.getRootObject();
        result = result * 59 + ($rootObject == null ? 0 : ((Object)$rootObject).hashCode());
        return result;
    }

    public XCodeProject() {
    }

    @ConstructorProperties(value={"archiveVersion", "classes", "objectVersion", "buildFiles", "containerItemProxy", "fileReferences", "frameworksBuildPhases", "groups", "nativeTargets", "aggregateTargets", "legacyTargets", "project", "resourcesBuildPhases", "sourcesBuildPhases", "targetDependency", "variantGroups", "buildConfigurations", "configurationLists", "appleScriptBuildPhases", "copyFilesBuildPhases", "headersBuildPhases", "shellScriptBuildPhases", "rootObject"})
    public XCodeProject(Integer archiveVersion, List<String> classes, Integer objectVersion, List<PBXBuildFile> buildFiles, PBXContainerItemProxy containerItemProxy, List<PBXFileElement> fileReferences, List<PBXBuildPhase> frameworksBuildPhases, List<PBXFileElement> groups, List<PBXTarget> nativeTargets, List<PBXTarget> aggregateTargets, List<PBXTarget> legacyTargets, PBXProject project, List<PBXBuildPhase> resourcesBuildPhases, List<PBXBuildPhase> sourcesBuildPhases, PBXTargetDependency targetDependency, List<PBXFileElement> variantGroups, List<XCBuildConfiguration> buildConfigurations, List<XCConfigurationList> configurationLists, List<PBXBuildPhase> appleScriptBuildPhases, List<PBXBuildPhase> copyFilesBuildPhases, List<PBXBuildPhase> headersBuildPhases, List<PBXBuildPhase> shellScriptBuildPhases, CommentedIdentifier rootObject) {
        this.archiveVersion = archiveVersion;
        this.classes = classes;
        this.objectVersion = objectVersion;
        this.buildFiles = buildFiles;
        this.containerItemProxy = containerItemProxy;
        this.fileReferences = fileReferences;
        this.frameworksBuildPhases = frameworksBuildPhases;
        this.groups = groups;
        this.nativeTargets = nativeTargets;
        this.aggregateTargets = aggregateTargets;
        this.legacyTargets = legacyTargets;
        this.project = project;
        this.resourcesBuildPhases = resourcesBuildPhases;
        this.sourcesBuildPhases = sourcesBuildPhases;
        this.targetDependency = targetDependency;
        this.variantGroups = variantGroups;
        this.buildConfigurations = buildConfigurations;
        this.configurationLists = configurationLists;
        this.appleScriptBuildPhases = appleScriptBuildPhases;
        this.copyFilesBuildPhases = copyFilesBuildPhases;
        this.headersBuildPhases = headersBuildPhases;
        this.shellScriptBuildPhases = shellScriptBuildPhases;
        this.rootObject = rootObject;
    }
}

