/*
 * Decompiled with CFR 0.152.
 */
package ca.mestevens.ios.xcode.parser.models;

import ca.mestevens.ios.xcode.parser.exceptions.InvalidObjectFormatException;
import ca.mestevens.ios.xcode.parser.models.CommentedIdentifier;
import ca.mestevens.ios.xcode.parser.utils.ObjectParser;
import java.beans.ConstructorProperties;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XCConfigurationList
implements Comparable<XCConfigurationList> {
    private CommentedIdentifier reference;
    private String isa;
    private List<CommentedIdentifier> buildConfigurations;
    private Integer defaultConfigurationIsVisible;
    private String defaultConfigurationName;

    public XCConfigurationList(String configurationListString) throws InvalidObjectFormatException {
        try {
            configurationListString = configurationListString.trim();
            int equalsIndex = configurationListString.indexOf(61);
            String commentPart = "";
            String uuidPart = configurationListString.substring(0, equalsIndex).trim();
            if (uuidPart.contains("/*")) {
                int commentStartIndex = uuidPart.indexOf("/*");
                int commentEndIndex = uuidPart.indexOf("*/");
                commentPart = configurationListString.substring(commentStartIndex + 2, commentEndIndex).trim();
                uuidPart = uuidPart.substring(0, commentStartIndex).trim();
            }
            this.reference = new CommentedIdentifier(uuidPart, commentPart);
            ObjectParser parser = new ObjectParser(configurationListString);
            parser = parser.getNextNestedObjects();
            String parserObject = parser.parseNextObject();
            while (parserObject != null) {
                parserObject = parserObject.substring(0, parserObject.length() - 1);
                String[] splitObject = parserObject.split("=");
                String key = splitObject[0].trim();
                String value = "";
                for (int i = 1; i < splitObject.length; ++i) {
                    if (i > 1) {
                        value = value + "=";
                    }
                    value = value + splitObject[i];
                }
                value = value.trim();
                if (key.equals("isa")) {
                    this.isa = value;
                } else if (key.equals("buildConfigurations")) {
                    this.buildConfigurations = parser.getIdentifierList(value);
                } else if (key.equals("defaultConfigurationIsVisible")) {
                    this.defaultConfigurationIsVisible = Integer.valueOf(value);
                } else if (key.equals("defaultConfigurationName")) {
                    this.defaultConfigurationName = value;
                }
                parserObject = parser.parseNextObject();
            }
        }
        catch (Exception ex) {
            throw new InvalidObjectFormatException(ex);
        }
    }

    public String toString() {
        return this.toString(0);
    }

    public String toString(int numberOfTabs) {
        String tabString = "";
        for (int i = 0; i < numberOfTabs; ++i) {
            tabString = tabString + "\t";
        }
        String returnString = "";
        returnString = returnString + tabString + this.reference.toString() + " = {\n";
        returnString = returnString + tabString + "\tisa = " + this.isa + ";\n";
        returnString = returnString + tabString + "\tbuildConfigurations = (\n";
        for (CommentedIdentifier configuration : this.buildConfigurations) {
            returnString = returnString + tabString + "\t\t" + configuration.toString() + ",\n";
        }
        returnString = returnString + tabString + "\t);\n";
        returnString = returnString + tabString + "\tdefaultConfigurationIsVisible = " + this.defaultConfigurationIsVisible + ";\n";
        if (this.defaultConfigurationName != null) {
            returnString = returnString + tabString + "\tdefaultConfigurationName = " + this.defaultConfigurationName + ";\n";
        }
        returnString = returnString + tabString + "};";
        return returnString;
    }

    @Override
    public int compareTo(XCConfigurationList o) {
        return this.reference.getIdentifier().compareTo(o.getReference().getIdentifier());
    }

    public CommentedIdentifier getReference() {
        return this.reference;
    }

    public String getIsa() {
        return this.isa;
    }

    public List<CommentedIdentifier> getBuildConfigurations() {
        return this.buildConfigurations;
    }

    public Integer getDefaultConfigurationIsVisible() {
        return this.defaultConfigurationIsVisible;
    }

    public String getDefaultConfigurationName() {
        return this.defaultConfigurationName;
    }

    public void setReference(CommentedIdentifier reference) {
        this.reference = reference;
    }

    public void setIsa(String isa) {
        this.isa = isa;
    }

    public void setBuildConfigurations(List<CommentedIdentifier> buildConfigurations) {
        this.buildConfigurations = buildConfigurations;
    }

    public void setDefaultConfigurationIsVisible(Integer defaultConfigurationIsVisible) {
        this.defaultConfigurationIsVisible = defaultConfigurationIsVisible;
    }

    public void setDefaultConfigurationName(String defaultConfigurationName) {
        this.defaultConfigurationName = defaultConfigurationName;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof XCConfigurationList)) {
            return false;
        }
        XCConfigurationList other = (XCConfigurationList)o;
        if (!other.canEqual(this)) {
            return false;
        }
        CommentedIdentifier this$reference = this.getReference();
        CommentedIdentifier other$reference = other.getReference();
        if (this$reference == null ? other$reference != null : !((Object)this$reference).equals(other$reference)) {
            return false;
        }
        String this$isa = this.getIsa();
        String other$isa = other.getIsa();
        if (this$isa == null ? other$isa != null : !this$isa.equals(other$isa)) {
            return false;
        }
        List<CommentedIdentifier> this$buildConfigurations = this.getBuildConfigurations();
        List<CommentedIdentifier> other$buildConfigurations = other.getBuildConfigurations();
        if (this$buildConfigurations == null ? other$buildConfigurations != null : !((Object)this$buildConfigurations).equals(other$buildConfigurations)) {
            return false;
        }
        Integer this$defaultConfigurationIsVisible = this.getDefaultConfigurationIsVisible();
        Integer other$defaultConfigurationIsVisible = other.getDefaultConfigurationIsVisible();
        if (this$defaultConfigurationIsVisible == null ? other$defaultConfigurationIsVisible != null : !((Object)this$defaultConfigurationIsVisible).equals(other$defaultConfigurationIsVisible)) {
            return false;
        }
        String this$defaultConfigurationName = this.getDefaultConfigurationName();
        String other$defaultConfigurationName = other.getDefaultConfigurationName();
        return !(this$defaultConfigurationName == null ? other$defaultConfigurationName != null : !this$defaultConfigurationName.equals(other$defaultConfigurationName));
    }

    protected boolean canEqual(Object other) {
        return other instanceof XCConfigurationList;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        CommentedIdentifier $reference = this.getReference();
        result = result * 59 + ($reference == null ? 0 : ((Object)$reference).hashCode());
        String $isa = this.getIsa();
        result = result * 59 + ($isa == null ? 0 : $isa.hashCode());
        List<CommentedIdentifier> $buildConfigurations = this.getBuildConfigurations();
        result = result * 59 + ($buildConfigurations == null ? 0 : ((Object)$buildConfigurations).hashCode());
        Integer $defaultConfigurationIsVisible = this.getDefaultConfigurationIsVisible();
        result = result * 59 + ($defaultConfigurationIsVisible == null ? 0 : ((Object)$defaultConfigurationIsVisible).hashCode());
        String $defaultConfigurationName = this.getDefaultConfigurationName();
        result = result * 59 + ($defaultConfigurationName == null ? 0 : $defaultConfigurationName.hashCode());
        return result;
    }

    public XCConfigurationList() {
    }

    @ConstructorProperties(value={"reference", "isa", "buildConfigurations", "defaultConfigurationIsVisible", "defaultConfigurationName"})
    public XCConfigurationList(CommentedIdentifier reference, String isa, List<CommentedIdentifier> buildConfigurations, Integer defaultConfigurationIsVisible, String defaultConfigurationName) {
        this.reference = reference;
        this.isa = isa;
        this.buildConfigurations = buildConfigurations;
        this.defaultConfigurationIsVisible = defaultConfigurationIsVisible;
        this.defaultConfigurationName = defaultConfigurationName;
    }
}

