/*
 * Decompiled with CFR 0.152.
 */
package ca.mestevens.ios.xcode.parser.models;

import ca.mestevens.ios.xcode.parser.exceptions.InvalidObjectFormatException;
import ca.mestevens.ios.xcode.parser.models.CommentedIdentifier;
import ca.mestevens.ios.xcode.parser.utils.ObjectParser;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XCBuildConfiguration
implements Comparable<XCBuildConfiguration> {
    private CommentedIdentifier reference;
    private String isa;
    private String baseConfigurationReference;
    private Map<String, String> buildSettings;
    private String name;
    private List<String> quoteSettings;

    public XCBuildConfiguration(String buildConfigurationString) throws InvalidObjectFormatException {
        try {
            buildConfigurationString = buildConfigurationString.trim();
            int equalsIndex = buildConfigurationString.indexOf(61);
            String commentPart = "";
            String uuidPart = buildConfigurationString.substring(0, equalsIndex).trim();
            if (uuidPart.contains("/*")) {
                int commentStartIndex = uuidPart.indexOf("/*");
                int commentEndIndex = uuidPart.indexOf("*/");
                commentPart = buildConfigurationString.substring(commentStartIndex + 2, commentEndIndex).trim();
                uuidPart = uuidPart.substring(0, commentStartIndex).trim();
            }
            this.reference = new CommentedIdentifier(uuidPart, commentPart);
            ObjectParser parser = new ObjectParser(buildConfigurationString);
            parser = parser.getNextNestedObjects();
            String parserObject = parser.parseNextObject();
            while (parserObject != null) {
                parserObject = parserObject.substring(0, parserObject.length() - 1);
                String[] splitObject = parserObject.split("=");
                String key = splitObject[0].trim();
                String value = "";
                for (int i = 1; i < splitObject.length; ++i) {
                    if (i > 1) {
                        value = value + "=";
                    }
                    value = value + splitObject[i];
                }
                value = value.trim();
                if (key.equals("isa")) {
                    this.isa = value;
                } else if (key.equals("name")) {
                    this.name = value;
                } else if (key.equals("baseConfigurationReference")) {
                    this.baseConfigurationReference = value;
                } else if (key.equals("buildSettings")) {
                    value = value.substring(1, value.length() - 2);
                    ObjectParser settingsParser = new ObjectParser(value);
                    TreeMap<String, String> settingsMap = new TreeMap<String, String>();
                    ArrayList<String> quoteSettings = new ArrayList<String>();
                    String settingsObject = settingsParser.parseNextObject();
                    while (settingsObject != null) {
                        settingsObject = settingsObject.substring(0, settingsObject.length() - 1);
                        String[] splitSetting = settingsObject.split("=");
                        String settingsKey = splitSetting[0];
                        String settingsValue = "";
                        if (settingsKey.startsWith("\"")) {
                            boolean addToKey = true;
                            for (int i = 1; i < splitSetting.length; ++i) {
                                if (addToKey) {
                                    settingsKey = settingsKey + "=";
                                    if (splitSetting[i].contains("\"")) {
                                        addToKey = false;
                                    }
                                    settingsKey = settingsKey + splitSetting[i];
                                    continue;
                                }
                                if (settingsValue != "") {
                                    settingsValue = settingsValue + "=";
                                }
                                settingsValue = settingsValue + splitSetting[i];
                            }
                            settingsKey = settingsKey.trim();
                            settingsKey = settingsKey.substring(1, settingsKey.length() - 1);
                            quoteSettings.add(settingsKey);
                        } else {
                            settingsKey = settingsKey.trim();
                            for (int i = 1; i < splitSetting.length; ++i) {
                                if (i > 1) {
                                    settingsValue = settingsValue + "=";
                                }
                                settingsValue = settingsValue + splitSetting[i];
                            }
                        }
                        settingsValue = settingsValue.trim();
                        settingsMap.put(settingsKey, settingsValue);
                        settingsObject = settingsParser.parseNextObject();
                    }
                    this.buildSettings = settingsMap;
                    this.quoteSettings = quoteSettings;
                }
                parserObject = parser.parseNextObject();
            }
        }
        catch (Exception ex) {
            throw new InvalidObjectFormatException(ex);
        }
    }

    public void setBuildSetting(String key, String value) {
        if (key.startsWith("\"") && key.endsWith("\"")) {
            key = key.substring(1, key.length() - 1);
            this.quoteSettings.add(key);
        }
        this.buildSettings.put(key, value);
    }

    public void setBuildSetting(String key, List<String> values) {
        String valueString = StringUtils.join(values, (char)',');
        valueString = "(" + valueString + ")";
        if (key.startsWith("\"") && key.endsWith("\"")) {
            key = key.substring(1, key.length() - 1);
            this.quoteSettings.add(key);
        }
        this.buildSettings.put(key, valueString);
    }

    public String getBuildSetting(String key) {
        if (key.startsWith("\"") && key.endsWith("\"")) {
            key = key.substring(1, key.length() - 1);
        }
        return this.buildSettings.get(key);
    }

    public List<String> getBuildSettingAsList(String key) {
        String returnValue;
        if (key.startsWith("\"") && key.endsWith("\"")) {
            key = key.substring(1, key.length() - 1);
        }
        if ((returnValue = this.buildSettings.get(key)) != null) {
            if (!returnValue.startsWith("(") || !returnValue.endsWith(")")) {
                return null;
            }
            returnValue = returnValue.substring(1, returnValue.length() - 2);
            String[] returnArray = returnValue.split(",");
            ArrayList<String> returnList = new ArrayList<String>();
            for (String value : returnArray) {
                if (value.trim().equals("")) continue;
                returnList.add(value.trim());
            }
            return returnList;
        }
        return null;
    }

    public String toString() {
        return this.toString(0);
    }

    public String toString(int numberOfTabs) {
        String tabString = "";
        for (int i = 0; i < numberOfTabs; ++i) {
            tabString = tabString + "\t";
        }
        String returnString = "";
        returnString = returnString + tabString + this.reference.toString() + " = {\n";
        returnString = returnString + tabString + "\tisa = " + this.isa + ";\n";
        if (this.baseConfigurationReference != null) {
            returnString = returnString + tabString + "\tbaseConfigurationReference = " + this.baseConfigurationReference + ";\n";
        }
        returnString = returnString + tabString + "\tbuildSettings = {\n";
        for (String key : this.buildSettings.keySet()) {
            String value = this.buildSettings.get(key);
            if (this.quoteSettings.contains(key)) {
                returnString = returnString + tabString + "\t\t\"" + key + "\" = " + value + ";\n";
                continue;
            }
            returnString = returnString + tabString + "\t\t" + key + " = " + value + ";\n";
        }
        returnString = returnString + tabString + "\t};\n";
        returnString = returnString + tabString + "\tname = " + this.name + ";\n";
        returnString = returnString + tabString + "};";
        return returnString;
    }

    @Override
    public int compareTo(XCBuildConfiguration o) {
        return this.reference.getIdentifier().compareTo(o.getReference().getIdentifier());
    }

    public CommentedIdentifier getReference() {
        return this.reference;
    }

    public String getIsa() {
        return this.isa;
    }

    public String getBaseConfigurationReference() {
        return this.baseConfigurationReference;
    }

    public Map<String, String> getBuildSettings() {
        return this.buildSettings;
    }

    public String getName() {
        return this.name;
    }

    public List<String> getQuoteSettings() {
        return this.quoteSettings;
    }

    public void setReference(CommentedIdentifier reference) {
        this.reference = reference;
    }

    public void setIsa(String isa) {
        this.isa = isa;
    }

    public void setBaseConfigurationReference(String baseConfigurationReference) {
        this.baseConfigurationReference = baseConfigurationReference;
    }

    public void setBuildSettings(Map<String, String> buildSettings) {
        this.buildSettings = buildSettings;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setQuoteSettings(List<String> quoteSettings) {
        this.quoteSettings = quoteSettings;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof XCBuildConfiguration)) {
            return false;
        }
        XCBuildConfiguration other = (XCBuildConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        CommentedIdentifier this$reference = this.getReference();
        CommentedIdentifier other$reference = other.getReference();
        if (this$reference == null ? other$reference != null : !((Object)this$reference).equals(other$reference)) {
            return false;
        }
        String this$isa = this.getIsa();
        String other$isa = other.getIsa();
        if (this$isa == null ? other$isa != null : !this$isa.equals(other$isa)) {
            return false;
        }
        String this$baseConfigurationReference = this.getBaseConfigurationReference();
        String other$baseConfigurationReference = other.getBaseConfigurationReference();
        if (this$baseConfigurationReference == null ? other$baseConfigurationReference != null : !this$baseConfigurationReference.equals(other$baseConfigurationReference)) {
            return false;
        }
        Map<String, String> this$buildSettings = this.getBuildSettings();
        Map<String, String> other$buildSettings = other.getBuildSettings();
        if (this$buildSettings == null ? other$buildSettings != null : !((Object)this$buildSettings).equals(other$buildSettings)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        List<String> this$quoteSettings = this.getQuoteSettings();
        List<String> other$quoteSettings = other.getQuoteSettings();
        return !(this$quoteSettings == null ? other$quoteSettings != null : !((Object)this$quoteSettings).equals(other$quoteSettings));
    }

    protected boolean canEqual(Object other) {
        return other instanceof XCBuildConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        CommentedIdentifier $reference = this.getReference();
        result = result * 59 + ($reference == null ? 0 : ((Object)$reference).hashCode());
        String $isa = this.getIsa();
        result = result * 59 + ($isa == null ? 0 : $isa.hashCode());
        String $baseConfigurationReference = this.getBaseConfigurationReference();
        result = result * 59 + ($baseConfigurationReference == null ? 0 : $baseConfigurationReference.hashCode());
        Map<String, String> $buildSettings = this.getBuildSettings();
        result = result * 59 + ($buildSettings == null ? 0 : ((Object)$buildSettings).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 0 : $name.hashCode());
        List<String> $quoteSettings = this.getQuoteSettings();
        result = result * 59 + ($quoteSettings == null ? 0 : ((Object)$quoteSettings).hashCode());
        return result;
    }

    public XCBuildConfiguration() {
    }

    @ConstructorProperties(value={"reference", "isa", "baseConfigurationReference", "buildSettings", "name", "quoteSettings"})
    public XCBuildConfiguration(CommentedIdentifier reference, String isa, String baseConfigurationReference, Map<String, String> buildSettings, String name, List<String> quoteSettings) {
        this.reference = reference;
        this.isa = isa;
        this.baseConfigurationReference = baseConfigurationReference;
        this.buildSettings = buildSettings;
        this.name = name;
        this.quoteSettings = quoteSettings;
    }
}

