/*
 * Decompiled with CFR 0.152.
 */
package ca.mestevens.ios.xcode.parser.models;

import ca.mestevens.ios.xcode.parser.exceptions.InvalidObjectFormatException;
import ca.mestevens.ios.xcode.parser.models.CommentedIdentifier;
import ca.mestevens.ios.xcode.parser.utils.ObjectParser;
import java.beans.ConstructorProperties;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import org.apache.commons.lang3.builder.HashCodeBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PBXBuildFile
implements Comparable<PBXBuildFile> {
    private CommentedIdentifier reference;
    private String isa;
    private CommentedIdentifier fileRef;
    private Map<String, String> settings;

    public PBXBuildFile(String filename, String fileRef) {
        this.reference = new CommentedIdentifier(UUID.randomUUID().toString(), filename);
        this.isa = "PBXBuildFile";
        this.fileRef = new CommentedIdentifier(fileRef, filename);
        this.settings = new TreeMap<String, String>();
    }

    public PBXBuildFile(String buildFileString) throws InvalidObjectFormatException {
        try {
            buildFileString = buildFileString.trim();
            int equalsIndex = buildFileString.indexOf(61);
            String commentPart = "";
            String uuidPart = buildFileString.substring(0, equalsIndex).trim();
            if (uuidPart.contains("/*")) {
                int commentStartIndex = uuidPart.indexOf("/*");
                int commentEndIndex = uuidPart.indexOf("*/");
                commentPart = buildFileString.substring(commentStartIndex + 2, commentEndIndex).trim();
                uuidPart = uuidPart.substring(0, commentStartIndex).trim();
            }
            this.reference = new CommentedIdentifier(uuidPart, commentPart);
            this.settings = new TreeMap<String, String>();
            ObjectParser parser = new ObjectParser(buildFileString);
            parser = parser.getNextNestedObjects();
            String parserObject = parser.parseNextObject();
            while (parserObject != null) {
                parserObject = parserObject.substring(0, parserObject.length() - 1);
                String[] splitObject = parserObject.split("=");
                String key = splitObject[0].trim();
                String value = splitObject[1].trim();
                if (key.equals("isa")) {
                    this.isa = value;
                } else if (key.equals("fileRef")) {
                    this.fileRef = parser.getCommentedIdentifier(value);
                } else {
                    this.settings.put(key, value);
                }
                parserObject = parser.parseNextObject();
            }
        }
        catch (Exception ex) {
            throw new InvalidObjectFormatException(ex);
        }
    }

    public String toString() {
        Map<String, String> tempSettings = this.settings;
        tempSettings.put("fileRef", this.fileRef.toString());
        String returnString = this.reference.toString() + " = {";
        returnString = returnString + "isa = " + this.isa + "; ";
        for (String key : tempSettings.keySet()) {
            returnString = returnString + key + " = " + tempSettings.get(key) + "; ";
        }
        returnString = returnString + "};";
        return returnString;
    }

    public String toString(int numberOfTabs) {
        String returnString = "";
        for (int i = 0; i < numberOfTabs; ++i) {
            returnString = returnString + "\t";
        }
        returnString = returnString + this.toString();
        return returnString;
    }

    public boolean equals(Object o) {
        if (o instanceof PBXBuildFile) {
            PBXBuildFile oBuildFile = (PBXBuildFile)o;
            return oBuildFile.getFileRef().equals(this.fileRef);
        }
        return false;
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append((Object)this.reference);
        builder.append((Object)this.isa);
        builder.append((Object)this.fileRef);
        return builder.toHashCode();
    }

    @Override
    public int compareTo(PBXBuildFile o) {
        return this.reference.getIdentifier().compareTo(o.getReference().getIdentifier());
    }

    public CommentedIdentifier getReference() {
        return this.reference;
    }

    public String getIsa() {
        return this.isa;
    }

    public CommentedIdentifier getFileRef() {
        return this.fileRef;
    }

    public Map<String, String> getSettings() {
        return this.settings;
    }

    public void setReference(CommentedIdentifier reference) {
        this.reference = reference;
    }

    public void setIsa(String isa) {
        this.isa = isa;
    }

    public void setFileRef(CommentedIdentifier fileRef) {
        this.fileRef = fileRef;
    }

    public void setSettings(Map<String, String> settings) {
        this.settings = settings;
    }

    public PBXBuildFile() {
    }

    @ConstructorProperties(value={"reference", "isa", "fileRef", "settings"})
    public PBXBuildFile(CommentedIdentifier reference, String isa, CommentedIdentifier fileRef, Map<String, String> settings) {
        this.reference = reference;
        this.isa = isa;
        this.fileRef = fileRef;
        this.settings = settings;
    }
}

