/*
 * Decompiled with CFR 0.152.
 */
package ca.mestevens.ios;

import ca.mestevens.ios.utils.ProcessRunner;
import java.util.ArrayList;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="xcode-package-app", defaultPhase=LifecyclePhase.PACKAGE)
public class XcodePackageApplicationMojo
extends AbstractMojo {
    @Parameter(alias="xcrun", property="xcode.project.xcrun.path", defaultValue="/usr/bin/xcrun", required=true)
    public String xcrun;
    @Parameter(alias="deployApp", property="xcode.project.deploy", defaultValue="false", required=false)
    public boolean deploy;
    @Parameter(alias="iPhoneSimulatorName", property="xcode.project.simulator.name", defaultValue="iPhone 6 (8.1 Simulator)", required=false)
    public String deployDevice;
    @Parameter(alias="bundleId", property="xcode.project.bundle.id", required=true)
    public String bundleId;
    @Parameter(alias="simulatorAppPath", property="xcode.project.simulator.app.path", defaultValue="${project.build.directory}/build/iPhone-simulator/${project.artifactId}.app", required=true)
    public String simulatorAppPath;
    @Parameter(alias="deviceAppPath", property="xcode.project.device.app.path", defaultValue="${project.build.directory}/build/iPhone/${project.artifactId}.app", required=true)
    public String deviceAppPath;
    @Parameter(alias="ipaName", property="xcode.project.ipa.name", defaultValue="${project.artifactId}.ipa", required=false)
    public String ipaName;
    @Parameter(property="project.build.directory", readonly=true, required=true)
    public String targetDirectory;
    @Parameter(alias="buildSimulator", property="xcode.project.build.simulator", defaultValue="true", required=false)
    public boolean buildSimulator;
    @Parameter(alias="buildDevice", property="xcode.project.build.device", defaultValue="true", required=false)
    public boolean buildDevice;
    public ProcessRunner processRunner = new ProcessRunner(this.getLog(), false);

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.buildDevice) {
            ArrayList<String> packageCommand = new ArrayList<String>();
            packageCommand.add(this.xcrun);
            packageCommand.add("-sdk");
            packageCommand.add("iphoneos");
            packageCommand.add("PackageApplication");
            packageCommand.add("-v");
            packageCommand.add(this.deviceAppPath);
            packageCommand.add("-o");
            packageCommand.add(this.targetDirectory + "/" + this.ipaName);
            this.processRunner.runProcess(this.targetDirectory, packageCommand.toArray(new String[packageCommand.size()]));
        }
        if (this.deploy) {
            int returnCode = this.processRunner.runProcess(this.targetDirectory, "ios-deploy", "-c");
            if (returnCode == 127) {
                returnCode = this.processRunner.runProcess(this.targetDirectory, "npm", "install", "-g", "ios-deploy");
                if (returnCode == 127) {
                    returnCode = this.processRunner.runProcess(this.targetDirectory, "brew", "install", "node");
                    if (returnCode == 127) {
                        returnCode = this.processRunner.runProcess(this.targetDirectory, "ruby", "-e", "\"$(curl -fsSL https://raw.githubusercontent.com/Homebrew/install/master/install)\"");
                        if (returnCode == 127) {
                            throw new MojoFailureException("Could not run ruby to install brew. Please install ruby and try again.");
                        }
                        this.processRunner.runProcess(this.targetDirectory, "brew", "install", "node");
                    }
                    this.processRunner.runProcess(this.targetDirectory, "npm", "install", "-g", "ios-deploy");
                }
                returnCode = this.processRunner.runProcess(this.targetDirectory, "ios-deploy", "-c");
            }
            if (returnCode == 0 && this.buildDevice) {
                this.processRunner.runProcess(this.targetDirectory, "ios-deploy", "-b", this.deviceAppPath);
            } else if (this.buildSimulator) {
                ArrayList<String> instrumentsCommand = new ArrayList<String>();
                instrumentsCommand.add(this.xcrun);
                instrumentsCommand.add("instruments");
                instrumentsCommand.add("-w");
                instrumentsCommand.add(this.deployDevice);
                this.processRunner.runProcess(this.targetDirectory, instrumentsCommand.toArray(new String[instrumentsCommand.size()]));
                ArrayList<String> simctlInstallCommand = new ArrayList<String>();
                simctlInstallCommand.add(this.xcrun);
                simctlInstallCommand.add("simctl");
                simctlInstallCommand.add("install");
                simctlInstallCommand.add("booted");
                simctlInstallCommand.add(this.simulatorAppPath);
                this.processRunner.runProcess(this.targetDirectory, simctlInstallCommand.toArray(new String[simctlInstallCommand.size()]));
                ArrayList<String> simctlLaunchCommand = new ArrayList<String>();
                simctlLaunchCommand.add(this.xcrun);
                simctlLaunchCommand.add("simctl");
                simctlLaunchCommand.add("launch");
                simctlLaunchCommand.add("booted");
                simctlLaunchCommand.add(this.bundleId);
                this.processRunner.runProcess(this.targetDirectory, simctlLaunchCommand.toArray(new String[simctlLaunchCommand.size()]));
            }
        }
    }
}

