/*
 * Decompiled with CFR 0.152.
 */
package ca.mestevens.ios.utils;

import ca.mestevens.ios.models.Dependency;
import ca.mestevens.ios.xcode.parser.exceptions.InvalidObjectFormatException;
import ca.mestevens.ios.xcode.parser.models.CommentedIdentifier;
import ca.mestevens.ios.xcode.parser.models.PBXBuildFile;
import ca.mestevens.ios.xcode.parser.models.PBXBuildPhase;
import ca.mestevens.ios.xcode.parser.models.PBXFileElement;
import ca.mestevens.ios.xcode.parser.models.PBXTarget;
import ca.mestevens.ios.xcode.parser.models.XCConfigurationList;
import ca.mestevens.ios.xcode.parser.models.XCodeProject;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XcodeProjectUtil {
    private String pbxProjLocation;
    private XCodeProject xcodeProject;

    public XcodeProjectUtil(String pbxProjLocation) throws InvalidObjectFormatException {
        this.pbxProjLocation = pbxProjLocation;
        this.xcodeProject = new XCodeProject(pbxProjLocation);
    }

    public boolean containsTestTarget() {
        List targets = this.xcodeProject.getNativeTargets();
        for (PBXTarget target : targets) {
            if (target.getProductType() == null || !target.getProductType().contains("com.apple.product-type.bundle.unit-test")) continue;
            return true;
        }
        return false;
    }

    public void addDependenciesToTarget(String targetName, List<File> dynamicFrameworks, List<File> staticFrameworks, List<File> libraries, List<Dependency> externalDependencies) throws MojoExecutionException {
        try {
            ArrayList<File> masterFileList = new ArrayList<File>();
            if (libraries == null) {
                libraries = new ArrayList<File>();
            }
            if (staticFrameworks == null) {
                staticFrameworks = new ArrayList<File>();
            }
            if (dynamicFrameworks == null) {
                dynamicFrameworks = new ArrayList<File>();
            }
            if (externalDependencies == null) {
                externalDependencies = new ArrayList<Dependency>();
            }
            masterFileList.addAll(libraries);
            masterFileList.addAll(staticFrameworks);
            masterFileList.addAll(dynamicFrameworks);
            ArrayList<CommentedIdentifier> fileReferenceIdentifiers = new ArrayList<CommentedIdentifier>();
            List<CommentedIdentifier> libraryFileReferences = this.addFileReferences(libraries);
            List<CommentedIdentifier> staticFrameworkFileReferences = this.addFileReferences(staticFrameworks);
            List<CommentedIdentifier> dynamicFrameworkFileReferences = this.addFileReferences(dynamicFrameworks);
            List<CommentedIdentifier> externalFileReferences = this.addExternalFileReferences(externalDependencies);
            fileReferenceIdentifiers.addAll(libraryFileReferences);
            fileReferenceIdentifiers.addAll(staticFrameworkFileReferences);
            fileReferenceIdentifiers.addAll(dynamicFrameworkFileReferences);
            fileReferenceIdentifiers.addAll(externalFileReferences);
            List<CommentedIdentifier> libraryBuildIdentifiers = this.addBuildFiles(libraryFileReferences, false);
            List<CommentedIdentifier> staticFrameworkBuildIdentifiers = this.addBuildFiles(staticFrameworkFileReferences, false);
            List<CommentedIdentifier> externalFrameworkBuildIdentifiers = this.addBuildFiles(externalFileReferences, false);
            List<CommentedIdentifier> dynamicFrameworkBuildIdentifiers = this.addBuildFiles(dynamicFrameworkFileReferences, true);
            PBXTarget target = this.getNativeTarget(targetName);
            this.linkLibraries(target.getReference().getIdentifier(), libraryBuildIdentifiers);
            this.linkLibraries(target.getReference().getIdentifier(), staticFrameworkBuildIdentifiers);
            this.linkLibraries(target.getReference().getIdentifier(), externalFrameworkBuildIdentifiers);
            this.embedLibraries(target, dynamicFrameworkBuildIdentifiers);
            XCConfigurationList configuration = this.xcodeProject.getConfigurationListWithIdentifier(target.getBuildConfigurationList().getIdentifier());
            for (CommentedIdentifier identifier : configuration.getBuildConfigurations()) {
                if (dynamicFrameworks != null && dynamicFrameworks.size() > 0 || staticFrameworks != null && staticFrameworks.size() > 0) {
                    this.addPropertyToList(identifier.getIdentifier(), "FRAMEWORK_SEARCH_PATHS", "\"${PROJECT_DIR}/target/xcode-dependencies/frameworks/**\"");
                    this.addPropertyToString(identifier.getIdentifier(), "LD_RUNPATH_SEARCH_PATHS", "@loader_path/Frameworks");
                    this.addPropertyToString(identifier.getIdentifier(), "LD_RUNPATH_SEARCH_PATHS", "@executable_path/Frameworks");
                }
                if (libraries == null || libraries.size() <= 0) continue;
                this.addPropertyToList(identifier.getIdentifier(), "HEADER_SEARCH_PATHS", "\"${PROJECT_DIR}/target/xcode-dependencies/libraries/**\"");
                this.addPropertyToList(identifier.getIdentifier(), "LIBRARY_SEARCH_PATHS", "\"${PROJECT_DIR}/target/xcode-dependencies/libraries/**\"");
            }
            if (fileReferenceIdentifiers.size() > 0) {
                this.createGroup(fileReferenceIdentifiers);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new MojoExecutionException(ex.getMessage());
        }
    }

    public void addPropertyToList(String buildConfiguration, String key, String value) {
        ArrayList<String> propertyList = this.xcodeProject.getBuildConfigurationPropertyAsList(buildConfiguration, key);
        if (propertyList == null) {
            propertyList = new ArrayList<String>();
        }
        if (!propertyList.contains(value)) {
            propertyList.add(value);
            this.xcodeProject.setBuildConfigurationProperty(buildConfiguration, key, propertyList);
        }
    }

    public void addPropertyToString(String buildConfiguration, String key, String value) {
        String property = this.xcodeProject.getBuildConfigurationProperty(buildConfiguration, key);
        if (property != null) {
            if (property.startsWith("\"")) {
                property = property.substring(1);
            }
            if (property.endsWith("\"")) {
                property = property.substring(0, property.length() - 1);
            }
            if (!(property = property.trim()).contains(value)) {
                property = property.concat(" " + value);
            }
            property = "\"" + property + "\"";
            this.xcodeProject.setBuildConfigurationProperty(buildConfiguration, key, property);
        } else {
            this.xcodeProject.setBuildConfigurationProperty(buildConfiguration, key, "\"" + value + "\"");
        }
    }

    public List<CommentedIdentifier> addBuildFiles(List<CommentedIdentifier> fileReferences, boolean embed) {
        ArrayList<CommentedIdentifier> buildFileReferences = new ArrayList<CommentedIdentifier>();
        String xcodeProjLocation = this.pbxProjLocation.substring(0, this.pbxProjLocation.lastIndexOf("/project.pbxproj"));
        for (CommentedIdentifier fileReference : fileReferences) {
            boolean skip = false;
            for (PBXFileElement fileElement : this.xcodeProject.getFileReferences()) {
                String fileName;
                if (!fileElement.getReference().getIdentifier().equals(fileReference.getIdentifier())) continue;
                String path = fileElement.getPath();
                if (path.startsWith("\"") && path.endsWith("\"")) {
                    path = path.substring(1);
                    path = path.substring(0, path.length() - 1);
                }
                if ((fileName = fileElement.getReference().getComment()).endsWith(".framework")) {
                    fileName = fileName.substring(0, fileName.lastIndexOf("."));
                    path = path + "/" + fileName;
                }
                File file = new File(xcodeProjLocation + "/../" + path);
                if (!fileElement.getSourceTree().equals("SOURCE_ROOT") || file.exists()) continue;
                skip = true;
            }
            if (skip) continue;
            List buildFiles = this.xcodeProject.getBuildFileWithFileRef(fileReference.getIdentifier());
            if (buildFiles.size() > 1) {
                Iterator buildFileIterator = buildFiles.iterator();
                ArrayList uniqueBuildFiles = new ArrayList();
                uniqueBuildFiles.add(buildFileIterator.next());
                while (buildFileIterator.hasNext()) {
                    PBXBuildFile nextBuildFile = (PBXBuildFile)buildFileIterator.next();
                    boolean foundBuildFile = false;
                    for (PBXBuildFile uniqueBuildFile : uniqueBuildFiles) {
                        if (!uniqueBuildFile.getFileRef().equals((Object)nextBuildFile.getFileRef()) || !uniqueBuildFile.getSettings().equals(nextBuildFile.getSettings())) continue;
                        foundBuildFile = true;
                    }
                    if (foundBuildFile) {
                        buildFileIterator.remove();
                        this.removeBuildFile(nextBuildFile.getReference().getIdentifier());
                        continue;
                    }
                    uniqueBuildFiles.add(nextBuildFile);
                }
            }
            PBXBuildFile buildFile = null;
            for (PBXBuildFile existingFile : buildFiles) {
                if (existingFile.getReference().getComment().contains(fileReference.getComment() + " in Frameworks")) {
                    buildFile = existingFile;
                    continue;
                }
                if (!existingFile.getReference().getComment().contains(fileReference.getComment() + " in Embed Frameworks")) continue;
                buildFile = existingFile;
            }
            if (buildFile == null && embed) {
                buildFile = new PBXBuildFile(fileReference.getComment() + " in Embed Frameworks", fileReference.getIdentifier());
                buildFile.getSettings().put("ATTRIBUTES", "(CodeSignOnCopy, )");
                this.xcodeProject.getBuildFiles().add(buildFile);
            } else if (buildFile == null) {
                buildFile = new PBXBuildFile(fileReference.getComment() + " in Frameworks", fileReference.getIdentifier());
                this.xcodeProject.getBuildFiles().add(buildFile);
            }
            buildFileReferences.add(buildFile.getReference());
        }
        return buildFileReferences;
    }

    public List<CommentedIdentifier> addFileReferences(List<File> files) {
        ArrayList<CommentedIdentifier> fileReferences = new ArrayList<CommentedIdentifier>();
        for (File dependencyFile : files) {
            if (!dependencyFile.exists()) continue;
            String frameworkPath = dependencyFile.getAbsolutePath().substring(dependencyFile.getAbsolutePath().lastIndexOf("target"));
            PBXFileElement fileReference = this.xcodeProject.getFileReferenceWithPath(frameworkPath);
            if (fileReference == null && (fileReference = this.xcodeProject.getFileReferenceWithPath("\"" + frameworkPath + "\"")) == null) {
                fileReference = this.xcodeProject.createFileReference(frameworkPath, "SOURCE_ROOT");
            }
            fileReferences.add(fileReference.getReference());
        }
        return fileReferences;
    }

    public List<CommentedIdentifier> addExternalFileReferences(List<Dependency> dependencies) {
        ArrayList<CommentedIdentifier> fileReferences = new ArrayList<CommentedIdentifier>();
        for (Dependency dependencyFile : dependencies) {
            PBXFileElement fileReference;
            String path = dependencyFile.getPath();
            if (path == null) {
                path = "System/Library/Frameworks/" + dependencyFile.getName() + ".framework";
            }
            if ((fileReference = this.xcodeProject.getFileReferenceWithPath(path)) == null && (fileReference = this.xcodeProject.getFileReferenceWithPath("\"" + path + "\"")) == null) {
                String sourceTree = "SDKROOT";
                if (dependencyFile.getPath() != null) {
                    sourceTree = "SOURCE_ROOT";
                }
                fileReference = this.xcodeProject.createFileReference(path, sourceTree);
            }
            fileReferences.add(fileReference.getReference());
        }
        return fileReferences;
    }

    public void createGroup(List<CommentedIdentifier> identifiers) {
        String frameworkGroupIdentifier = null;
        for (PBXFileElement group : this.xcodeProject.getGroups()) {
            if (group.getName() == null || !group.getName().equals("Frameworks") && !group.getName().equals("\"Frameworks\"")) continue;
            frameworkGroupIdentifier = group.getReference().getIdentifier();
        }
        if (frameworkGroupIdentifier != null) {
            PBXFileElement frameworkGroup = this.xcodeProject.getGroupWithIdentifier(frameworkGroupIdentifier);
            for (CommentedIdentifier fileReference : identifiers) {
                boolean found = false;
                for (CommentedIdentifier child : frameworkGroup.getChildren()) {
                    if (!child.getComment().equals(fileReference.getComment())) continue;
                    found = true;
                }
                if (found) continue;
                frameworkGroup.addChild(fileReference);
            }
        } else {
            String mainGroupIdentifier = this.xcodeProject.getProject().getMainGroup().getIdentifier();
            this.xcodeProject.createGroup("Frameworks", identifiers, mainGroupIdentifier);
        }
    }

    public void linkLibraries(String targetIdentifier, List<CommentedIdentifier> identifiers) {
        PBXBuildPhase frameworksBuildPhase;
        String existingFrameworksPhaseId = null;
        PBXTarget nativeTarget = this.xcodeProject.getNativeTargetWithIdentifier(targetIdentifier);
        for (CommentedIdentifier buildPhaseIdentifier : nativeTarget.getBuildPhases()) {
            if (!buildPhaseIdentifier.getComment().equals("Frameworks")) continue;
            existingFrameworksPhaseId = buildPhaseIdentifier.getIdentifier();
            break;
        }
        if ((frameworksBuildPhase = this.xcodeProject.getFrameworksBuildPhaseWithIdentifier(existingFrameworksPhaseId)).getReference().getIdentifier().equals(existingFrameworksPhaseId)) {
            for (CommentedIdentifier identifier : identifiers) {
                if (frameworksBuildPhase.getFiles().contains(identifier) || frameworksBuildPhase.getFiles().contains("\"" + identifier + "\"")) continue;
                frameworksBuildPhase.getFiles().add(identifier);
            }
        }
    }

    public void embedLibraries(PBXTarget target, List<CommentedIdentifier> identifiers) {
        boolean foundExistingPhase = false;
        String copyFrameworksBuildPhaseIdentifier = null;
        for (CommentedIdentifier buildPhase : target.getBuildPhases()) {
            if (!buildPhase.getComment().contains("Embed Frameworks")) continue;
            copyFrameworksBuildPhaseIdentifier = buildPhase.getIdentifier();
        }
        for (PBXBuildPhase copyFilesBuildPhase : this.xcodeProject.getCopyFilesBuildPhases()) {
            if (!copyFilesBuildPhase.getReference().getIdentifier().equals(copyFrameworksBuildPhaseIdentifier)) continue;
            for (CommentedIdentifier identifier : identifiers) {
                boolean foundFile = false;
                for (CommentedIdentifier fileIdentifier : copyFilesBuildPhase.getFiles()) {
                    if (!fileIdentifier.getComment().equals(identifier.getComment())) continue;
                    foundFile = true;
                }
                if (foundFile) continue;
                copyFilesBuildPhase.getFiles().add(identifier);
            }
            foundExistingPhase = true;
        }
        if (!foundExistingPhase && identifiers.size() > 0) {
            PBXBuildPhase copyFrameworksBuildPhase = new PBXBuildPhase("PBXCopyFilesBuildPhase", "\"Embed Frameworks\"", identifiers, "\"\"", Integer.valueOf(10));
            this.xcodeProject.addCopyFilesBuildPhase(target.getReference().getIdentifier(), copyFrameworksBuildPhase);
        }
    }

    public PBXTarget getNativeTarget(String targetName) {
        for (PBXTarget target : this.xcodeProject.getNativeTargets()) {
            if (target.getName() == null || !target.getName().equals(targetName) && !target.getName().equals("\"" + targetName + "\"")) continue;
            return target;
        }
        return null;
    }

    public void removeBuildFile(String identifier) {
        List buildFiles = this.xcodeProject.getBuildFiles();
        Iterator buildFileIt = buildFiles.iterator();
        while (buildFileIt.hasNext()) {
            PBXBuildFile buildFile = (PBXBuildFile)buildFileIt.next();
            if (!buildFile.getReference().getIdentifier().equals(identifier)) continue;
            buildFileIt.remove();
        }
        List groups = this.xcodeProject.getGroups();
        for (PBXFileElement group : groups) {
            Iterator commentedIdentifierIt = group.getChildren().iterator();
            while (commentedIdentifierIt.hasNext()) {
                CommentedIdentifier commentedIdentifier = (CommentedIdentifier)commentedIdentifierIt.next();
                if (!commentedIdentifier.getIdentifier().equals(identifier)) continue;
                commentedIdentifierIt.remove();
            }
        }
        List frameworksBuildPhases = this.xcodeProject.getFrameworksBuildPhases();
        for (PBXBuildPhase frameworksBuildPhase : frameworksBuildPhases) {
            Iterator commentedIdentifierIt = frameworksBuildPhase.getFiles().iterator();
            while (commentedIdentifierIt.hasNext()) {
                CommentedIdentifier commentedIdentifier = (CommentedIdentifier)commentedIdentifierIt.next();
                if (!commentedIdentifier.getIdentifier().equals(identifier)) continue;
                commentedIdentifierIt.remove();
            }
        }
        List copyFilesBuildPhases = this.xcodeProject.getCopyFilesBuildPhases();
        for (PBXBuildPhase copyFilesBuildPhase : copyFilesBuildPhases) {
            Iterator commentedIdentifierIt = copyFilesBuildPhase.getFiles().iterator();
            while (commentedIdentifierIt.hasNext()) {
                CommentedIdentifier commentedIdentifier = (CommentedIdentifier)commentedIdentifierIt.next();
                if (!commentedIdentifier.getIdentifier().equals(identifier)) continue;
                commentedIdentifierIt.remove();
            }
        }
    }

    public void writeProject() throws IOException {
        Files.write(Paths.get(this.pbxProjLocation, new String[0]), this.xcodeProject.toString().getBytes(), new OpenOption[0]);
    }

    public String getPbxProjLocation() {
        return this.pbxProjLocation;
    }

    public XCodeProject getXcodeProject() {
        return this.xcodeProject;
    }

    public void setPbxProjLocation(String pbxProjLocation) {
        this.pbxProjLocation = pbxProjLocation;
    }

    public void setXcodeProject(XCodeProject xcodeProject) {
        this.xcodeProject = xcodeProject;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof XcodeProjectUtil)) {
            return false;
        }
        XcodeProjectUtil other = (XcodeProjectUtil)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$pbxProjLocation = this.getPbxProjLocation();
        String other$pbxProjLocation = other.getPbxProjLocation();
        if (this$pbxProjLocation == null ? other$pbxProjLocation != null : !this$pbxProjLocation.equals(other$pbxProjLocation)) {
            return false;
        }
        XCodeProject this$xcodeProject = this.getXcodeProject();
        XCodeProject other$xcodeProject = other.getXcodeProject();
        return !(this$xcodeProject == null ? other$xcodeProject != null : !this$xcodeProject.equals(other$xcodeProject));
    }

    protected boolean canEqual(Object other) {
        return other instanceof XcodeProjectUtil;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $pbxProjLocation = this.getPbxProjLocation();
        result = result * 59 + ($pbxProjLocation == null ? 0 : $pbxProjLocation.hashCode());
        XCodeProject $xcodeProject = this.getXcodeProject();
        result = result * 59 + ($xcodeProject == null ? 0 : $xcodeProject.hashCode());
        return result;
    }

    public String toString() {
        return "XcodeProjectUtil(pbxProjLocation=" + this.getPbxProjLocation() + ", xcodeProject=" + this.getXcodeProject() + ")";
    }
}

