/*
 * Decompiled with CFR 0.152.
 */
package ca.mestevens.ios.utils;

import ca.mestevens.ios.utils.ProcessRunner;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CopyDependenciesUtil {
    private final MavenProject project;
    private final Log log;
    private final ProcessRunner processRunner;

    public CopyDependenciesUtil(MavenProject project, Log log, ProcessRunner processRunner) {
        this.project = project;
        this.log = log;
        this.processRunner = processRunner;
    }

    public Map<String, List<File>> copyDependencies(String scope) throws MojoFailureException {
        Set artifacts = this.project.getArtifacts();
        HashMap<String, List<File>> dependencyMap = new HashMap<String, List<File>>();
        ArrayList<File> libraryFiles = new ArrayList<File>();
        ArrayList<File> dynamicFrameworkFiles = new ArrayList<File>();
        ArrayList<File> staticFrameworkFiles = new ArrayList<File>();
        for (Artifact artifact : artifacts) {
            String type = artifact.getType();
            if ("xcode-framework".equals(type)) {
                type = "xcode-dynamic-framework";
            }
            if (!"xcode-dynamic-framework".equals(type) && !"xcode-static-framework".equals(type) && !"xcode-library".equals(type)) continue;
            try {
                File file = artifact.getFile();
                String resultFileName = this.project.getBuild().getDirectory() + "/xcode-dependencies/";
                if (type.equals("xcode-dynamic-framework") || type.equals("xcode-static-framework")) {
                    resultFileName = resultFileName + "frameworks";
                } else if (type.equals("xcode-library")) {
                    resultFileName = resultFileName + "libraries";
                }
                resultFileName = resultFileName + "/" + artifact.getGroupId() + "/" + artifact.getArtifactId();
                File resultFile = new File(resultFileName);
                if (resultFile.exists()) {
                    FileUtils.deleteDirectory((File)resultFile);
                }
                FileUtils.mkdir((String)resultFile.getAbsolutePath());
                this.processRunner.runProcess(null, "unzip", file.getAbsolutePath(), "-d", resultFile.getAbsolutePath());
                if (type.equals("xcode-dynamic-framework")) {
                    dynamicFrameworkFiles.add(new File(resultFile.getAbsolutePath() + "/" + artifact.getArtifactId() + ".framework"));
                    continue;
                }
                if (type.equals("xcode-static-framework")) {
                    staticFrameworkFiles.add(new File(resultFile.getAbsolutePath() + "/" + artifact.getArtifactId() + ".framework"));
                    continue;
                }
                if (!type.equals("xcode-library")) continue;
                libraryFiles.add(new File(resultFile.getAbsolutePath() + "/lib" + artifact.getArtifactId() + ".a"));
            }
            catch (IOException e) {
                this.log.error((CharSequence)("Problem creating/deleting framework file: " + artifact.getArtifactId()));
                this.log.error((CharSequence)e.getMessage());
                throw new MojoFailureException("Problem creating/deleting framework file: " + artifact.getArtifactId());
            }
        }
        dependencyMap.put("libraries", libraryFiles);
        dependencyMap.put("static-frameworks", staticFrameworkFiles);
        dependencyMap.put("dynamic-frameworks", dynamicFrameworkFiles);
        return dependencyMap;
    }
}

