/*
 * Decompiled with CFR 0.152.
 */
package ca.mestevens.ios;

import ca.mestevens.ios.utils.CopyDependenciesUtil;
import ca.mestevens.ios.utils.ProcessRunner;
import ca.mestevens.ios.utils.XcodeProjectUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.RemoteRepository;

@Mojo(name="xcode-process-test-sources", defaultPhase=LifecyclePhase.PROCESS_TEST_SOURCES, requiresDependencyResolution=ResolutionScope.TEST)
public class XcodeProcessTestSourcesMojo
extends AbstractMojo {
    @Parameter(property="project", readonly=true, required=true)
    public MavenProject project;
    @Parameter(defaultValue="${project.remoteProjectRepositories}", readonly=true, required=true)
    public List<RemoteRepository> projectRepos;
    @Component
    public RepositorySystem repoSystem;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true)
    public RepositorySystemSession repoSession;
    @Parameter(alias="addDependencies", property="xcode.add.dependencies", defaultValue="false", required=true)
    public boolean addDependencies;
    @Parameter(alias="addTestDependencies", property="xcode.add.test.dependencies", defaultValue="true", required=true)
    public boolean addTestDependencies;
    @Parameter(alias="project", property="xcode.project.path", defaultValue="${basedir}/${project.artifactId}.xcodeproj", required=true)
    public String xcodeProject;
    @Parameter
    public List<String> dependencyTestTargets;
    public ProcessRunner processRunner = new ProcessRunner(this.getLog());
    public CopyDependenciesUtil copyDependenciesUtil;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)"Starting execution");
        this.copyDependenciesUtil = new CopyDependenciesUtil(this.project, this.getLog(), this.processRunner);
        Map<String, List<File>> dependencyMap = this.copyDependenciesUtil.copyDependencies("test");
        if (this.addDependencies) {
            try {
                XcodeProjectUtil projectUtil = new XcodeProjectUtil(this.xcodeProject + "/project.pbxproj");
                if (!projectUtil.containsTestTarget()) {
                    this.getLog().info((CharSequence)"No test target found.");
                    return;
                }
                if (this.addTestDependencies) {
                    if (this.dependencyTestTargets == null) {
                        this.dependencyTestTargets = new ArrayList<String>();
                    }
                    if (this.dependencyTestTargets.isEmpty()) {
                        this.dependencyTestTargets.add(this.project.getArtifactId() + "Tests");
                    }
                    for (String target : this.dependencyTestTargets) {
                        projectUtil.addDependenciesToTarget(target, dependencyMap.get("dynamic-frameworks"), dependencyMap.get("static-frameworks"), dependencyMap.get("libraries"), null);
                    }
                }
                projectUtil.writeProject();
            }
            catch (Exception ex) {
                throw new MojoFailureException(ex.getMessage());
            }
        }
    }
}

