/*
 * Decompiled with CFR 0.152.
 */
package ca.mestevens.ios;

import ca.mestevens.ios.utils.ProcessRunner;
import ca.mestevens.ios.xcode.parser.exceptions.InvalidObjectFormatException;
import ca.mestevens.ios.xcode.parser.models.CommentedIdentifier;
import ca.mestevens.ios.xcode.parser.models.XCBuildConfiguration;
import ca.mestevens.ios.xcode.parser.models.XCConfigurationList;
import ca.mestevens.ios.xcode.parser.models.XCodeProject;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Mojo(name="xcode-build", defaultPhase=LifecyclePhase.COMPILE)
public class XcodeBuildMojo
extends AbstractMojo {
    @Parameter(property="project", readonly=true, required=true)
    public MavenProject project;
    @Parameter(alias="xcodebuildPath", property="xcodebuild.path", defaultValue="/usr/bin/xcodebuild", required=true)
    public String xcodebuild;
    @Parameter(alias="project", property="xcode.project.path", defaultValue="${basedir}/${project.artifactId}.xcodeproj", required=true)
    public String xcodeProject;
    @Parameter(alias="target", property="xcode.project.target", required=false)
    public String xcodeTarget;
    @Parameter(alias="allTargets", property="xcode.project.all.targets", required=false)
    public boolean xcodeAllTargets;
    @Parameter(alias="workspace", property="xcode.project.workspace", required=false)
    public String xcodeWorkspace;
    @Parameter(alias="scheme", property="xcode.project.scheme", defaultValue="${project.artifactId}", required=true)
    public String xcodeScheme;
    @Parameter(alias="destinationTimeout", property="xcode.project.destination.timeout", required=false)
    public Integer xcodeDestinationTimeout;
    @Parameter(alias="configuration", property="xcode.project.configuration.name", required=false)
    public String xcodeConfigurationName;
    @Parameter(alias="derivedDataPath", property="xcode.project.derived.data.path", required=false)
    public String xcodeDerivedDataPath;
    @Parameter(alias="resultBundlePath", property="xcode.project.result.bundle.path", required=false)
    public String xcodeResultBundlePath;
    @Parameter(alias="xcconfig", property="xcode.project.xcconfig.file.name", required=false)
    public String xcodeXcconfig;
    @Parameter(alias="skipUnavailableActions", property="xcode.project.skip.unavailable.actions", defaultValue="false", required=false)
    public boolean xcodeSkipUnavailableActions;
    @Parameter(property="project.build.directory", readonly=true, required=true)
    public String targetDirectory;
    @Parameter(alias="xcodeProjectArtifactName", property="xcode.artifact.name", defaultValue="${project.artifactId}", required=true)
    public String artifactName;
    @Parameter
    public List<String> simulatorArchs;
    @Parameter
    public List<String> deviceArchs;
    @Parameter
    public Map<String, String> buildSettings;
    @Parameter
    public Map<String, String> userDefaults;
    @Parameter(alias="buildSimulator", property="xcode.project.build.simulator", defaultValue="true", required=false)
    public boolean buildSimulator;
    @Parameter(alias="buildDevice", property="xcode.project.build.device", defaultValue="true", required=false)
    public boolean buildDevice;
    @Parameter(alias="forceCodeSigning", property="xcode.project.force.code.signing", defaultValue="false", required=false)
    public boolean forceCodeSigning;
    public ProcessRunner processRunner = new ProcessRunner(this.getLog());

    public void execute() throws MojoExecutionException, MojoFailureException {
        String packaging = this.project.getPackaging();
        if ("xcode-framework".equals(packaging)) {
            packaging = "xcode-dynamic-framework";
        }
        if (packaging.equals("xcode-dynamic-framework") || packaging.equals("xcode-static-framework") || packaging.equals("xcode-library")) {
            if (this.simulatorArchs == null) {
                this.simulatorArchs = new ArrayList<String>();
                this.simulatorArchs.add("i386");
                this.simulatorArchs.add("x86_64");
            }
            if (this.deviceArchs == null) {
                this.deviceArchs = new ArrayList<String>();
                File pbxprojFile = new File(this.xcodeProject + "/project.pbxproj");
                if (pbxprojFile.exists()) {
                    try {
                        XCodeProject project = new XCodeProject(this.xcodeProject + "/project.pbxproj");
                        XCConfigurationList mainConfiguration = project.getConfigurationListWithIdentifier(project.getProject().getBuildConfigurationList().getIdentifier());
                        for (CommentedIdentifier configuration : mainConfiguration.getBuildConfigurations()) {
                            List archs;
                            XCBuildConfiguration buildConfiguration = project.getBuildConfigurationWithIdentifier(configuration.getIdentifier());
                            if (buildConfiguration == null || (archs = buildConfiguration.getBuildSettingAsList("ARCHS")) == null) continue;
                            this.deviceArchs = archs;
                            break;
                        }
                    }
                    catch (InvalidObjectFormatException e) {
                        throw new MojoExecutionException(e.getMessage());
                    }
                }
                if (this.deviceArchs.isEmpty()) {
                    this.deviceArchs.add("armv7");
                    this.deviceArchs.add("arm64");
                }
            }
            if (this.simulatorArchs == null || this.simulatorArchs.isEmpty()) {
                this.buildSimulator = false;
            }
            if (this.deviceArchs == null || this.deviceArchs.isEmpty()) {
                this.buildDevice = false;
            }
            int returnValue = 0;
            List<String> buildCommands = this.createCommonBuildCommands();
            if (!this.forceCodeSigning) {
                buildCommands.add("CODE_SIGNING_REQUIRED=NO");
            }
            if (this.buildSimulator) {
                for (String simulatorArch : this.simulatorArchs) {
                    ArrayList<String> simulatorBuildCommands = new ArrayList<String>(buildCommands);
                    simulatorBuildCommands.add("-sdk");
                    simulatorBuildCommands.add("iphonesimulator");
                    simulatorBuildCommands.add("-arch");
                    simulatorBuildCommands.add(simulatorArch);
                    simulatorBuildCommands.add("CONFIGURATION_BUILD_DIR=" + this.targetDirectory + "/iphonesimulator-" + simulatorArch);
                    simulatorBuildCommands.add("build");
                    returnValue = this.processRunner.runProcess(null, simulatorBuildCommands.toArray(new String[simulatorBuildCommands.size()]));
                    this.checkReturnValue(returnValue);
                }
            }
            if (this.buildDevice) {
                for (String deviceArch : this.deviceArchs) {
                    ArrayList<String> deviceBuildCommands = new ArrayList<String>(buildCommands);
                    deviceBuildCommands.add("-sdk");
                    deviceBuildCommands.add("iphoneos");
                    deviceBuildCommands.add("-arch");
                    deviceBuildCommands.add(deviceArch);
                    deviceBuildCommands.add("CONFIGURATION_BUILD_DIR=" + this.targetDirectory + "/iphoneos-" + deviceArch);
                    deviceBuildCommands.add("build");
                    returnValue = this.processRunner.runProcess(null, deviceBuildCommands.toArray(new String[deviceBuildCommands.size()]));
                    this.checkReturnValue(returnValue);
                }
            }
            if (this.buildSimulator || this.buildDevice) {
                File file;
                ArrayList<String> lipoCommand = new ArrayList<String>();
                lipoCommand.add("lipo");
                lipoCommand.add("-create");
                lipoCommand.add("-output");
                String libraryLocation = "";
                if (packaging.equals("xcode-dynamic-framework")) {
                    lipoCommand.add(this.artifactName);
                    libraryLocation = this.artifactName + ".framework/" + this.artifactName;
                } else if (packaging.equals("xcode-library") || packaging.equals("xcode-static-framework")) {
                    lipoCommand.add("lib" + this.artifactName + ".a");
                    libraryLocation = "lib" + this.artifactName + ".a";
                }
                boolean fileExists = false;
                for (String simulatorArch : this.simulatorArchs) {
                    lipoCommand.add("iphonesimulator-" + simulatorArch + "/" + libraryLocation);
                    file = new File(this.targetDirectory + "/iphonesimulator-" + simulatorArch + "/" + libraryLocation);
                    if (!file.exists()) continue;
                    fileExists = true;
                }
                for (String deviceArch : this.deviceArchs) {
                    lipoCommand.add("iphoneos-" + deviceArch + "/" + libraryLocation);
                    file = new File(this.targetDirectory + "/iphoneos-" + deviceArch + "/" + libraryLocation);
                    if (!file.exists()) continue;
                    fileExists = true;
                }
                System.out.println(!packaging.equals("xcode-library"));
                if (fileExists || !packaging.equals("xcode-static-framework") && !packaging.equals("xcode-library")) {
                    returnValue = this.processRunner.runProcess(this.targetDirectory, lipoCommand.toArray(new String[lipoCommand.size()]));
                    this.checkReturnValue(returnValue);
                }
                if (packaging.equals("xcode-dynamic-framework")) {
                    if (this.buildDevice) {
                        this.processRunner.runProcess(this.targetDirectory, "cp", "-r", "iphoneos-" + this.deviceArchs.get(0) + "/" + this.artifactName + ".framework", ".");
                    } else {
                        this.processRunner.runProcess(this.targetDirectory, "cp", "-r", "iphonesimulator-" + this.simulatorArchs.get(0) + "/" + this.artifactName + ".framework", ".");
                    }
                    this.processRunner.runProcess(this.targetDirectory, "cp", this.artifactName, this.artifactName + ".framework/.");
                } else if (packaging.equals("xcode-static-framework")) {
                    File frameworkFile;
                    this.processRunner.runProcess(this.targetDirectory, "cp", "-r", "iphoneos-" + this.deviceArchs.get(0) + "/include", "Headers");
                    if (fileExists) {
                        this.processRunner.runProcess(this.targetDirectory, "mv", libraryLocation, this.artifactName);
                    }
                    if ((frameworkFile = new File(this.targetDirectory + "/" + this.artifactName + ".framework")).exists()) {
                        try {
                            FileUtils.deleteDirectory((File)frameworkFile);
                        }
                        catch (IOException e) {
                            this.getLog().error((CharSequence)("Problem creating/deleting framework file: " + this.artifactName));
                            this.getLog().error((CharSequence)e.getMessage());
                            throw new MojoFailureException("Problem creating/deleting framework file: " + this.artifactName);
                        }
                    }
                    this.processRunner.runProcess(this.targetDirectory, "mkdir", this.artifactName + ".framework");
                    if (fileExists) {
                        this.processRunner.runProcess(this.targetDirectory, "cp", "-R", "Headers", this.artifactName, this.artifactName + ".framework");
                    } else {
                        this.processRunner.runProcess(this.targetDirectory, "cp", "-R", "Headers", this.artifactName + ".framework");
                    }
                } else if (packaging.equals("xcode-library")) {
                    this.processRunner.runProcess(this.targetDirectory, "cp", "-r", "iphoneos-" + this.deviceArchs.get(0) + "/include", "headers");
                }
            }
        } else if (packaging.equals("xcode-application")) {
            List<String> applicationBuildCommands = this.createCommonBuildCommands();
            applicationBuildCommands.add("build");
            int returnValue = 0;
            if (this.buildSimulator) {
                ArrayList<String> simulatorBuildCommands = new ArrayList<String>(applicationBuildCommands);
                simulatorBuildCommands.add("-sdk");
                simulatorBuildCommands.add("iphonesimulator");
                simulatorBuildCommands.add("CONFIGURATION_BUILD_DIR=" + this.targetDirectory + "/build/iPhone-simulator");
                returnValue = this.processRunner.runProcess(null, simulatorBuildCommands.toArray(new String[simulatorBuildCommands.size()]));
                this.checkReturnValue(returnValue);
            }
            if (this.buildDevice) {
                ArrayList<String> deviceBuildCommands = new ArrayList<String>(applicationBuildCommands);
                deviceBuildCommands.add("-sdk");
                deviceBuildCommands.add("iphoneos");
                deviceBuildCommands.add("CONFIGURATION_BUILD_DIR=" + this.targetDirectory + "/build/iPhone");
                returnValue = this.processRunner.runProcess(null, deviceBuildCommands.toArray(new String[deviceBuildCommands.size()]));
                this.checkReturnValue(returnValue);
            }
        }
    }

    protected void checkReturnValue(int returnValue) throws MojoFailureException {
        if (returnValue != 0) {
            throw new MojoFailureException("Failed to build project.");
        }
    }

    protected List<String> createCommonBuildCommands() {
        ArrayList<String> buildCommands = new ArrayList<String>();
        buildCommands.add(this.xcodebuild);
        buildCommands.add("-project");
        buildCommands.add(this.xcodeProject);
        buildCommands.add("-scheme");
        buildCommands.add(this.xcodeScheme);
        if (this.xcodeTarget != null && !this.xcodeTarget.isEmpty()) {
            buildCommands.add("-target");
            buildCommands.add(this.xcodeTarget);
        }
        if (this.xcodeAllTargets) {
            buildCommands.add("-alltargets");
        }
        if (this.xcodeWorkspace != null && !this.xcodeWorkspace.isEmpty()) {
            buildCommands.add("-workspace");
            buildCommands.add(this.xcodeWorkspace);
        }
        if (this.xcodeDestinationTimeout != null && this.xcodeDestinationTimeout > 0) {
            buildCommands.add("-destination-timeout");
            buildCommands.add(this.xcodeDestinationTimeout.toString());
        }
        if (this.xcodeConfigurationName != null && !this.xcodeConfigurationName.isEmpty()) {
            buildCommands.add("-configuration");
            buildCommands.add(this.xcodeConfigurationName);
        }
        if (this.xcodeDerivedDataPath != null && !this.xcodeDerivedDataPath.isEmpty()) {
            buildCommands.add("-derivedDataPath");
            buildCommands.add(this.xcodeDerivedDataPath);
        }
        if (this.xcodeResultBundlePath != null && !this.xcodeResultBundlePath.isEmpty()) {
            buildCommands.add("-resultBundlePath");
            buildCommands.add(this.xcodeResultBundlePath);
        }
        if (this.xcodeXcconfig != null && !this.xcodeXcconfig.isEmpty()) {
            buildCommands.add("-xcconfig");
            buildCommands.add(this.xcodeXcconfig);
        }
        if (this.xcodeSkipUnavailableActions) {
            buildCommands.add("-skipUnavailableActions");
        }
        if (this.buildSettings != null) {
            for (String key : this.buildSettings.keySet()) {
                buildCommands.add(key + "=" + this.buildSettings.get(key));
            }
        }
        if (this.userDefaults != null) {
            for (String key : this.userDefaults.keySet()) {
                buildCommands.add("-" + key + "=" + this.userDefaults.get(key));
            }
        }
        return buildCommands;
    }
}

