/*
 * Decompiled with CFR 0.152.
 */
package ca.mestevens.ios;

import ca.mestevens.ios.utils.ProcessRunner;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.FileUtils;

@Mojo(name="xcode-package-framework", defaultPhase=LifecyclePhase.PACKAGE)
public class XcodePackageMojo
extends AbstractMojo {
    @Parameter(property="project", readonly=true, required=true)
    public MavenProject project;
    @Parameter(property="project.build.directory", readonly=true, required=true)
    public String targetDirectory;
    @Parameter(alias="xcodeProjectArtifactName", property="xcode.artifact.name", defaultValue="${project.artifactId}", required=true)
    public String artifactName;
    public ProcessRunner processRunner = new ProcessRunner(this.getLog());

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            String packaging = this.project.getPackaging();
            if ("xcode-framework".equals(packaging)) {
                packaging = "xcode-dynamic-framework";
            }
            String packagedFileName = this.artifactName + "." + packaging;
            File zippedFile = new File(this.targetDirectory + "/" + packagedFileName);
            ArrayList<String> inputFiles = new ArrayList<String>();
            if (packaging.equals("xcode-dynamic-framework") || packaging.equals("xcode-static-framework")) {
                inputFiles.add(this.artifactName + ".framework");
            } else {
                inputFiles.add("lib" + this.artifactName + ".a");
                inputFiles.add("headers");
            }
            if (zippedFile.exists()) {
                FileUtils.deleteDirectory((File)zippedFile);
            }
            ArrayList<String> zipCommand = new ArrayList<String>();
            zipCommand.add("zip");
            zipCommand.add("-r");
            zipCommand.add(packagedFileName);
            for (String inputFile : inputFiles) {
                zipCommand.add(inputFile);
            }
            int returnValue = this.processRunner.runProcess(this.targetDirectory, zipCommand.toArray(new String[zipCommand.size()]));
            if (returnValue != 0) {
                this.getLog().error((CharSequence)("Could not zip file: " + this.artifactName));
                throw new MojoFailureException("Could not zip file: " + this.artifactName);
            }
            this.project.getArtifact().setFile(zippedFile);
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)"Error deleting directory");
            this.getLog().error((CharSequence)e.getMessage());
            throw new MojoFailureException("Error deleting directory");
        }
    }
}

