/*
 * Decompiled with CFR 0.152.
 */
package ca.mestevens.ios;

import ca.mestevens.ios.utils.ProcessRunner;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="set-keychain", defaultPhase=LifecyclePhase.INITIALIZE)
public class KeychainMojo
extends AbstractMojo {
    @Parameter(alias="securityPath", property="security.path", defaultValue="/usr/bin/security", required=true)
    public String security;
    @Parameter(alias="keychainPath", property="keychain.path", required=false)
    public String keychain;
    @Parameter(alias="keychainPassword", property="keychain.password", required=false)
    public String keychainPassword;
    public ProcessRunner processRunner = new ProcessRunner(this.getLog());

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.keychain == null || this.keychain.isEmpty()) {
            this.keychain = System.getenv("KEYCHAIN_PATH");
        }
        if (this.keychainPassword == null || this.keychainPassword.isEmpty()) {
            this.keychainPassword = System.getenv("KEYCHAIN_PASSWORD");
        }
        if (this.keychain == null || this.keychainPassword == null) {
            return;
        }
        this.getLog().info((CharSequence)String.format("%s list-keychains -s %s", this.security, this.keychain));
        this.processRunner.runProcess(null, this.security, "list-keychains", "-s", this.keychain);
        this.getLog().info((CharSequence)String.format("%s default-keychain -d user -s %s", this.security, this.keychain));
        this.processRunner.runProcess(null, this.security, "default-keychain", "-d", "user", "-s", this.keychain);
        String obfuscatedPassword = "";
        for (int i = 0; i < this.keychainPassword.length(); ++i) {
            obfuscatedPassword = obfuscatedPassword + "*";
        }
        this.getLog().info((CharSequence)String.format("%s unlock-keychain -p %s", this.security, obfuscatedPassword));
        this.processRunner.runProcess(null, this.security, "unlock-keychain", "-p", this.keychainPassword, this.keychain);
        this.getLog().info((CharSequence)String.format("%s show-keychain-info %s", this.security, this.keychain));
        this.processRunner.runProcess(null, this.security, "show-keychain-info", this.keychain);
    }
}

