/*
 * Decompiled with CFR 0.152.
 */
package ca.mestevens.ios.utils;

import ca.mestevens.ios.xcode.parser.exceptions.InvalidObjectFormatException;
import ca.mestevens.ios.xcode.parser.models.CommentedIdentifier;
import ca.mestevens.ios.xcode.parser.models.PBXBuildFile;
import ca.mestevens.ios.xcode.parser.models.PBXBuildPhase;
import ca.mestevens.ios.xcode.parser.models.PBXFileElement;
import ca.mestevens.ios.xcode.parser.models.PBXTarget;
import ca.mestevens.ios.xcode.parser.models.XCConfigurationList;
import ca.mestevens.ios.xcode.parser.models.XCodeProject;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XcodeProjectUtil {
    private String pbxProjLocation;
    private XCodeProject xcodeProject;

    public XcodeProjectUtil(String pbxProjLocation) throws InvalidObjectFormatException {
        this.pbxProjLocation = pbxProjLocation;
        this.xcodeProject = new XCodeProject(pbxProjLocation);
    }

    public void addDependenciesToTarget(String targetName, List<File> dependencyFiles) throws MojoExecutionException {
        try {
            PBXBuildPhase frameworksBuildPhase;
            ArrayList<CommentedIdentifier> frameworkIdentifiers = new ArrayList<CommentedIdentifier>();
            ArrayList<CommentedIdentifier> fileReferenceIdentifiers = new ArrayList<CommentedIdentifier>();
            ArrayList<CommentedIdentifier> copyIdentifiers = new ArrayList<CommentedIdentifier>();
            boolean containsFrameworks = false;
            boolean containsLibraries = false;
            for (File dependencyFile : dependencyFiles) {
                List buildFiles;
                String frameworkPath = dependencyFile.getAbsolutePath().substring(dependencyFile.getAbsolutePath().lastIndexOf("target"));
                PBXFileElement fileReference = this.xcodeProject.getFileReferenceWithPath(frameworkPath);
                if (fileReference == null) {
                    fileReference = this.xcodeProject.createFileReference(frameworkPath, "SOURCE_ROOT");
                }
                if ((buildFiles = this.xcodeProject.getBuildFileWithFileRefPath(frameworkPath)).isEmpty()) {
                    buildFiles = this.xcodeProject.getBuildFileWithFileRefPath("\"" + frameworkPath + "\"");
                }
                PBXBuildFile buildFile = null;
                PBXBuildFile copyBuildFile = null;
                for (PBXBuildFile existingFile : buildFiles) {
                    if (existingFile.getReference().getComment().contains(dependencyFile.getName() + " in Frameworks")) {
                        buildFile = existingFile;
                        continue;
                    }
                    if (!existingFile.getReference().getComment().contains(dependencyFile.getName() + " in Embed Frameworks")) continue;
                    copyBuildFile = existingFile;
                }
                String fileExtension = dependencyFile.getAbsolutePath().substring(dependencyFile.getAbsolutePath().lastIndexOf(46) + 1);
                if (fileExtension.equals("a")) {
                    containsLibraries = true;
                }
                if (fileExtension.equals("framework")) {
                    containsFrameworks = true;
                }
                if (buildFile == null) {
                    buildFile = this.xcodeProject.createBuildFileFromFileReferencePath(frameworkPath, dependencyFile.getName() + " in Frameworks");
                }
                if (copyBuildFile == null && fileExtension.equals("framework")) {
                    copyBuildFile = this.xcodeProject.createBuildFileFromFileReferencePath(frameworkPath, dependencyFile.getName() + " in Embed Frameworks");
                    copyBuildFile.getSettings().put("ATTRIBUTES", "(CodeSignOnCopy, )");
                }
                frameworkIdentifiers.add(buildFile.getReference());
                fileReferenceIdentifiers.add(fileReference.getReference());
                if (copyBuildFile == null) continue;
                copyIdentifiers.add(copyBuildFile.getReference());
            }
            String targetIdentifier = "";
            String copyFrameworksBuildPhaseIdentifier = "";
            for (PBXTarget target : this.xcodeProject.getNativeTargets()) {
                if (target.getName() == null || !target.getName().equals(targetName)) continue;
                targetIdentifier = target.getReference().getIdentifier();
                for (CommentedIdentifier buildPhase : target.getBuildPhases()) {
                    if (!buildPhase.getComment().contains("Embed Frameworks")) continue;
                    copyFrameworksBuildPhaseIdentifier = buildPhase.getIdentifier();
                }
            }
            if (targetIdentifier.equals("")) {
                return;
            }
            boolean foundExistingPhase = false;
            for (PBXBuildPhase copyFilesBuildPhase : this.xcodeProject.getCopyFilesBuildPhases()) {
                if (!copyFilesBuildPhase.getReference().getIdentifier().equals(copyFrameworksBuildPhaseIdentifier)) continue;
                for (CommentedIdentifier identifier : copyIdentifiers) {
                    boolean foundFile = false;
                    for (CommentedIdentifier fileIdentifier : copyFilesBuildPhase.getFiles()) {
                        if (!fileIdentifier.getComment().equals(identifier.getComment())) continue;
                        foundFile = true;
                    }
                    if (foundFile) continue;
                    copyFilesBuildPhase.getFiles().add(identifier);
                }
                foundExistingPhase = true;
            }
            if (!foundExistingPhase) {
                PBXBuildPhase copyFrameworksBuildPhase = new PBXBuildPhase("PBXCopyFilesBuildPhase", "\"Embed Frameworks\"", copyIdentifiers, "\"\"", Integer.valueOf(10));
                this.xcodeProject.addCopyFilesBuildPhase(targetIdentifier, copyFrameworksBuildPhase);
            }
            String existingFrameworksPhaseId = null;
            String buildConfigurationList = null;
            PBXTarget nativeTarget = this.xcodeProject.getNativeTargetWithIdentifier(targetIdentifier);
            for (CommentedIdentifier buildPhaseIdentifier : nativeTarget.getBuildPhases()) {
                if (!buildPhaseIdentifier.getComment().equals("Frameworks")) continue;
                existingFrameworksPhaseId = buildPhaseIdentifier.getIdentifier();
                buildConfigurationList = nativeTarget.getBuildConfigurationList().getIdentifier();
                break;
            }
            if ((frameworksBuildPhase = this.xcodeProject.getFrameworksBuildPhaseWithIdentifier(existingFrameworksPhaseId)).getReference().getIdentifier().equals(existingFrameworksPhaseId)) {
                for (CommentedIdentifier identifier : frameworkIdentifiers) {
                    if (frameworksBuildPhase.getFiles().contains(identifier)) continue;
                    frameworksBuildPhase.getFiles().add(identifier);
                }
            }
            XCConfigurationList configuration = this.xcodeProject.getConfigurationListWithIdentifier(buildConfigurationList);
            for (CommentedIdentifier identifier : configuration.getBuildConfigurations()) {
                ArrayList<String> librarySearchPaths;
                if (containsFrameworks) {
                    String ldRunpathSearchPaths;
                    ArrayList<String> frameworkSearchPaths = this.xcodeProject.getBuildConfigurationPropertyAsList(identifier.getIdentifier(), "FRAMEWORK_SEARCH_PATHS");
                    if (frameworkSearchPaths != null) {
                        if (!frameworkSearchPaths.contains("\"${PROJECT_DIR}/target/xcode-dependencies/frameworks/**\"")) {
                            frameworkSearchPaths.add("\"${PROJECT_DIR}/target/xcode-dependencies/frameworks/**\"");
                            this.xcodeProject.setBuildConfigurationProperty(identifier.getIdentifier(), "FRAMEWORK_SEARCH_PATHS", frameworkSearchPaths);
                        }
                    } else {
                        frameworkSearchPaths = new ArrayList<String>();
                        frameworkSearchPaths.add("\"${PROJECT_DIR}/target/xcode-dependencies/frameworks/**\"");
                        this.xcodeProject.setBuildConfigurationProperty(identifier.getIdentifier(), "FRAMEWORK_SEARCH_PATHS", frameworkSearchPaths);
                    }
                    if ((ldRunpathSearchPaths = this.xcodeProject.getBuildConfigurationProperty(identifier.getIdentifier(), "LD_RUNPATH_SEARCH_PATHS")) != null) {
                        if (ldRunpathSearchPaths.startsWith("\"")) {
                            ldRunpathSearchPaths = ldRunpathSearchPaths.substring(1);
                        }
                        if (ldRunpathSearchPaths.endsWith("\"")) {
                            ldRunpathSearchPaths = ldRunpathSearchPaths.substring(0, ldRunpathSearchPaths.length() - 1);
                        }
                        if (!(ldRunpathSearchPaths = ldRunpathSearchPaths.trim()).contains("@loader_path/Frameworks")) {
                            ldRunpathSearchPaths = ldRunpathSearchPaths.concat(" @loader_path/Frameworks");
                        }
                        if (!ldRunpathSearchPaths.contains("@executable_path/Frameworks")) {
                            ldRunpathSearchPaths = ldRunpathSearchPaths.concat(" @executable_path/Frameworks");
                        }
                        ldRunpathSearchPaths = "\"" + ldRunpathSearchPaths + "\"";
                        this.xcodeProject.setBuildConfigurationProperty(identifier.getIdentifier(), "LD_RUNPATH_SEARCH_PATHS", ldRunpathSearchPaths);
                    } else {
                        this.xcodeProject.setBuildConfigurationProperty(identifier.getIdentifier(), "LD_RUNPATH_SEARCH_PATHS", "\"@loader_path/Frameworks @executable_path/Frameworks\"");
                    }
                }
                if (!containsLibraries) continue;
                ArrayList<String> headerSearchPaths = this.xcodeProject.getBuildConfigurationPropertyAsList(identifier.getIdentifier(), "HEADER_SEARCH_PATHS");
                if (headerSearchPaths == null) {
                    headerSearchPaths = new ArrayList<String>();
                }
                if (!headerSearchPaths.contains("\"${PROJECT_DIR}/target/xcode-dependencies/libraries/**\"")) {
                    headerSearchPaths.add("\"${PROJECT_DIR}/target/xcode-dependencies/libraries/**\"");
                    this.xcodeProject.setBuildConfigurationProperty(identifier.getIdentifier(), "HEADER_SEARCH_PATHS", headerSearchPaths);
                }
                if ((librarySearchPaths = this.xcodeProject.getBuildConfigurationPropertyAsList(identifier.getIdentifier(), "LIBRARY_SEARCH_PATHS")) == null) {
                    librarySearchPaths = new ArrayList<String>();
                }
                if (librarySearchPaths.contains("\"${PROJECT_DIR}/target/xcode-dependencies/libraries/**\"")) continue;
                librarySearchPaths.add("\"${PROJECT_DIR}/target/xcode-dependencies/libraries/**\"");
                this.xcodeProject.setBuildConfigurationProperty(identifier.getIdentifier(), "LIBRARY_SEARCH_PATHS", librarySearchPaths);
            }
            String frameworkGroupIdentifier = null;
            for (PBXFileElement group : this.xcodeProject.getGroups()) {
                if (group.getName() == null || !group.getName().equals("Frameworks") && !group.getName().equals("\"Frameworks\"")) continue;
                frameworkGroupIdentifier = group.getReference().getIdentifier();
            }
            PBXFileElement frameworkGroup = null;
            if (frameworkGroupIdentifier != null) {
                frameworkGroup = this.xcodeProject.getGroupWithIdentifier(frameworkGroupIdentifier);
            } else {
                String mainGroupIdentifier = this.xcodeProject.getProject().getMainGroup().getIdentifier();
                frameworkGroup = this.xcodeProject.createGroup("Frameworks", mainGroupIdentifier);
            }
            for (CommentedIdentifier fileReference : fileReferenceIdentifiers) {
                boolean found = false;
                for (CommentedIdentifier child : frameworkGroup.getChildren()) {
                    if (!child.getComment().equals(fileReference.getComment())) continue;
                    found = true;
                }
                if (found) continue;
                frameworkGroup.addChild(fileReference);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new MojoExecutionException(ex.getMessage());
        }
    }

    public void writeProject() throws IOException {
        Files.write(Paths.get(this.pbxProjLocation, new String[0]), this.xcodeProject.toString().getBytes(), new OpenOption[0]);
    }

    public String getPbxProjLocation() {
        return this.pbxProjLocation;
    }

    public XCodeProject getXcodeProject() {
        return this.xcodeProject;
    }

    public void setPbxProjLocation(String pbxProjLocation) {
        this.pbxProjLocation = pbxProjLocation;
    }

    public void setXcodeProject(XCodeProject xcodeProject) {
        this.xcodeProject = xcodeProject;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof XcodeProjectUtil)) {
            return false;
        }
        XcodeProjectUtil other = (XcodeProjectUtil)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$pbxProjLocation = this.getPbxProjLocation();
        String other$pbxProjLocation = other.getPbxProjLocation();
        if (this$pbxProjLocation == null ? other$pbxProjLocation != null : !this$pbxProjLocation.equals(other$pbxProjLocation)) {
            return false;
        }
        XCodeProject this$xcodeProject = this.getXcodeProject();
        XCodeProject other$xcodeProject = other.getXcodeProject();
        return !(this$xcodeProject == null ? other$xcodeProject != null : !this$xcodeProject.equals(other$xcodeProject));
    }

    protected boolean canEqual(Object other) {
        return other instanceof XcodeProjectUtil;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $pbxProjLocation = this.getPbxProjLocation();
        result = result * 59 + ($pbxProjLocation == null ? 0 : $pbxProjLocation.hashCode());
        XCodeProject $xcodeProject = this.getXcodeProject();
        result = result * 59 + ($xcodeProject == null ? 0 : $xcodeProject.hashCode());
        return result;
    }

    public String toString() {
        return "XcodeProjectUtil(pbxProjLocation=" + this.getPbxProjLocation() + ", xcodeProject=" + this.getXcodeProject() + ")";
    }
}

