/*
 * Decompiled with CFR 0.152.
 */
package ca.mestevens.ios;

import ca.mestevens.ios.utils.ProcessRunner;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="xcode-test", defaultPhase=LifecyclePhase.TEST)
public class XcodeTestMojo
extends AbstractMojo {
    @Parameter(alias="xcodebuildPath", property="xcodebuild.path", defaultValue="/usr/bin/xcodebuild", required=true)
    public String xcodebuild;
    @Parameter(alias="project", property="xcode.project.path", defaultValue="${basedir}/${project.artifactId}.xcodeproj", required=true)
    public String xcodeProject;
    @Parameter(alias="xcodeProjectTestScheme", property="xcode.project.test.scheme", defaultValue="${project.artifactId}", required=true)
    public String xcodeScheme;
    @Parameter(property="project.build.directory", readonly=true, required=true)
    public String targetDirectory;
    @Parameter(alias="skipTests", property="skipTests", defaultValue="false", required=true)
    public boolean skipTests;
    @Parameter(alias="ignoreTestFailures", property="xcode.ignore.test.failures", defaultValue="false", required=true)
    public boolean ignoreFailures;
    @Parameter
    public List<String> testSimulators;
    public ProcessRunner processRunner = new ProcessRunner(this.getLog(), false);

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skipTests) {
            return;
        }
        ArrayList<String> command = new ArrayList<String>();
        command.add(this.xcodebuild);
        command.add("-project");
        command.add(this.xcodeProject);
        command.add("-scheme");
        command.add(this.xcodeScheme);
        if (this.testSimulators == null) {
            this.testSimulators = new ArrayList<String>();
        }
        if (this.testSimulators.isEmpty()) {
            this.testSimulators.add("iPhone 6");
        }
        for (String simulator : this.testSimulators) {
            command.add("-destination");
            command.add("platform=iOS Simulator,name=" + simulator + "");
        }
        command.add("test");
        int resultCode = this.processRunner.runProcess(null, command.toArray(new String[command.size()]));
        if (resultCode != 0 && !this.ignoreFailures) {
            throw new MojoFailureException("There were test failures.");
        }
    }
}

