/*
 * Decompiled with CFR 0.152.
 */
package ca.mestevens.ios;

import ca.mestevens.ios.utils.ProcessRunner;
import ca.mestevens.ios.utils.XcodeProjectUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.FileUtils;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyFilter;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.DependencyRequest;
import org.eclipse.aether.resolution.DependencyResolutionException;

@Mojo(name="framework-dependencies", defaultPhase=LifecyclePhase.INITIALIZE)
public class FrameworkDependenciesMojo
extends AbstractMojo {
    @Parameter(property="project", readonly=true, required=true)
    public MavenProject project;
    @Parameter(defaultValue="${project.remoteProjectRepositories}", readonly=true, required=true)
    public List<RemoteRepository> projectRepos;
    @Component
    public RepositorySystem repoSystem;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true)
    public RepositorySystemSession repoSession;
    @Parameter(alias="xcodeProjectAddDependencies", property="xcode.add.dependencies", defaultValue="false", required=true)
    public boolean addDependencies;
    @Parameter(alias="project", property="xcode.project.path", defaultValue="${basedir}/${project.artifactId}.xcodeproj", required=true)
    public String xcodeProject;
    public ProcessRunner processRunner = new ProcessRunner(this.getLog());

    public void execute() throws MojoExecutionException, MojoFailureException {
        List resolvedArtifacts;
        this.getLog().info((CharSequence)"Starting execution");
        CollectRequest collectRequest = new CollectRequest();
        DefaultArtifact mainArtifact = new DefaultArtifact(this.project.getArtifact().getId());
        collectRequest.setRoot(new Dependency((Artifact)mainArtifact, "compile"));
        collectRequest.setRepositories(this.projectRepos);
        DependencyRequest dependencyRequest = new DependencyRequest().setCollectRequest(collectRequest);
        dependencyRequest.setFilter(new DependencyFilter((Artifact)mainArtifact){
            final /* synthetic */ Artifact val$mainArtifact;
            {
                this.val$mainArtifact = artifact;
            }

            public boolean accept(DependencyNode node, List<DependencyNode> parents) {
                Artifact nodeArtifact = node.getArtifact();
                return !nodeArtifact.getGroupId().equals(this.val$mainArtifact.getGroupId()) || !nodeArtifact.getArtifactId().equals(this.val$mainArtifact.getArtifactId());
            }
        });
        try {
            resolvedArtifacts = this.repoSystem.resolveDependencies(this.repoSession, dependencyRequest).getArtifactResults();
        }
        catch (DependencyResolutionException e) {
            this.getLog().error((CharSequence)"Could not resolve dependencies");
            this.getLog().error((CharSequence)e.getMessage());
            throw new MojoFailureException("Could not resolve dependencies");
        }
        ArrayList<File> dependencyFiles = new ArrayList<File>();
        for (ArtifactResult resolvedArtifact : resolvedArtifacts) {
            Artifact artifact = resolvedArtifact.getArtifact();
            String type = artifact.getProperty("type", "");
            if (!type.equals("xcode-framework") && !type.equals("xcode-library")) continue;
            try {
                File file = artifact.getFile();
                String resultFileName = this.project.getBuild().getDirectory() + "/xcode-dependencies/";
                if (type.equals("xcode-framework")) {
                    resultFileName = resultFileName + "frameworks";
                } else if (type.equals("xcode-library")) {
                    resultFileName = resultFileName + "libraries";
                }
                resultFileName = resultFileName + "/" + artifact.getGroupId() + "/" + artifact.getArtifactId();
                File resultFile = new File(resultFileName);
                if (resultFile.exists()) {
                    FileUtils.deleteDirectory((File)resultFile);
                }
                FileUtils.mkdir((String)resultFile.getAbsolutePath());
                this.processRunner.runProcess(null, "unzip", file.getAbsolutePath(), "-d", resultFile.getAbsolutePath());
                if (type.equals("xcode-framework")) {
                    dependencyFiles.add(new File(resultFile.getAbsolutePath() + "/" + artifact.getArtifactId() + ".framework"));
                    continue;
                }
                if (!type.equals("xcode-library")) continue;
                dependencyFiles.add(new File(resultFile.getAbsolutePath() + "/lib" + artifact.getArtifactId() + ".a"));
            }
            catch (IOException e) {
                this.getLog().error((CharSequence)("Problem creating/deleting framework file: " + artifact.getArtifactId()));
                this.getLog().error((CharSequence)e.getMessage());
                throw new MojoFailureException("Problem creating/deleting framework file: " + artifact.getArtifactId());
            }
        }
        if (this.addDependencies) {
            try {
                XcodeProjectUtil projectUtil = new XcodeProjectUtil(this.xcodeProject + "/project.pbxproj");
                projectUtil.addDependencies(dependencyFiles);
                projectUtil.writeProject();
            }
            catch (Exception ex) {
                throw new MojoFailureException(ex.getMessage());
            }
        }
    }
}

