/*
 * Decompiled with CFR 0.152.
 */
package ca.krasnay.sqlbuilder.orm;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;

public final class ReflectionUtils {
    public static Field[] getDeclaredFieldsInHierarchy(Class<?> clazz) {
        if (clazz.isPrimitive()) {
            throw new IllegalArgumentException("Primitive types not supported.");
        }
        ArrayList<Field> result = new ArrayList<Field>();
        while (clazz != Object.class) {
            result.addAll(Arrays.asList(clazz.getDeclaredFields()));
            clazz = clazz.getSuperclass();
        }
        return result.toArray(new Field[result.size()]);
    }

    public static Field getDeclaredFieldWithPath(Class<?> clazz, String path) {
        int lastDot = path.lastIndexOf(46);
        if (lastDot > -1) {
            String parentPath = path.substring(0, lastDot);
            String fieldName = path.substring(lastDot + 1);
            Field parentField = ReflectionUtils.getDeclaredFieldWithPath(clazz, parentPath);
            return ReflectionUtils.getDeclaredFieldInHierarchy(parentField.getType(), fieldName);
        }
        return ReflectionUtils.getDeclaredFieldInHierarchy(clazz, path);
    }

    public static Field getDeclaredFieldInHierarchy(Class<?> clazz, String fieldName) {
        while (true) {
            try {
                Field field = clazz.getDeclaredField(fieldName);
                field.setAccessible(true);
                return field;
            }
            catch (SecurityException e) {
                throw new RuntimeException(e);
            }
            catch (NoSuchFieldException e) {
                if (clazz == Object.class) {
                    throw new RuntimeException(e);
                }
                clazz = clazz.getSuperclass();
                continue;
            }
            break;
        }
    }

    public static Object getFieldValue(Object object, String fieldName) {
        try {
            return ReflectionUtils.getDeclaredFieldInHierarchy(object.getClass(), fieldName).get(object);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static Object getFieldValueWithPath(Object object, String path) {
        int lastDot = path.lastIndexOf(46);
        if (lastDot > -1) {
            String parentPath = path.substring(0, lastDot);
            String field = path.substring(lastDot + 1);
            Object parentObject = ReflectionUtils.getFieldValueWithPath(object, parentPath);
            if (parentObject == null) {
                return null;
            }
            return ReflectionUtils.getFieldValue(parentObject, field);
        }
        return ReflectionUtils.getFieldValue(object, path);
    }

    public static void setFieldValue(Object object, String fieldName, Object value) {
        try {
            ReflectionUtils.getDeclaredFieldInHierarchy(object.getClass(), fieldName).set(object, value);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static void setFieldValueWithPath(Object object, String path, Object value) throws IllegalStateException {
        int lastDot = path.lastIndexOf(46);
        if (lastDot > -1) {
            String parentPath = path.substring(0, lastDot);
            String field = path.substring(lastDot + 1);
            Object parentObject = ReflectionUtils.getFieldValueWithPath(object, parentPath);
            if (parentObject == null) {
                throw new IllegalStateException(String.format("Null value for %s while accessing %s on object %s", parentPath, path, object));
            }
            ReflectionUtils.setFieldValue(parentObject, field, value);
        } else {
            ReflectionUtils.setFieldValue(object, path, value);
        }
    }
}

