/*
 * Decompiled with CFR 0.152.
 */
package ca.krasnay.sqlbuilder.orm;

import ca.krasnay.sqlbuilder.orm.Converter;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;

public final class LocalDateConverter
implements Converter<LocalDate> {
    private static final LocalDateConverter INSTANCE = new LocalDateConverter();

    public static LocalDateConverter getInstance() {
        return INSTANCE;
    }

    @Override
    public Object convertFieldValueToColumn(LocalDate fieldValue) {
        return fieldValue != null ? new Date(fieldValue.toDateMidnight().getMillis()) : null;
    }

    @Override
    public LocalDate getFieldValueFromResultSet(ResultSet rs, String columnLabel) throws SQLException {
        Timestamp timestamp = rs.getTimestamp(columnLabel);
        if (timestamp == null) {
            return null;
        }
        return new DateTime((Object)timestamp).toLocalDate();
    }
}

