/*
 * Decompiled with CFR 0.152.
 */
package ca.krasnay.sqlbuilder;

import ca.krasnay.sqlbuilder.AbstractSqlBuilder;
import ca.krasnay.sqlbuilder.AbstractSqlCreator;
import ca.krasnay.sqlbuilder.Dialect;
import ca.krasnay.sqlbuilder.ParameterizedPreparedStatementCreator;
import ca.krasnay.sqlbuilder.Predicate;
import ca.krasnay.sqlbuilder.SelectBuilder;
import ca.krasnay.sqlbuilder.SubSelectBuilder;
import ca.krasnay.sqlbuilder.SubSelectCreator;
import ca.krasnay.sqlbuilder.UnionSelectCreator;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.jdbc.core.PreparedStatementCreator;

public class SelectCreator
extends AbstractSqlCreator
implements Cloneable {
    private static final long serialVersionUID = 1L;
    private SelectBuilder builder = new SelectBuilder();

    public SelectCreator() {
    }

    protected SelectCreator(SelectCreator other) {
        super(other);
        this.builder = other.builder.clone();
    }

    public SelectCreator and(String expr) {
        return this.where(expr);
    }

    public SelectCreator and(Predicate predicate) {
        return this.where(predicate);
    }

    public SelectCreator clone() {
        return new SelectCreator(this);
    }

    public SelectCreator column(String name) {
        this.builder.column(name);
        return this;
    }

    public SelectCreator column(String name, boolean groupBy) {
        this.builder.column(name, groupBy);
        return this;
    }

    public PreparedStatementCreator count(final Dialect dialect) {
        return new PreparedStatementCreator(){

            public PreparedStatement createPreparedStatement(Connection con) throws SQLException {
                return SelectCreator.this.getPreparedStatementCreator().setSql(dialect.createCountSelect(SelectCreator.this.builder.toString())).createPreparedStatement(con);
            }
        };
    }

    public SelectCreator distinct() {
        this.builder.distinct();
        return this;
    }

    public SelectCreator forUpdate() {
        this.builder.forUpdate();
        return this;
    }

    public SelectCreator from(String table) {
        this.builder.from(table);
        return this;
    }

    @Override
    protected AbstractSqlBuilder getBuilder() {
        return this.builder;
    }

    public List<UnionSelectCreator> getUnions() {
        ArrayList<UnionSelectCreator> unions = new ArrayList<UnionSelectCreator>();
        for (SelectBuilder unionSB : this.builder.getUnions()) {
            unions.add(new UnionSelectCreator(this, unionSB));
        }
        return unions;
    }

    public SelectCreator groupBy(String expr) {
        this.builder.groupBy(expr);
        return this;
    }

    public SelectCreator having(String expr) {
        this.builder.having(expr);
        return this;
    }

    public SelectCreator join(String join) {
        this.builder.join(join);
        return this;
    }

    public SelectCreator leftJoin(String join) {
        this.builder.leftJoin(join);
        return this;
    }

    public SelectCreator noWait() {
        this.builder.noWait();
        return this;
    }

    public SelectCreator orderBy(String name) {
        this.builder.orderBy(name);
        return this;
    }

    public SelectCreator orderBy(String name, boolean ascending) {
        this.builder.orderBy(name, ascending);
        return this;
    }

    public PreparedStatementCreator page(final Dialect dialect, final int limit, final int offset) {
        return new PreparedStatementCreator(){

            public PreparedStatement createPreparedStatement(Connection con) throws SQLException {
                return SelectCreator.this.getPreparedStatementCreator().setSql(dialect.createPageSelect(SelectCreator.this.builder.toString(), limit, offset)).createPreparedStatement(con);
            }
        };
    }

    @Override
    public SelectCreator setParameter(String name, Object value) {
        super.setParameter(name, value);
        return this;
    }

    public SubSelectCreator subSelectColumn(String alias) {
        SubSelectBuilder subSelectBuilder = new SubSelectBuilder(alias);
        this.builder.column(subSelectBuilder);
        return new SubSelectCreator(this, subSelectBuilder);
    }

    public String toString() {
        ParameterizedPreparedStatementCreator ppsc = this.getPreparedStatementCreator();
        StringBuilder sb = new StringBuilder(this.builder.toString());
        ArrayList<String> params = new ArrayList<String>(ppsc.getParameterMap().keySet());
        Collections.sort(params);
        for (String s : params) {
            sb.append(", ").append(s).append("=").append(ppsc.getParameterMap().get(s));
        }
        return sb.toString();
    }

    public UnionSelectCreator union() {
        SelectBuilder unionSelectBuilder = new SelectBuilder();
        this.builder.union(unionSelectBuilder);
        return new UnionSelectCreator(this, unionSelectBuilder);
    }

    public SelectCreator where(String expr) {
        this.builder.where(expr);
        return this;
    }

    public SelectCreator where(Predicate predicate) {
        predicate.init(this);
        this.builder.where(predicate.toSql());
        return this;
    }

    public SelectCreator whereEquals(String expr, Object value) {
        String param = this.allocateParameter();
        this.builder.where(expr + " = :" + param);
        this.setParameter(param, value);
        return this;
    }

    public SelectCreator whereIn(String expr, List<?> values) {
        StringBuilder sb = new StringBuilder();
        sb.append(expr).append(" in (");
        boolean first = true;
        for (Object value : values) {
            String param = this.allocateParameter();
            this.setParameter(param, value);
            if (!first) {
                sb.append(", ");
            }
            sb.append(":").append(param);
            first = false;
        }
        sb.append(")");
        this.builder.where(sb.toString());
        return this;
    }
}

