/*
 * Decompiled with CFR 0.152.
 */
package ca.krasnay.sqlbuilder;

import ca.krasnay.sqlbuilder.AbstractSqlBuilder;
import ca.krasnay.sqlbuilder.SubSelectBuilder;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectBuilder
extends AbstractSqlBuilder
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    private boolean distinct;
    private List<Object> columns = new ArrayList<Object>();
    private List<String> tables = new ArrayList<String>();
    private List<String> joins = new ArrayList<String>();
    private List<String> leftJoins = new ArrayList<String>();
    private List<String> wheres = new ArrayList<String>();
    private List<String> groupBys = new ArrayList<String>();
    private List<String> havings = new ArrayList<String>();
    private List<SelectBuilder> unions = new ArrayList<SelectBuilder>();
    private List<String> orderBys = new ArrayList<String>();
    private boolean forUpdate;
    private boolean noWait;

    public SelectBuilder() {
    }

    public SelectBuilder(String table) {
        this.tables.add(table);
    }

    protected SelectBuilder(SelectBuilder other) {
        this.distinct = other.distinct;
        this.forUpdate = other.forUpdate;
        this.noWait = other.noWait;
        for (Object column : other.columns) {
            if (column instanceof SubSelectBuilder) {
                this.columns.add(((SubSelectBuilder)column).clone());
                continue;
            }
            this.columns.add(column);
        }
        this.tables.addAll(other.tables);
        this.joins.addAll(other.joins);
        this.leftJoins.addAll(other.leftJoins);
        this.wheres.addAll(other.wheres);
        this.groupBys.addAll(other.groupBys);
        this.havings.addAll(other.havings);
        for (SelectBuilder sb : other.unions) {
            this.unions.add(sb.clone());
        }
        this.orderBys.addAll(other.orderBys);
    }

    public SelectBuilder and(String expr) {
        return this.where(expr);
    }

    public SelectBuilder column(String name) {
        this.columns.add(name);
        return this;
    }

    public SelectBuilder column(SubSelectBuilder subSelect) {
        this.columns.add(subSelect);
        return this;
    }

    public SelectBuilder column(String name, boolean groupBy) {
        this.columns.add(name);
        if (groupBy) {
            this.groupBys.add(name);
        }
        return this;
    }

    public SelectBuilder clone() {
        return new SelectBuilder(this);
    }

    public SelectBuilder distinct() {
        this.distinct = true;
        return this;
    }

    public SelectBuilder forUpdate() {
        this.forUpdate = true;
        return this;
    }

    public SelectBuilder from(String table) {
        this.tables.add(table);
        return this;
    }

    public List<SelectBuilder> getUnions() {
        return this.unions;
    }

    public SelectBuilder groupBy(String expr) {
        this.groupBys.add(expr);
        return this;
    }

    public SelectBuilder having(String expr) {
        this.havings.add(expr);
        return this;
    }

    public SelectBuilder join(String join) {
        this.joins.add(join);
        return this;
    }

    public SelectBuilder leftJoin(String join) {
        this.leftJoins.add(join);
        return this;
    }

    public SelectBuilder noWait() {
        if (!this.forUpdate) {
            throw new RuntimeException("noWait without forUpdate cannot be called");
        }
        this.noWait = true;
        return this;
    }

    public SelectBuilder orderBy(String name) {
        this.orderBys.add(name);
        return this;
    }

    public SelectBuilder orderBy(String name, boolean ascending) {
        if (ascending) {
            this.orderBys.add(name + " asc");
        } else {
            this.orderBys.add(name + " desc");
        }
        return this;
    }

    public String toString() {
        StringBuilder sql = new StringBuilder("select ");
        if (this.distinct) {
            sql.append("distinct ");
        }
        if (this.columns.size() == 0) {
            sql.append("*");
        } else {
            this.appendList(sql, this.columns, "", ", ");
        }
        this.appendList(sql, this.tables, " from ", ", ");
        this.appendList(sql, this.joins, " join ", " join ");
        this.appendList(sql, this.leftJoins, " left join ", " left join ");
        this.appendList(sql, this.wheres, " where ", " and ");
        this.appendList(sql, this.groupBys, " group by ", ", ");
        this.appendList(sql, this.havings, " having ", " and ");
        this.appendList(sql, this.unions, " union ", " union ");
        this.appendList(sql, this.orderBys, " order by ", ", ");
        if (this.forUpdate) {
            sql.append(" for update");
            if (this.noWait) {
                sql.append(" nowait");
            }
        }
        return sql.toString();
    }

    public SelectBuilder union(SelectBuilder unionBuilder) {
        this.unions.add(unionBuilder);
        return this;
    }

    public SelectBuilder where(String expr) {
        this.wheres.add(expr);
        return this;
    }
}

