/*
 * Decompiled with CFR 0.152.
 */
package ca.krasnay.sqlbuilder;

import ca.krasnay.sqlbuilder.AbstractSqlCreator;
import ca.krasnay.sqlbuilder.ExistsPredicate;
import ca.krasnay.sqlbuilder.ExistsPredicateImpl;
import ca.krasnay.sqlbuilder.Predicate;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Predicates {
    public static Predicate all() {
        return Predicates.is("true");
    }

    public static Predicate allBitsSet(final String expr, final long bits) {
        return new Predicate(){
            private String param;

            public void init(AbstractSqlCreator creator) {
                this.param = creator.allocateParameter();
                creator.setParameter(this.param, bits);
            }

            public String toSql() {
                return String.format("(%s & :%s) = :%s", expr, this.param, this.param);
            }
        };
    }

    public static Predicate and(Predicate ... predicates) {
        return Predicates.join("and", Arrays.asList(predicates));
    }

    public static Predicate and(List<Predicate> predicates) {
        return Predicates.join("and", predicates);
    }

    public static Predicate anyBitsSet(final String expr, final long bits) {
        return new Predicate(){
            private String param;

            public void init(AbstractSqlCreator creator) {
                this.param = creator.allocateParameter();
                creator.setParameter(this.param, bits);
            }

            public String toSql() {
                return String.format("(%s & :%s) > 0", expr, this.param);
            }
        };
    }

    public static Predicate eq(final String expr, final Object value) {
        return new Predicate(){
            private String param;

            public void init(AbstractSqlCreator creator) {
                this.param = creator.allocateParameter();
                creator.setParameter(this.param, value);
            }

            public String toSql() {
                return String.format("%s = :%s", expr, this.param);
            }
        };
    }

    public static Predicate in(final String expr, final List<?> values) {
        return new Predicate(){
            private String sql;

            public void init(AbstractSqlCreator creator) {
                StringBuilder sb = new StringBuilder();
                sb.append(expr).append(" in (");
                boolean first = true;
                for (Object value : values) {
                    String param = creator.allocateParameter();
                    creator.setParameter(param, value);
                    if (!first) {
                        sb.append(", ");
                    }
                    sb.append(":").append(param);
                    first = false;
                }
                sb.append(")");
                this.sql = sb.toString();
            }

            public String toSql() {
                return this.sql;
            }
        };
    }

    public static Predicate in(String expr, Object ... values) {
        return Predicates.in(expr, Arrays.asList(values));
    }

    public static Predicate is(final String sql) {
        return new Predicate(){

            public String toSql() {
                return sql;
            }

            public void init(AbstractSqlCreator creator) {
            }
        };
    }

    private static Predicate join(final String joinWord, final List<Predicate> preds) {
        return new Predicate(){

            public void init(AbstractSqlCreator creator) {
                for (Predicate p : preds) {
                    p.init(creator);
                }
            }

            public String toSql() {
                StringBuilder sb = new StringBuilder().append("(");
                boolean first = true;
                for (Predicate p : preds) {
                    if (!first) {
                        sb.append(" ").append(joinWord).append(" ");
                    }
                    sb.append(p.toSql());
                    first = false;
                }
                return sb.append(")").toString();
            }
        };
    }

    public static ExistsPredicate exists(String table) {
        return new ExistsPredicateImpl(table);
    }

    public static Predicate neq(final String expr, final Object value) {
        return new Predicate(){
            private String param;

            public void init(AbstractSqlCreator creator) {
                this.param = creator.allocateParameter();
                creator.setParameter(this.param, value);
            }

            public String toSql() {
                return String.format("%s <> :%s", expr, this.param);
            }
        };
    }

    public static Predicate not(final Predicate childPredicate) {
        return new Predicate(){

            public void init(AbstractSqlCreator creator) {
                childPredicate.init(creator);
            }

            public String toSql() {
                return "not (" + childPredicate.toSql() + ")";
            }
        };
    }

    public static Predicate or(Predicate ... predicates) {
        return Predicates.join("or", Arrays.asList(predicates));
    }

    public static Predicate or(List<Predicate> predicates) {
        return Predicates.join("or", predicates);
    }
}

