/*
 * Decompiled with CFR 0.152.
 */
package ca.krasnay.sqlbuilder;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.PreparedStatementCreator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParameterizedPreparedStatementCreator
implements Cloneable,
PreparedStatementCreator,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(ParameterizedPreparedStatementCreator.class);
    private static final String NAME_REGEX = "[a-z][_a-z0-9]*";
    private static final String PARAM_REGEX = ":([a-z][_a-z0-9]*)";
    private static final Pattern NAME_PATTERN = Pattern.compile("[a-z][_a-z0-9]*", 2);
    private static final Pattern PARAM_PATTERN = Pattern.compile(":([a-z][_a-z0-9]*)", 2);
    private String sql;
    private Map<String, Object> parameterMap = new HashMap<String, Object>();

    public ParameterizedPreparedStatementCreator() {
    }

    protected ParameterizedPreparedStatementCreator(ParameterizedPreparedStatementCreator other) {
        this.sql = other.sql;
        for (String key : other.parameterMap.keySet()) {
            this.parameterMap.put(key, other.parameterMap.get(key));
        }
    }

    public ParameterizedPreparedStatementCreator clone() {
        return new ParameterizedPreparedStatementCreator(this);
    }

    public PreparedStatement createPreparedStatement(Connection con) throws SQLException {
        log.debug("createPreparedStatement: {}", (Object)this.sql);
        for (String key : this.parameterMap.keySet()) {
            log.debug("    {} => {}", (Object)key, this.parameterMap.get(key));
        }
        SqlAndParams sap = this.createSqlAndParams();
        PreparedStatement ps = con.prepareStatement(sap.getSql());
        for (int i = 0; i < sap.getParams().size(); ++i) {
            ps.setObject(i + 1, sap.getParams().get(i));
        }
        return ps;
    }

    SqlAndParams createSqlAndParams() {
        StringBuilder psSql = new StringBuilder();
        ArrayList<Object> paramValues = new ArrayList<Object>();
        Matcher m = PARAM_PATTERN.matcher(this.sql);
        int index = 0;
        while (m.find(index)) {
            psSql.append(this.sql.substring(index, m.start()));
            String name = m.group(1);
            index = m.end();
            if (this.parameterMap.containsKey(name)) {
                psSql.append("?");
                paramValues.add(this.parameterMap.get(name));
                continue;
            }
            throw new IllegalArgumentException("Unknown parameter '" + name + "' at position " + m.start());
        }
        psSql.append(this.sql.substring(index));
        return new SqlAndParams(psSql.toString(), paramValues);
    }

    public Map<String, Object> getParameterMap() {
        return Collections.unmodifiableMap(this.parameterMap);
    }

    public String getSql() {
        return this.sql;
    }

    public ParameterizedPreparedStatementCreator setParameter(String name, Object value) {
        if (!NAME_PATTERN.matcher(name).matches()) {
            throw new IllegalArgumentException("'" + name + "' is not a valid parameter name. Names must start with a letter, and contain only letters, numbers, and underscores.");
        }
        this.parameterMap.put(name, value);
        return this;
    }

    public ParameterizedPreparedStatementCreator setSql(String sql) {
        this.sql = sql;
        return this;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class SqlAndParams {
        private String sql;
        private List<Object> params;

        private SqlAndParams(String sql, List<Object> params) {
            this.sql = sql;
            this.params = params;
        }

        public List<Object> getParams() {
            return this.params;
        }

        public String getSql() {
            return this.sql;
        }
    }
}

