/*
 * Decompiled with CFR 0.152.
 */
package ca.krasnay.scaffold.io;

import ca.krasnay.scaffold.io.FileSink;
import ca.krasnay.scaffold.io.FileSource;
import ca.krasnay.scaffold.io.InputStreamSource;
import ca.krasnay.scaffold.io.OutputStreamSink;
import ca.krasnay.scaffold.io.ResourceSource;
import ca.krasnay.scaffold.io.Sink;
import ca.krasnay.scaffold.io.Source;
import ca.krasnay.scaffold.io.StringSource;
import ca.krasnay.scaffold.io.UrlSource;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URL;

public class IOUtils {
    public static final String UTF_8 = "UTF-8";
    public static final int BYTE_BUFFER_SIZE = 4096;
    public static final int CHAR_BUFFER_SIZE = 4096;

    public static void close(Closeable c) {
        if (c != null) {
            try {
                c.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void copy(Class<?> clazz, String resourceName, OutputStream out) {
        IOUtils.copy(new ResourceSource(clazz, resourceName), new OutputStreamSink(out));
    }

    public static void copy(File in, OutputStream out) {
        IOUtils.copy(new FileSource(in), new OutputStreamSink(out));
    }

    public static void copy(InputStream in, File out) {
        IOUtils.copy(new InputStreamSource(in), new FileSink(out));
    }

    public static void copy(File in, File out) {
        IOUtils.copy(new FileSource(in), new FileSink(out));
    }

    public static void copy(InputStream in, OutputStream out) {
        IOUtils.copy(in, out, 4096);
    }

    public static void copy(InputStream in, OutputStream out, int bufferSize) {
        IOUtils.copy(new InputStreamSource(in), new OutputStreamSink(out), bufferSize);
    }

    public static void copy(Source source, Sink sink) {
        IOUtils.copy(source, sink, 4096);
    }

    public static void copy(Source source, Sink sink, int bufferSize) {
        InputStream in = null;
        OutputStream out = null;
        try {
            int count;
            in = source.getInputStream();
            out = sink.getOutputStream();
            byte[] buffer = new byte[bufferSize];
            while ((count = in.read(buffer)) >= 0) {
                if (count <= 0) continue;
                out.write(buffer, 0, count);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            source.close(in);
            sink.close(out);
        }
    }

    public static void copy(Reader reader, Writer writer) {
        IOUtils.copy(reader, writer, 4096);
    }

    public static void copy(Reader reader, Writer writer, int bufferSize) {
        try {
            int count;
            char[] buffer = new char[bufferSize];
            while ((count = reader.read(buffer)) >= 0) {
                if (count <= 0) continue;
                writer.write(buffer, 0, count);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void copy(String s, OutputStream outputStream) {
        IOUtils.copy(new StringSource(s), new OutputStreamSink(outputStream));
    }

    public static byte[] toByteArray(InputStream inputStream) {
        return IOUtils.toByteArray(new InputStreamSource(inputStream));
    }

    public static byte[] toByteArray(Class<?> clazz, String resource) {
        return IOUtils.toByteArray(new ResourceSource(clazz, resource));
    }

    public static byte[] toByteArray(Source source) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        IOUtils.copy(source, new OutputStreamSink(outputStream));
        return outputStream.toByteArray();
    }

    public static byte[] toByteArray(URL url) {
        return IOUtils.toByteArray(new UrlSource(url));
    }

    public static String toString(Class<?> clazz, String resource, String encoding) {
        return IOUtils.toString(new ResourceSource(clazz, resource), encoding);
    }

    public static String toString(File file, String encoding) {
        return IOUtils.toString(new FileSource(file), encoding);
    }

    public static String toString(InputStream in, String encoding) {
        return IOUtils.toString(new InputStreamSource(in), encoding);
    }

    public static String toString(Source source, String encoding) {
        InputStream in = null;
        try {
            in = source.getInputStream();
            String string = IOUtils.toString(new InputStreamReader(in, encoding));
            return string;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            source.close(in);
        }
    }

    public static String toString(Reader reader) {
        CharArrayWriter caw = new CharArrayWriter();
        IOUtils.copy(reader, caw);
        return caw.toString();
    }

    public static String toString(URL url, String encoding) {
        return IOUtils.toString(new UrlSource(url), encoding);
    }

    public static String toStringUtf8(Class<?> clazz, String resource) {
        return IOUtils.toString(clazz, resource, UTF_8);
    }

    public static String toStringUtf8(File file) {
        return IOUtils.toString(file, UTF_8);
    }

    public static String toStringUtf8(InputStream in) {
        return IOUtils.toString(in, UTF_8);
    }

    public static String toStringUtf8(URL url) {
        return IOUtils.toString(url, UTF_8);
    }
}

