/*
 * Decompiled with CFR 0.152.
 */
package ca.krasnay.scaffold;

import ca.krasnay.scaffold.TemplateParseException;
import ca.krasnay.scaffold.TemplateProcessor;
import java.io.CharArrayWriter;
import java.io.Writer;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;

public class VelocityTemplateProcessor
implements TemplateProcessor {
    private static final Pattern LINE_COL_PATTERN = Pattern.compile("line (\\d+).*column (\\d+)");

    @Override
    public String process(String template, Map<String, Object> map, boolean isHtml) throws TemplateParseException {
        if (template == null) {
            return null;
        }
        VelocityContext ctx = new VelocityContext(map);
        CharArrayWriter writer = new CharArrayWriter();
        try {
            Velocity.evaluate((Context)ctx, (Writer)writer, (String)"template", (String)template);
        }
        catch (Exception ex) {
            Matcher m;
            if (ex.getMessage() != null && (m = LINE_COL_PATTERN.matcher(ex.getMessage())).find()) {
                int line = Integer.parseInt(m.group(1));
                int column = Integer.parseInt(m.group(2));
                throw new TemplateParseException(template, line, column, ex.getMessage());
            }
            throw new RuntimeException(ex);
        }
        return writer.toString();
    }
}

