/*
 * Decompiled with CFR 0.152.
 */
package ca.krasnay.scaffold;

import ca.krasnay.scaffold.TemplateProcessor;
import ca.krasnay.scaffold.VelocityTemplateProcessor;
import ca.krasnay.scaffold.io.FileSink;
import ca.krasnay.scaffold.io.IOUtils;
import ca.krasnay.scaffold.io.StringSource;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.joda.time.LocalDate;

public class Scaffold {
    private Class<?> entityClass;
    private File targetDir;
    private File templateDir;
    private TemplateProcessor templateProcessor;

    public static File getPackageDir(Class<?> clazz) {
        URL url = clazz.getResource(clazz.getSimpleName() + ".class");
        if (!"file".equals(url.getProtocol())) {
            throw new RuntimeException("Can't find package directory for class " + clazz.getName() + ". Cannot run Scaffold from a JAR.");
        }
        return new File(url.getPath()).getParentFile();
    }

    public static File getMavenJavaDir(Class<?> clazz) {
        return new File(Scaffold.getPackageDir(clazz).toString().replace("target/classes", "src/main/java"));
    }

    public static File getMavenResourcesDir(Class<?> clazz) {
        return new File(Scaffold.getPackageDir(clazz).toString().replace("target/classes", "src/main/resources"));
    }

    public Scaffold(Class<?> entityClass) {
        this.entityClass = entityClass;
        this.templateDir = Scaffold.getPackageDir(this.getClass());
        this.targetDir = Scaffold.getMavenJavaDir(entityClass);
        this.templateProcessor = new VelocityTemplateProcessor();
    }

    public Class<?> getEntityClass() {
        return this.entityClass;
    }

    public Map<String, Object> getMergeFields() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        String packageName = this.entityClass.getPackage().getName();
        String entityName = this.entityClass.getSimpleName();
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Field field : this.entityClass.getDeclaredFields()) {
            if (Modifier.isStatic(field.getModifiers())) continue;
            fields.add(field);
        }
        map.put("package", packageName);
        map.put("Entity", entityName);
        map.put("entity", entityName.substring(0, 1).toLowerCase() + entityName.substring(1));
        map.put("fields", fields);
        map.put("date", new LocalDate().toString());
        map.put("scaffold", this);
        return map;
    }

    public Scaffold render(String templateName, String outFileName) {
        Map<String, Object> mergeFields = this.getMergeFields();
        File outFile = new File(this.targetDir, this.templateProcessor.process(outFileName, mergeFields, false));
        if (outFile.exists()) {
            System.out.println("Skipping " + outFile + ": already exists");
        } else {
            System.out.println("Creating " + outFile);
            outFile.getParentFile().mkdirs();
            String template = IOUtils.toStringUtf8(new File(this.templateDir, this.templateProcessor.process(templateName, mergeFields, false)));
            String output = this.templateProcessor.process(template, mergeFields, false);
            IOUtils.copy(new StringSource(output), new FileSink(outFile));
        }
        return this;
    }

    public Scaffold setTargetDir(File targetDir) {
        this.targetDir = targetDir;
        return this;
    }
}

