/*
 * Decompiled with CFR 0.152.
 */
package ca.jimr.gae.profiler;

import java.io.Closeable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;

public class MiniProfiler {
    private static final ThreadLocal<Root> PROFILER_STEPS = new ThreadLocal();

    protected static void start() {
        PROFILER_STEPS.set(new Root());
    }

    protected static Profile stop() {
        Root result = PROFILER_STEPS.get();
        PROFILER_STEPS.remove();
        return result != null ? result.popData() : null;
    }

    public static Step step(String stepName) {
        Root root = PROFILER_STEPS.get();
        if (root != null) {
            Profile data = new Profile(root.nextId(), stepName);
            return new Step(root, data);
        }
        return new Step(null, null);
    }

    public static class Step
    implements Closeable {
        private Root root;

        public Step(Root root, Profile data) {
            this.root = root;
            if (root != null) {
                root.pushData(data);
            }
        }

        @Override
        public void close() {
            if (this.root != null) {
                this.root.popData();
            }
        }
    }

    private static class Root
    implements Serializable {
        private static final long serialVersionUID = -7244418353632893875L;
        private int count = 0;
        private Profile root = new Profile(this.count++, "Request");
        private Stack<Profile> stack = new Stack();

        public Root() {
            this.root.setStart(System.nanoTime());
            this.stack.push(this.root);
        }

        public int nextId() {
            return this.count++;
        }

        public void pushData(Profile d) {
            long now = System.nanoTime();
            d.setDepth(this.stack.size());
            d.setStart(now);
            d.setOffset(now - this.root.getStart());
            this.stack.peek().addChild(d);
            this.stack.push(d);
        }

        public Profile popData() {
            long now = System.nanoTime();
            Profile d = this.stack.pop();
            d.setDuration(now - d.getStart());
            return d;
        }
    }

    protected static class Profile
    implements Serializable {
        private static final long serialVersionUID = 6373761607106996570L;
        private int id;
        private int depth;
        private String name;
        private long start;
        private long duration;
        private long offset;
        private List<Profile> children = new ArrayList<Profile>();

        public Profile(int id, String name) {
            this.id = id;
            this.name = name;
        }

        public long getId() {
            return this.id;
        }

        public int getDepth() {
            return this.depth;
        }

        public void setDepth(int depth) {
            this.depth = depth;
        }

        public String getName() {
            return this.name;
        }

        public long getStart() {
            return this.start;
        }

        public void setStart(long start) {
            this.start = start;
        }

        public void setDuration(long duration) {
            this.duration = duration;
        }

        public long getDuration() {
            return this.duration;
        }

        public void setOffset(long offset) {
            this.offset = offset;
        }

        public long getOffset() {
            return this.offset;
        }

        public long getSelf() {
            long result = this.duration;
            for (Profile p : this.children) {
                result -= p.duration;
            }
            return result;
        }

        public List<Profile> getChildren() {
            return this.children;
        }

        public void addChild(Profile child) {
            this.children.add(child);
        }
    }
}

