/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.appstats;

import com.google.appengine.api.memcache.MemcacheServiceFactory;
import com.google.appengine.tools.appstats.MemcacheWriter;
import com.google.appengine.tools.appstats.StatsProtos;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class MiniProfilerAppstats {
    public static Map<String, Object> getAppstatsDataFor(String appstatsId, Integer maxStackFrames) {
        HashMap<String, Serializable> appstatsMap = null;
        MemcacheWriter writer = new MemcacheWriter(null, MemcacheServiceFactory.getMemcacheService((String)"__appstats__"));
        StatsProtos.RequestStatProto appstats = writer.getFull(Long.parseLong(appstatsId));
        if (appstats != null) {
            appstatsMap = new HashMap<String, Serializable>();
            appstatsMap.put("totalTime", Long.valueOf(appstats.getDurationMilliseconds()));
            LinkedHashMap<String, LinkedHashMap<String, Long>> rpcInfoMap = new LinkedHashMap<String, LinkedHashMap<String, Long>>();
            for (StatsProtos.AggregateRpcStatsProto rpcStat : appstats.getRpcStatsList()) {
                LinkedHashMap<String, Long> rpcInfo = (LinkedHashMap<String, Long>)rpcInfoMap.get(rpcStat.getServiceCallName());
                if (rpcInfo == null) {
                    rpcInfo = new LinkedHashMap<String, Long>();
                    rpcInfoMap.put(rpcStat.getServiceCallName(), rpcInfo);
                }
                rpcInfo.put("totalCalls", rpcStat.getTotalAmountOfCalls());
                rpcInfo.put("totalTime", 0L);
            }
            ArrayList callInfoMap = new ArrayList();
            for (StatsProtos.IndividualRpcStatsProto rpcStat : appstats.getIndividualStatsList()) {
                Map rpcInfo = (Map)rpcInfoMap.get(rpcStat.getServiceCallName());
                rpcInfo.put("totalTime", (Long)rpcInfo.get("totalTime") + rpcStat.getDurationMilliseconds());
                LinkedHashMap<String, Object> callInfo = new LinkedHashMap<String, Object>();
                callInfoMap.add(callInfo);
                callInfo.put("serviceCallName", rpcStat.getServiceCallName());
                callInfo.put("totalTime", rpcStat.getDurationMilliseconds());
                callInfo.put("startOffset", rpcStat.getStartOffsetMilliseconds());
                callInfo.put("request", MiniProfilerAppstats.truncate(rpcStat.getRequestDataSummary(), 100));
                callInfo.put("response", MiniProfilerAppstats.truncate(rpcStat.getResponseDataSummary(), 100));
                ArrayList<String> callStack = new ArrayList<String>();
                int i = 0;
                for (StatsProtos.StackFrameProto frame : rpcStat.getCallStackList()) {
                    if (maxStackFrames != null && i == maxStackFrames) break;
                    callStack.add(String.format("%s.%s:%d", frame.getClassOrFileName(), frame.getFunctionName(), frame.getLineNumber()));
                    ++i;
                }
                callInfo.put("callStack", callStack);
            }
            appstatsMap.put("rpcStats", !rpcInfoMap.isEmpty() ? rpcInfoMap : null);
            appstatsMap.put("rpcCalls", !callInfoMap.isEmpty() ? callInfoMap : null);
        }
        return appstatsMap;
    }

    private static String truncate(String s, int maxLength) {
        if (s.length() > maxLength) {
            return s.substring(0, maxLength);
        }
        return s;
    }
}

