/*
 * Decompiled with CFR 0.152.
 */
package ca.jimr.gae.profiler;

import ca.jimr.gae.profiler.resources.MiniProfilerResourceLoader;
import com.google.appengine.api.memcache.MemcacheService;
import com.google.appengine.api.memcache.MemcacheServiceFactory;
import com.google.appengine.tools.appstats.MiniProfilerAppstats;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;

public class MiniProfilerServlet
extends HttpServlet {
    private static final long serialVersionUID = 7906645907029238585L;
    private static final String MAX_STACK_FRAMES_KEY = "maxStackFrames";
    private static final String HTML_ID_PREFIX_KEY = "htmlIdPrefix";
    private static final String RESOURCE_CACHE_HOURS_KEY = "resourceCacheHours";
    private Integer maxStackFrames;
    private String htmlIdPrefix = "mp";
    private int resourceCacheHours = 0;
    private MiniProfilerResourceLoader resourceLoader;
    private Map<String, String> resourceReplacements = new HashMap<String, String>();
    private MemcacheService ms;

    public void init(ServletConfig config) throws ServletException {
        String configResourceCacheHours;
        String configHtmlIdPrefix;
        String configMaxStackFrames = config.getInitParameter(MAX_STACK_FRAMES_KEY);
        if (!MiniProfilerServlet.isEmpty(configMaxStackFrames)) {
            this.maxStackFrames = Integer.valueOf(configMaxStackFrames);
        }
        if (!MiniProfilerServlet.isEmpty(configHtmlIdPrefix = config.getInitParameter(HTML_ID_PREFIX_KEY))) {
            this.htmlIdPrefix = configHtmlIdPrefix.trim();
        }
        if (!MiniProfilerServlet.isEmpty(configResourceCacheHours = config.getInitParameter(RESOURCE_CACHE_HOURS_KEY))) {
            this.resourceCacheHours = Integer.parseInt(configResourceCacheHours);
        }
        this.ms = MemcacheServiceFactory.getMemcacheService((String)"mini_profile");
        this.resourceLoader = new MiniProfilerResourceLoader();
        this.resourceReplacements.put("@@prefix@@", this.htmlIdPrefix);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String requestURI = req.getRequestURI();
        if (requestURI.endsWith("results")) {
            this.doResults(req, resp);
        } else if (requestURI.endsWith("resource")) {
            this.doResource(req, resp);
        }
    }

    private void doResource(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        boolean success = true;
        String resource = req.getParameter("id");
        if (!MiniProfilerServlet.isEmpty(resource)) {
            if (resource.endsWith(".js")) {
                resp.setContentType("text/javascript");
            } else if (resource.endsWith(".css")) {
                resp.setContentType("text/css");
            } else if (resource.endsWith(".html")) {
                resp.setContentType("text/html");
            } else {
                resp.setContentType("text/plain");
            }
            String contents = this.resourceLoader.getResource(resource, this.resourceReplacements);
            if (contents != null) {
                if (this.resourceCacheHours > 0) {
                    Calendar c = Calendar.getInstance();
                    c.add(10, this.resourceCacheHours);
                    resp.setHeader("Cache-Control", "public, must-revalidate");
                    resp.setHeader("Expires", new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz").format(c.getTime()));
                } else {
                    resp.setHeader("Cache-Control", "no-cache");
                }
                PrintWriter w = resp.getWriter();
                w.print(contents);
            } else {
                success = false;
            }
        }
        if (!success) {
            resp.sendError(404);
        }
    }

    private void doResults(HttpServletRequest req, HttpServletResponse resp) throws IOException, JsonGenerationException, JsonMappingException {
        HashMap<String, Serializable> result = new HashMap<String, Serializable>();
        String requestIds = req.getParameter("ids");
        if (!MiniProfilerServlet.isEmpty(requestIds)) {
            ArrayList requests = new ArrayList();
            String[] stringArray = requestIds.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String requestId = stringArray[n2];
                Map requestData = (Map)this.ms.get((Object)String.format("mini_profile_request_%s", requestId = requestId.trim()));
                if (requestData != null) {
                    HashMap<String, Object> request = new HashMap<String, Object>();
                    request.put("id", requestId);
                    request.put("redirect", requestData.get("redirect"));
                    request.put("requestURL", requestData.get("requestURL"));
                    request.put("timestamp", requestData.get("timestamp"));
                    request.put("profile", requestData.get("profile"));
                    if (requestData.containsKey("appstatsId")) {
                        Map<String, Object> appstatsMap = MiniProfilerAppstats.getAppstatsDataFor((String)requestData.get("appstatsId"), this.maxStackFrames);
                        request.put("appstats", appstatsMap != null ? appstatsMap : null);
                    } else {
                        request.put("appstats", null);
                    }
                    requests.add(request);
                }
                ++n2;
            }
            result.put("ok", Boolean.valueOf(true));
            result.put("requests", requests);
        } else {
            result.put("ok", Boolean.valueOf(false));
        }
        resp.setContentType("application/json");
        resp.setHeader("Cache-Control", "no-cache");
        ObjectMapper jsonMapper = new ObjectMapper();
        jsonMapper.writeValue((OutputStream)resp.getOutputStream(), result);
    }

    private static boolean isEmpty(String str) {
        return str == null || str.trim().length() == 0;
    }
}

