/*
 * Decompiled with CFR 0.152.
 */
package ca.jimr.gae.profiler;

import ca.jimr.gae.profiler.MiniProfiler;
import ca.jimr.gae.profiler.resources.MiniProfilerResourceLoader;
import com.google.appengine.api.memcache.Expiration;
import com.google.appengine.api.memcache.MemcacheService;
import com.google.appengine.api.memcache.MemcacheServiceFactory;
import com.google.appengine.api.users.UserService;
import com.google.appengine.api.users.UserServiceFactory;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

public class MiniProfilerFilter
implements Filter {
    public static final String MEMCACHE_NAMESPACE = "mini_profile";
    public static final String MEMCACHE_KEY_FORMAT_STRING = "mini_profile_request_%s";
    public static final String REQUEST_ID_HEADER = "X-Mini-Profile-Request-Id";
    public static final String REQUEST_ID_PARAM_REDIRECT = "_mprid_";
    public static final String REQUEST_ID_ATTRIBUTE = "mini_profile_request_id";
    public static final String INCLUDES_ATTRIBUTE = "mini_profile_includes";
    protected static final String PROFILE_SERVLET_URL_KEY = "servletURL";
    protected static final String RESTRICT_TO_ADMINS_KEY = "restrictToAdmins";
    protected static final String RESTRICT_TO_EMAILS_KEY = "restrictToEmails";
    protected static final String RESTRICT_TO_URLS_KEY = "restrictToURLs";
    protected static final String DATA_EXPIRY_KEY = "dataExpiry";
    protected static final String HTML_ID_PREFIX_KEY = "htmlIdPrefix";
    private static final String APPSTATS_HEADER = "X-TraceUrl";
    private static final String APPSTATS_ID_PARAM = "time";
    private boolean restricted = false;
    private boolean restrictedToAdmins = false;
    private Set<String> restrictedEmails = new HashSet<String>();
    private Set<Pattern> restrictedURLs = new HashSet<Pattern>();
    private String servletURL = "/gae_mini_profile/";
    private int dataExpiry = 30;
    private String htmlIdPrefix = "mp";
    private MiniProfilerResourceLoader resourceLoader;
    private Map<String, String> resourceReplacements = new HashMap<String, String>();
    private MemcacheService ms;
    private UserService us;
    private AtomicLong counter;

    public void init(FilterConfig config) throws ServletException {
        String configHtmlIdPrefix;
        String configRestrictToURLs;
        String configDataExpiry;
        int n;
        String configRestrictToEmails;
        String configRestrictToAdmins;
        String configServletURL = config.getInitParameter(PROFILE_SERVLET_URL_KEY);
        if (!MiniProfilerFilter.isEmpty(configServletURL)) {
            this.servletURL = configServletURL;
        }
        if (!MiniProfilerFilter.isEmpty(configRestrictToAdmins = config.getInitParameter(RESTRICT_TO_ADMINS_KEY)) && Boolean.parseBoolean(configRestrictToAdmins)) {
            this.restricted = true;
            this.restrictedToAdmins = true;
        }
        if (!MiniProfilerFilter.isEmpty(configRestrictToEmails = config.getInitParameter(RESTRICT_TO_EMAILS_KEY))) {
            String[] emails;
            this.restricted = true;
            String[] stringArray = emails = configRestrictToEmails.split(",");
            n = emails.length;
            int n2 = 0;
            while (n2 < n) {
                String email = stringArray[n2];
                this.restrictedEmails.add(email.trim());
                ++n2;
            }
        }
        if (!MiniProfilerFilter.isEmpty(configDataExpiry = config.getInitParameter(DATA_EXPIRY_KEY))) {
            this.dataExpiry = Integer.parseInt(configDataExpiry);
        }
        if (!MiniProfilerFilter.isEmpty(configRestrictToURLs = config.getInitParameter(RESTRICT_TO_URLS_KEY))) {
            String[] stringArray = configRestrictToURLs.split(",");
            int n3 = stringArray.length;
            n = 0;
            while (n < n3) {
                String urlPattern = stringArray[n];
                if (!MiniProfilerFilter.isEmpty(urlPattern = urlPattern.trim())) {
                    this.restrictedURLs.add(Pattern.compile(urlPattern));
                }
                ++n;
            }
        }
        if (!MiniProfilerFilter.isEmpty(configHtmlIdPrefix = config.getInitParameter(HTML_ID_PREFIX_KEY))) {
            this.htmlIdPrefix = configHtmlIdPrefix.trim();
        }
        this.ms = MemcacheServiceFactory.getMemcacheService((String)MEMCACHE_NAMESPACE);
        this.us = UserServiceFactory.getUserService();
        this.counter = new AtomicLong(1L);
        this.resourceLoader = new MiniProfilerResourceLoader();
        this.resourceReplacements.put("@@baseURL@@", this.servletURL);
        this.resourceReplacements.put("@@prefix@@", this.htmlIdPrefix);
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest sReq, ServletResponse sRes, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)sReq;
        HttpServletResponse res = (HttpServletResponse)sRes;
        if (this.shouldProfile(req.getRequestURI())) {
            String queryString = req.getQueryString();
            String requestId = String.valueOf(this.counter.incrementAndGet());
            String redirectRequestIds = null;
            if (!MiniProfilerFilter.isEmpty(queryString)) {
                String[] parts;
                String[] stringArray = parts = queryString.split("&");
                int n = parts.length;
                int n2 = 0;
                while (n2 < n) {
                    String part = stringArray[n2];
                    String[] nameValue = part.split("=");
                    if (REQUEST_ID_PARAM_REDIRECT.equals(nameValue[0])) {
                        redirectRequestIds = nameValue[1];
                        break;
                    }
                    ++n2;
                }
            }
            req.setAttribute(REQUEST_ID_ATTRIBUTE, (Object)requestId);
            res.addHeader(REQUEST_ID_HEADER, redirectRequestIds != null ? String.valueOf(redirectRequestIds) + "," + requestId : requestId);
            this.addIncludes(req);
            ResponseWrapper resWrapper = new ResponseWrapper(res, requestId, redirectRequestIds);
            MiniProfiler.Profile profile = null;
            long startTime = System.currentTimeMillis();
            MiniProfiler.start();
            try {
                chain.doFilter(sReq, (ServletResponse)resWrapper);
            }
            finally {
                profile = MiniProfiler.stop();
            }
            HashMap<String, Object> requestData = new HashMap<String, Object>();
            requestData.put("requestURL", String.valueOf(req.getRequestURI()) + (req.getQueryString() != null ? "?" + req.getQueryString() : ""));
            requestData.put("timestamp", startTime);
            requestData.put("redirect", resWrapper.getDidRedirect());
            String appstatsId = resWrapper.getAppstatsId();
            if (appstatsId != null) {
                requestData.put("appstatsId", appstatsId);
            }
            requestData.put("profile", profile);
            this.ms.put((Object)String.format(MEMCACHE_KEY_FORMAT_STRING, requestId), requestData, Expiration.byDeltaSeconds((int)this.dataExpiry));
        } else {
            chain.doFilter(sReq, sRes);
        }
    }

    private void addIncludes(HttpServletRequest req) {
        String includesTemplate;
        String result = null;
        String requestId = (String)req.getAttribute(REQUEST_ID_ATTRIBUTE);
        if (requestId != null && (includesTemplate = this.resourceLoader.getResource("mini_profiler.html", this.resourceReplacements)) != null) {
            result = includesTemplate.replace("@@requestId@@", requestId);
        }
        if (!MiniProfilerFilter.isEmpty(result)) {
            req.setAttribute(INCLUDES_ATTRIBUTE, result);
        }
    }

    public boolean shouldProfile(String url) {
        if (url.startsWith(this.servletURL)) {
            return false;
        }
        if (!this.restrictedURLs.isEmpty()) {
            boolean matches = false;
            for (Pattern p : this.restrictedURLs) {
                if (!p.matcher(url).find()) continue;
                matches = true;
            }
            if (!matches) {
                return false;
            }
        }
        if (this.restricted) {
            if (this.us.isUserLoggedIn()) {
                if (this.restrictedToAdmins && !this.us.isUserAdmin()) {
                    return false;
                }
                if (!this.restrictedEmails.isEmpty() && !this.restrictedEmails.contains(this.us.getCurrentUser().getEmail())) {
                    return false;
                }
            } else {
                return false;
            }
        }
        return true;
    }

    private static boolean isEmpty(String str) {
        return str == null || str.trim().length() == 0;
    }

    private static String urlEncode(String str) {
        try {
            return str != null ? URLEncoder.encode(str, "UTF-8") : str;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private static class ResponseWrapper
    extends HttpServletResponseWrapper {
        private String appstatsId;
        private String requestId;
        private String redirectRequestIds;
        private boolean didRedirect;

        public ResponseWrapper(HttpServletResponse response, String requestId, String redirectRequestIds) {
            super(response);
            this.requestId = requestId;
            this.redirectRequestIds = redirectRequestIds;
            this.didRedirect = false;
        }

        public String getAppstatsId() {
            return this.appstatsId;
        }

        public boolean getDidRedirect() {
            return this.didRedirect;
        }

        public void addHeader(String name, String value) {
            if (MiniProfilerFilter.APPSTATS_HEADER.equalsIgnoreCase(name) && !MiniProfilerFilter.isEmpty(value)) {
                String[] parts;
                String[] stringArray = parts = value.split("\\?")[1].split("&");
                int n = parts.length;
                int n2 = 0;
                while (n2 < n) {
                    String part = stringArray[n2];
                    String[] nameValue = part.split("=");
                    if (MiniProfilerFilter.APPSTATS_ID_PARAM.equals(nameValue[0])) {
                        this.appstatsId = nameValue[1];
                    }
                    ++n2;
                }
            }
            super.addHeader(name, value);
        }

        public void sendRedirect(String location) throws IOException {
            this.didRedirect = true;
            if (!MiniProfilerFilter.isEmpty(location)) {
                location = String.format("%s%s%s=%s", location, location.indexOf("?") >= 0 ? "&" : "?", MiniProfilerFilter.REQUEST_ID_PARAM_REDIRECT, MiniProfilerFilter.urlEncode(this.redirectRequestIds != null ? String.valueOf(this.redirectRequestIds) + "," + this.requestId : this.requestId));
            }
            super.sendRedirect(location);
        }
    }
}

